/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class TimeDelta {
    public static final int PRECISION_MS = 0;
    public static final int PRECISION_SECONDS = 1;
    public static final int PRECISION_MINUTES = 2;
    public static final int PRECISION_HOURS = 3;
    public static final long NANO_MS = 1000000L;
    public static final long NANO_SECOND = 1000000000L;
    public static final long MS_SECOND = 1000L;
    public static final long MS_MINUTE = 60000L;
    public static final long MS_HOUR = 3600000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_MONTH = 2592000000L;
    public static final long MS_YEAR = 31536000000L;
    public static final long[] ARR = new long[]{60000L, 300000L, 1800000L, 3600000L};
    private long time;
    private int precision;

    public TimeDelta(long l) {
        this.time = l;
        this.precision = 1;
    }

    public TimeDelta(long l, int n) {
        this.time = l;
        this.precision = n;
    }

    public TimeDelta(int n) {
        this.precision = n;
    }

    public static void main(String[] stringArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(0L);
        arrayList.add(1L);
        arrayList.add(1120L);
        arrayList.add(60000L);
        arrayList.add(101010101L);
        arrayList.add(100000000001L);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            System.out.println(TimeDelta.toString(l, 0));
        }
    }

    public String format(long l) {
        return TimeDelta.toString(l, this.precision);
    }

    public String format(Date date) {
        return TimeDelta.toString(date.getTime(), this.precision);
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public String toString() {
        return TimeDelta.toString(this.time, this.precision);
    }

    public static String toString(long l) {
        int n = 0;
        if (l > 31536000000L) {
            n = 3;
        } else if (l > 86400000L) {
            n = 2;
        } else if (l > 3600000L) {
            n = 1;
        }
        return TimeDelta.toString(l, n);
    }

    public static String toString(long l, int n) {
        String string;
        String string2 = "";
        if (l == 0L) {
            return l + " Millisec";
        }
        long l2 = l;
        if (l2 / 31536000000L >= 1L) {
            string = "";
            string = l2 / 31536000000L == 1L ? "1 Year " : l2 / 31536000000L + " Years ";
            string2 = string2 + string;
            l2 -= 31536000000L * (l2 / 31536000000L);
        }
        if (l2 / 86400000L >= 1L) {
            string = "";
            string = l2 / 86400000L == 1L ? "1 Day " : l2 / 86400000L + " Days ";
            string2 = string2 + string;
            l2 -= 86400000L * (l2 / 86400000L);
        }
        if (l2 / 3600000L >= 1L) {
            string = "";
            string = l2 / 3600000L == 1L ? "1 Hour " : l2 / 3600000L + " Hours ";
            string2 = string2 + string;
            l2 -= 3600000L * (l2 / 3600000L);
        }
        if (n == 3) {
            return string2.trim();
        }
        if (l2 / 60000L >= 1L) {
            string = "";
            string = l2 / 60000L == 1L ? "1 Minute " : l2 / 60000L + " Minutes ";
            string2 = string2 + string;
            l2 -= 60000L * (l2 / 60000L);
        }
        if (n == 2) {
            return string2.trim();
        }
        if (l2 / 1000L >= 1L) {
            string = "";
            string = l2 / 1000L == 1L ? "1 Second" : l2 / 1000L + " Seconds";
            string2 = string2 + string;
            l2 -= 1000L * (l2 / 1000L);
        }
        if (n == 1) {
            return string2.trim();
        }
        if (l2 > 0L) {
            string = " " + l2 + " Millisec";
            string2 = string2 + string;
        }
        return string2.trim();
    }

    public static boolean isOlderThanOneWeek(long l) {
        return TimeDelta.isOlderThanDays(l, 7);
    }

    public static boolean isOlderThanDays(long l, int n) {
        boolean bl = false;
        long l2 = new Date().getTime() - l;
        if (l2 > 86400000L * (long)n) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOlderThanMilliseconds(long l, long l2) {
        boolean bl = false;
        long l3 = new Date().getTime() - l;
        if (l3 > l2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOlderThanHours(long l, int n) {
        boolean bl = false;
        long l2 = new Date().getTime() - l;
        if (l2 > 3600000L * (long)n) {
            bl = true;
        }
        return bl;
    }
}

