/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.FastSpline;

public class SmoothingSplineInterpolator {
    private double lambda = 0.0;
    private double[] sigma = null;
    private double residuals;
    private double smoothing;

    private static void quincunx(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n2;
        dArray[0] = 0.0;
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        for (n2 = 1; n2 <= n - 1; ++n2) {
            dArray[n2] = dArray[n2] - (n2 - 2 >= 0 ? dArray[n2 - 2] * SmoothingSplineInterpolator.sqr(dArray3[n2 - 2]) : 0.0) - dArray[n2 - 1] * SmoothingSplineInterpolator.sqr(dArray2[n2 - 1]);
            dArray2[n2] = (dArray2[n2] - dArray[n2 - 1] * dArray2[n2 - 1] * dArray3[n2 - 1]) / dArray[n2];
            dArray3[n2] = dArray3[n2] / dArray[n2];
        }
        dArray4[0] = 0.0;
        for (n2 = 1; n2 <= n - 1; ++n2) {
            dArray4[n2] = dArray4[n2] - dArray2[n2 - 1] * dArray4[n2 - 1] - (n2 - 2 >= 0 ? dArray3[n2 - 2] * dArray4[n2 - 2] : 0.0);
        }
        for (n2 = 1; n2 <= n - 1; ++n2) {
            dArray4[n2] = dArray4[n2] / dArray[n2];
        }
        dArray4[n - 1] = dArray4[n - 1];
        dArray4[n - 2] = dArray4[n - 2] - dArray2[n - 2] * dArray4[n - 2 + 1];
        for (n2 = n - 3; n2 >= 1; --n2) {
            dArray4[n2] = dArray4[n2] - dArray2[n2] * dArray4[n2 + 1] - dArray3[n2] * dArray4[n2 + 2];
        }
    }

    public FastSpline interpolate(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Dataset arrays must have same length.");
        }
        if (dArray.length < 3) {
            throw new IllegalArgumentException("At least 3 datapoints are required to compute a spline interpolant");
        }
        if (this.sigma != null && this.sigma.length != dArray.length) {
            throw new IllegalArgumentException("Sigma and dataset arrays must have same length");
        }
        for (n3 = 0; n3 < dArray.length - 1; ++n3) {
            if (!(dArray[n3 + 1] <= dArray[n3])) continue;
            throw new IllegalArgumentException("the X must be strictly increasing");
        }
        n3 = dArray.length;
        double[] dArray3 = new double[n3 - 1];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        double[] dArray9 = new double[n3];
        double[] dArray10 = new double[n3];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            dArray3[n2] = dArray[n2 + 1] - dArray[n2];
            dArray4[n2] = 3.0 / dArray3[n2];
        }
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            dArray5[n2] = -(dArray4[n2 - 1] + dArray4[n2]);
            dArray6[n2] = 2.0 * (dArray[n2 + 1] - dArray[n2 - 1]);
            dArray7[n2] = 3.0 * (dArray2[n2 + 1] - dArray2[n2]) / dArray3[n2] - 3.0 * (dArray2[n2] - dArray2[n2 - 1]) / dArray3[n2 - 1];
        }
        dArray4[n3 - 1] = 0.0;
        dArray5[n3 - 1] = 0.0;
        for (n2 = 1; n2 <= n3 - 1; ++n2) {
            dArray8[n2] = SmoothingSplineInterpolator.sqr(dArray4[n2 - 1]) * this.sigma(n2 - 1) + SmoothingSplineInterpolator.sqr(dArray5[n2]) * this.sigma(n2) + SmoothingSplineInterpolator.sqr(dArray4[n2]) * this.sigma(n2 + 1);
            dArray8[n2] = this.lambda * dArray8[n2] + dArray6[n2];
            if (n2 < n3 - 1) {
                dArray9[n2] = dArray5[n2] * dArray4[n2] * this.sigma(n2) + dArray4[n2] * dArray5[n2 + 1] * this.sigma(n2 + 1);
            }
            if (n2 < n3 - 1) {
                dArray9[n2] = this.lambda * dArray9[n2] + dArray3[n2];
            }
            if (n2 >= n3 - 1) continue;
            dArray10[n2] = this.lambda * dArray4[n2] * dArray4[n2 + 1] * this.sigma(n2 + 1);
        }
        SmoothingSplineInterpolator.quincunx(n3, dArray8, dArray9, dArray10, dArray7);
        this.smoothing = 0.0;
        this.residuals = 0.0;
        double[] dArray11 = new double[n3];
        double[] dArray12 = new double[n3];
        double[] dArray13 = new double[n3];
        double[] dArray14 = new double[n3];
        dArray14[0] = dArray2[0] - this.lambda * dArray4[0] * dArray7[1] * this.sigma(0);
        dArray14[1] = dArray2[1] - this.lambda * (dArray5[1] * dArray7[1] + dArray4[1] * dArray7[2]) * this.sigma(1);
        dArray11[0] = dArray7[1] / (3.0 * dArray3[0]);
        dArray12[0] = 0.0;
        dArray13[0] = (dArray14[1] - dArray14[0]) / dArray3[0] - dArray7[1] * dArray3[0] / 3.0;
        dArray4[0] = 0.0;
        for (n = 1; n < n3 - 1; ++n) {
            dArray11[n] = (dArray7[n + 1] - dArray7[n]) / (3.0 * dArray3[n]);
            dArray12[n] = dArray7[n];
            dArray13[n] = (dArray7[n] + dArray7[n - 1]) * dArray3[n - 1] + dArray13[n - 1];
            dArray14[n] = dArray4[n - 1] * dArray7[n - 1] + dArray5[n] * dArray7[n] + dArray4[n] * dArray7[n + 1];
            dArray14[n] = dArray2[n] - this.lambda * dArray14[n] * this.sigma(n);
        }
        for (n = 0; n < n3 - 1; ++n) {
            if (this.sigma(n) > 0.0) {
                this.residuals += (dArray14[n] - dArray2[n]) * (dArray14[n] - dArray2[n]) / (this.sigma(n) * this.sigma(n));
            }
            this.smoothing += dArray11[n] * dArray11[n];
        }
        FastSpline.Polynome[] polynomeArray = new FastSpline.Polynome[n3 - 1];
        for (int i = 0; i < polynomeArray.length; ++i) {
            polynomeArray[i] = new FastSpline.Polynome(new double[]{dArray14[i], dArray13[i], dArray12[i], dArray11[i]});
        }
        return new FastSpline(dArray, polynomeArray);
    }

    public double getResiduals() {
        return this.residuals;
    }

    public double getSmoothing() {
        return this.smoothing;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double[] getSigma() {
        return this.sigma;
    }

    public void setLambda(double d) {
        this.lambda = d;
    }

    public void setSigma(double[] dArray) {
        this.sigma = dArray;
    }

    private static final double sqr(double d) {
        return d * d;
    }

    private final double sigma(int n) {
        if (this.sigma == null || n >= this.sigma.length) {
            return 1.0;
        }
        return this.sigma[n];
    }
}

