/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

public class DoubleFormat {
    private static String[] ZEROS = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000"};

    public static String toString(double d) {
        return DoubleFormat.toString(d, 5, true);
    }

    public static String toString(double d, int n) {
        return DoubleFormat.toString(d, n, true);
    }

    public static String toString(double d, int n, boolean bl) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinity";
        }
        if (d == 0.0) {
            return bl || n == 1 ? "0" : "0." + DoubleFormat.zeros(n - 1);
        }
        double d2 = 1.0;
        for (int i = 1; i < n; ++i) {
            d2 *= 10.0;
        }
        double d3 = d2 * 10.0;
        int n2 = 0;
        while (Math.abs(d) + 0.5 < d2) {
            d *= 10.0;
            --n2;
        }
        while (Math.abs(d) + 0.5 >= d3) {
            d /= 10.0;
            ++n2;
        }
        return DoubleFormat.toString((long)(d + (d < 0.0 ? -0.5 : 0.5)), n2, n, bl);
    }

    public static String toShortString(long l, int n) {
        return DoubleFormat.toString(l, n, 16, true);
    }

    private static String toString(long l, int n, int n2, boolean bl) {
        int n3 = 1;
        if (l == 0L) {
            return bl || n2 == 1 ? "0" : "0." + DoubleFormat.zeros(n2 - 1);
        }
        if (l != 0L) {
            while (l % 10L == 0L) {
                l /= 10L;
                ++n;
            }
            n3 = 0;
            for (long i = l; i != 0L; i /= 10L) {
                ++n3;
            }
        }
        assert (n2 >= n3);
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            stringBuilder.append('-');
        }
        int n4 = Math.max(0, n2 - n3);
        String string = Long.toString(Math.abs(l));
        if (n == 0) {
            stringBuilder.append(string);
            if (!bl && n4 != 0) {
                stringBuilder.append(".");
                stringBuilder.append(DoubleFormat.zeros(n4));
            }
        } else if (n > 0) {
            boolean bl2;
            boolean bl3 = bl ? n > 4 : (bl2 = n - n4 > 4);
            if (bl2) {
                if (n3 == 1) {
                    stringBuilder.append(string);
                    if (n2 > 1) {
                        stringBuilder.append(".");
                        if (bl) {
                            stringBuilder.append("0");
                        } else {
                            stringBuilder.append(DoubleFormat.zeros(n4));
                        }
                    }
                } else {
                    stringBuilder.append(string.substring(0, 1));
                    stringBuilder.append(".");
                    stringBuilder.append(string.substring(1));
                    if (!bl && n4 != 0) {
                        stringBuilder.append(DoubleFormat.zeros(n4));
                    }
                }
                stringBuilder.append("e");
                stringBuilder.append(Integer.toString(n + n3 - 1));
            } else {
                stringBuilder.append(string);
                stringBuilder.append(DoubleFormat.zeros(n));
                if (!bl && n4 > n) {
                    stringBuilder.append(".");
                    stringBuilder.append(DoubleFormat.zeros(n4 - n));
                }
            }
        } else if (-n < n3) {
            stringBuilder.append(string.substring(0, n3 + n));
            stringBuilder.append(".");
            stringBuilder.append(string.substring(n3 + n));
            if (!bl && n4 != 0) {
                stringBuilder.append(DoubleFormat.zeros(n4));
            }
        } else if (-n == n3) {
            stringBuilder.append("0.");
            stringBuilder.append(string);
            if (!bl && n4 != 0) {
                stringBuilder.append(DoubleFormat.zeros(n4));
            }
        } else if (n + n3 < -2) {
            if (n3 == 1) {
                stringBuilder.append(string);
                if (n2 > 1) {
                    stringBuilder.append(".");
                    if (bl) {
                        stringBuilder.append("0");
                    } else {
                        stringBuilder.append(DoubleFormat.zeros(n4));
                    }
                }
            } else {
                stringBuilder.append(string.charAt(0));
                stringBuilder.append(".");
                stringBuilder.append(string.substring(1));
                if (!bl && n4 != 0) {
                    stringBuilder.append(DoubleFormat.zeros(n4));
                }
            }
            stringBuilder.append("e-");
            stringBuilder.append(Integer.toString(1 - n - n3));
        } else {
            stringBuilder.append("0.");
            stringBuilder.append(DoubleFormat.zeros(-n - n3));
            stringBuilder.append(string);
            if (!bl && n4 != 0) {
                stringBuilder.append(DoubleFormat.zeros(n4));
            }
        }
        return stringBuilder.toString();
    }

    private static String zeros(int n) {
        if (n < ZEROS.length) {
            return ZEROS[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= ZEROS.length) {
            stringBuilder.append(ZEROS[ZEROS.length - 1]);
            n -= ZEROS.length - 1;
        }
        stringBuilder.append(ZEROS[n]);
        return stringBuilder.toString();
    }
}

