/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.AtomHighlightAction;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class ChangeChargeAction
extends AtomHighlightAction {
    boolean plus;

    public ChangeChargeAction(Model model, boolean bl) {
        super(model);
        this.plus = bl;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        this.model.pushUndo();
        int n = this.model.getSelectedAtom();
        if (n != -1) {
            StereoMolecule stereoMolecule = this.model.getMolecule();
            int n2 = stereoMolecule.getAtomCharge(n);
            n2 = this.plus ? ++n2 : --n2;
            stereoMolecule.setAtomCharge(n, n2);
            return true;
        }
        return false;
    }

    @Override
    boolean trackHighLight(GenericPoint genericPoint) {
        int n = this.model.getSelectedAtom();
        boolean bl = super.trackHighLight(genericPoint);
        int n2 = this.model.getSelectedAtom();
        return bl || n != n2;
    }
}

