/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.NamedSubstituents;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.DialogResult;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.DrawAction;
import com.actelion.research.share.gui.editor.dialogs.IAtomQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IKeyEvent;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public abstract class AtomHighlightAction
extends DrawAction {
    protected GenericPoint lastHightlightPoint = null;

    AtomHighlightAction(Model model) {
        super(model);
    }

    boolean trackHighLight(GenericPoint genericPoint) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        int n = this.model.getSelectedAtom();
        int n2 = this.findAtom(stereoMolecule, genericPoint);
        boolean bl = n2 != -1;
        this.lastHightlightPoint = genericPoint;
        String string = this.model.getKeyStrokeBuffer().toString();
        if (n != -1 && n2 != n && string.length() > 0) {
            StereoMolecule stereoMolecule2 = this.model.getMolecule();
            this.expandAtomKeyStrokes(stereoMolecule2, n, string);
            this.model.getKeyStrokeBuffer().setLength(0);
        }
        if (stereoMolecule != null) {
            this.setHighlightAtom(stereoMolecule, n2);
        } else if (this.model.getSelectedAtom() != -1) {
            this.model.getKeyStrokeBuffer().setLength(0);
            bl = true;
        }
        n2 = this.model.getSelectedAtom();
        return bl |= n2 != -1;
    }

    void setHighlightAtom(StereoMolecule stereoMolecule, int n) {
        this.model.setSelectedAtom(n);
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        return false;
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        if (!bl) {
            GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
            boolean bl2 = this.trackHighLight(genericPoint);
            return bl2;
        }
        return false;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        boolean bl = false;
        int n = this.model.getSelectedAtom();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null && n != -1) {
            this.drawAtomHighlight(iDrawContext, stereoMolecule, n);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean onKeyPressed(IKeyEvent iKeyEvent) {
        GeomFactory geomFactory = this.model.getGeomFactory();
        if (iKeyEvent.getCode().equals(geomFactory.getDeleteKey())) {
            int n = this.model.getSelectedAtom();
            StereoMolecule stereoMolecule = this.model.getMolecule();
            if (n != -1) {
                stereoMolecule.deleteAtom(n);
                this.setHighlightAtom(stereoMolecule, -1);
                return true;
            }
            boolean bl = false;
            StereoMolecule stereoMolecule2 = this.model.getMolecule();
            if (stereoMolecule2.deleteSelectedAtoms()) {
                bl = true;
            }
            return bl;
        }
        return this.handleCharacter(iKeyEvent);
    }

    private boolean handleCharacter(IKeyEvent iKeyEvent) {
        int n = this.model.getSelectedAtom();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        StringBuilder stringBuilder = this.model.getKeyStrokeBuffer();
        if (stereoMolecule == null) {
            return false;
        }
        String string = iKeyEvent.getText();
        if (n != -1) {
            boolean bl;
            char c = string != null && string.length() > 0 ? string.charAt(0) : (char)'\u0000';
            boolean bl2 = bl = stringBuilder.length() == 0;
            if (bl) {
                switch (c) {
                    case '+': 
                    case '-': {
                        return stereoMolecule.changeAtomCharge(n, c == '+');
                    }
                    case '.': {
                        int n2 = stereoMolecule.getAtomRadical(n) == 32 ? 0 : 32;
                        stereoMolecule.setAtomRadical(n, n2);
                        return true;
                    }
                    case ':': {
                        int n3 = stereoMolecule.getAtomRadical(n) == 48 ? 16 : (stereoMolecule.getAtomRadical(n) == 16 ? 0 : 48);
                        stereoMolecule.setAtomRadical(n, n3);
                        return true;
                    }
                    case 'q': {
                        return stereoMolecule.isFragment() ? this.showAtomQFDialog(n) : false;
                    }
                    case '?': {
                        return stereoMolecule.changeAtom(n, 0, 0, -1, 0);
                    }
                }
            }
            return this.handleCharacter(stereoMolecule, n, iKeyEvent);
        }
        return this.handleCharsNonSelected(string);
    }

    private boolean handleCharsNonSelected(String string) {
        if ("h".equals(string)) {
            this.model.flip(true);
            return true;
        }
        if ("v".equals(string)) {
            this.model.flip(false);
            return true;
        }
        return false;
    }

    private void expandAtomKeyStrokes(StereoMolecule stereoMolecule, int n, String string) {
        int n2 = Molecule.getAtomicNoFromLabel(string);
        if (n2 != 0 && stereoMolecule.changeAtom(n, n2, 0, -1, 0)) {
            this.model.changed();
            return;
        }
        StereoMolecule stereoMolecule2 = NamedSubstituents.getSubstituent(string);
        if (stereoMolecule2 != null) {
            StereoMolecule stereoMolecule3 = new StereoMolecule();
            stereoMolecule3.addFragment(stereoMolecule, n, null);
            double d = stereoMolecule3.getAverageBondLength();
            int n3 = stereoMolecule3.getAllAtoms();
            for (int i = 0; i < stereoMolecule3.getAllAtoms(); ++i) {
                stereoMolecule3.setAtomMarker(i, true);
            }
            stereoMolecule3.addSubstituent(stereoMolecule2, 0);
            new CoordinateInventor(4).invent(stereoMolecule3);
            double d2 = stereoMolecule.getAtomX(n) - d * stereoMolecule3.getAtomX(0);
            double d3 = stereoMolecule.getAtomY(n) - d * stereoMolecule3.getAtomY(0);
            int n4 = stereoMolecule.getAllAtoms();
            stereoMolecule.addSubstituent(stereoMolecule2, n);
            int n5 = stereoMolecule.getAllAtoms() - n4;
            for (int i = 0; i < n5; ++i) {
                stereoMolecule.setAtomX(n4 + i, d * stereoMolecule3.getAtomX(n3 + i) + d2);
                stereoMolecule.setAtomY(n4 + i, d * stereoMolecule3.getAtomY(n3 + i) + d3);
            }
            stereoMolecule.setStereoBondsFromParity();
            this.model.changed();
        }
    }

    private boolean handleCharacter(StereoMolecule stereoMolecule, int n, IKeyEvent iKeyEvent) {
        char c;
        GeomFactory geomFactory = this.model.getGeomFactory();
        StringBuilder stringBuilder = this.model.getKeyStrokeBuffer();
        boolean bl = stringBuilder.length() == 0;
        String string = iKeyEvent.getText();
        char c2 = c = string != null && string.length() > 0 ? string.charAt(0) : (char)'\u0000';
        if (iKeyEvent.getCode().equals(geomFactory.getDeleteKey())) {
            if (n != -1) {
                stereoMolecule.deleteAtom(n);
                this.setHighlightAtom(stereoMolecule, -1);
                return true;
            }
            if (stereoMolecule.deleteSelectedAtoms()) {
                return true;
            }
        } else {
            if (!bl && iKeyEvent.getCode().equals(geomFactory.getEscapeKey())) {
                stringBuilder.setLength(0);
                return true;
            }
            if (!bl && iKeyEvent.getCode().equals(geomFactory.getBackSpaceKey())) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                return true;
            }
            if (iKeyEvent.getCode().equals(geomFactory.getEnterKey())) {
                this.expandAtomKeyStrokes(stereoMolecule, n, stringBuilder.toString());
                stringBuilder.setLength(0);
                return true;
            }
            if (bl && c > '0' && c <= '9') {
                this.addChain(stereoMolecule, n, c - 47);
                return true;
            }
            if (c > '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') {
                stringBuilder.append(c);
                return true;
            }
        }
        return false;
    }

    private void addChain(StereoMolecule stereoMolecule, int n, int n2) {
        if (stereoMolecule.getFreeValence(n) > 0) {
            GenericPoint genericPoint;
            int n3;
            int n4 = n;
            int n5 = stereoMolecule.getAllAtoms() - stereoMolecule.getAtoms();
            for (int i = 1; i < n2 && (n3 = stereoMolecule.addAtom((genericPoint = this.suggestNewX2AndY2(n4)).getX(), genericPoint.getY())) != -1; ++i) {
                stereoMolecule.addBond(n4, n3);
                n4 = n3 - n5;
                stereoMolecule.ensureHelperArrays(1);
            }
        }
    }

    private boolean showAtomQFDialog(int n) {
        GeomFactory geomFactory = this.model.getGeomFactory();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            boolean bl = (this.model.getMode() & 4) != 0;
            IAtomQueryFeaturesDialog iAtomQueryFeaturesDialog = geomFactory.createAtomQueryFeatureDialog(stereoMolecule, n, bl);
            return iAtomQueryFeaturesDialog.doModalAt(this.lastHightlightPoint.getX(), this.lastHightlightPoint.getY()) == DialogResult.IDOK;
        }
        return false;
    }

    public int findAtom(StereoMolecule stereoMolecule, GenericPoint genericPoint) {
        int n = -1;
        double d = genericPoint.getX();
        double d2 = genericPoint.getY();
        double d3 = stereoMolecule.getAverageBondLength();
        double d4 = 3.4028234663852886E38;
        double d5 = d3 * d3 / (d3 / 3.0);
        int n2 = stereoMolecule.getAllAtoms();
        for (int i = 0; i < n2; ++i) {
            double d6;
            double d7 = stereoMolecule.getAtomX(i);
            double d8 = (d - d7) * (d - d7) + (d2 - (d6 = stereoMolecule.getAtomY(i))) * (d2 - d6);
            if (!(d8 < d5) || !(d8 < d4)) continue;
            d4 = d8;
            n = i;
        }
        return n;
    }
}

