/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.DrawAction;
import com.actelion.research.share.gui.editor.chem.IArrow;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class ArrowAction
extends DrawAction {
    GenericPoint origin;
    GenericPoint last;
    IArrow arrow = null;

    public ArrowAction(Model model) {
        super(model);
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        this.origin = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        return false;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        if (this.arrow != null) {
            this.model.addDrawingObject(this.arrow);
        }
        return true;
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        if (bl) {
            GeomFactory geomFactory = this.model.getGeomFactory();
            this.last = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
            GenericRectangle genericRectangle = new GenericRectangle((int)Math.min(this.last.getX(), this.origin.getX()), (int)this.last.getY(), (int)Math.abs(this.last.getX() - this.origin.getX()), 0.0);
            this.arrow = geomFactory.createArrow(genericRectangle);
            return true;
        }
        return false;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        return false;
    }
}

