/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.table;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ChemistryRenderPanel
extends JPanel {
    static final long serialVersionUID = 537330450L;
    private Object mChemistry;
    private int mDisplayMode = 0;
    private int mOverruleForegroundARGB = 0;
    private double mTextSizeFactor = 1.0;
    private boolean mAlternateBackground;

    public void setChemistry(Object object) {
        this.mChemistry = object;
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("Table.foreground"));
            Color color = UIManager.getColor("Table.background");
            this.setBackground(!this.mAlternateBackground ? color : ColorHelper.darker(color, 0.94f));
        }
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
    }

    @Deprecated
    public void setOverruleForeground(Color color) {
        this.mOverruleForegroundARGB = color == null ? 0 : color.getRGB();
    }

    public void setOverruleForeground(int n) {
        this.mOverruleForegroundARGB = n;
    }

    public void setAlternateBackground(boolean bl) {
        this.mAlternateBackground = bl;
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
    }

    public void setTextSizeFactor(double d) {
        this.mTextSizeFactor = d;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Rectangle rectangle = new Rectangle(new Point(0, 0), this.getSize());
        if (LookAndFeelHelper.isNewSubstance()) {
            graphics.setColor(this.getBackground());
            ((Graphics2D)graphics).fill(rectangle);
        }
        rectangle.grow(-2, -2);
        Insets insets = this.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this.mChemistry != null && rectangle.width > 0 && rectangle.height > 0) {
            Object object;
            if (this.mChemistry instanceof StereoMolecule) {
                object = new GenericDepictor((StereoMolecule)this.mChemistry, this.mDisplayMode | 0x20);
                ((AbstractDepictor)object).setFactorTextSize(this.mTextSizeFactor);
                ((AbstractDepictor)object).setForegroundColor(this.getForeground().getRGB(), this.getBackground().getRGB());
                if (this.mOverruleForegroundARGB != 0) {
                    ((AbstractDepictor)object).setOverruleColor(this.mOverruleForegroundARGB, this.getBackground().getRGB());
                }
                int n = HiDPIHelper.scale(24.0f);
                SwingDrawContext swingDrawContext = new SwingDrawContext((Graphics2D)graphics);
                ((AbstractDepictor)object).validateView(swingDrawContext, new GenericRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), 0x10000 | n);
                ((AbstractDepictor)object).paint(swingDrawContext);
            }
            if (this.mChemistry instanceof Reaction) {
                object = (Reaction)this.mChemistry;
                ExtendedDepictor extendedDepictor = new ExtendedDepictor((Reaction)object, ((Reaction)object).getDrawingObjects(), ((Reaction)object).isReactionLayoutRequired());
                extendedDepictor.setFactorTextSize(this.mTextSizeFactor);
                extendedDepictor.setDisplayMode(this.mDisplayMode | 0x20);
                extendedDepictor.setForegroundColor(this.getForeground().getRGB(), this.getBackground().getRGB());
                if (this.mOverruleForegroundARGB != 0) {
                    extendedDepictor.setOverruleColor(this.mOverruleForegroundARGB, this.getBackground().getRGB());
                }
                int n = HiDPIHelper.scale(24.0f);
                SwingDrawContext swingDrawContext = new SwingDrawContext((Graphics2D)graphics);
                extendedDepictor.validateView(swingDrawContext, new GenericRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), 0x10000 | n);
                extendedDepictor.paint(swingDrawContext);
            }
        }
    }
}

