/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.swing.SwingImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;

public class SwingDrawContext
implements GenericDrawContext {
    private static boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    private Graphics2D mG;

    public SwingDrawContext(Graphics2D graphics2D) {
        this.mG = graphics2D;
    }

    @Override
    public int getFontSize() {
        return this.mG.getFont().getSize();
    }

    @Override
    public void setFont(int n, boolean bl, boolean bl2) {
        int n2 = (bl ? 1 : 0) + (bl2 ? 2 : 0);
        this.mG.setFont(this.mG.getFont().deriveFont(n2, n));
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4) {
        if (isMac) {
            this.mG.draw(new Line2D.Double(d - 0.5, d2 - 0.5, d3 - 0.5, d4 - 0.5));
        } else {
            this.mG.draw(new Line2D.Double(d, d2, d3, d4));
        }
    }

    @Override
    public void drawDottedLine(double d, double d2, double d3, double d4) {
        Stroke stroke = this.mG.getStroke();
        float f = ((BasicStroke)stroke).getLineWidth();
        this.mG.setStroke(new BasicStroke(f, 1, 1, f, new float[]{3.0f * f}, 0.0f));
        this.drawLine(d, d2, d3, d4);
        this.mG.setStroke(stroke);
    }

    @Override
    public void drawRectangle(double d, double d2, double d3, double d4) {
        this.mG.draw(new Rectangle2D.Double(d, d2, d3, d4));
    }

    @Override
    public void fillRectangle(double d, double d2, double d3, double d4) {
        this.mG.fill(new Rectangle2D.Double(d, d2, d3, d4));
    }

    @Override
    public void drawCircle(double d, double d2, double d3) {
        if (isMac) {
            this.mG.draw(new Ellipse2D.Double(d - 0.5, d2 - 0.5, d3, d3));
        } else {
            this.mG.draw(new Ellipse2D.Double(d, d2, d3, d3));
        }
    }

    @Override
    public void fillCircle(double d, double d2, double d3) {
        if (isMac) {
            this.mG.fill(new Ellipse2D.Double(d - 0.5, d2 - 0.5, d3, d3));
        } else {
            this.mG.fill(new Ellipse2D.Double(d, d2, d3, d3));
        }
    }

    @Override
    public void drawPolygon(GenericPolygon genericPolygon) {
        GeneralPath generalPath = new GeneralPath(1, genericPolygon.getSize());
        if (isMac) {
            generalPath.moveTo((float)genericPolygon.getX(0) - 0.5f, (float)genericPolygon.getY(0) - 0.5f);
            for (int i = 1; i < genericPolygon.getSize(); ++i) {
                generalPath.lineTo((float)genericPolygon.getX(i) - 0.5f, (float)genericPolygon.getY(i) - 0.5f);
            }
            generalPath.closePath();
        } else {
            generalPath.moveTo((float)genericPolygon.getX(0), (float)genericPolygon.getY(0));
            for (int i = 1; i < genericPolygon.getSize(); ++i) {
                generalPath.lineTo((float)genericPolygon.getX(i), (float)genericPolygon.getY(i));
            }
            generalPath.closePath();
        }
        this.mG.draw(generalPath);
    }

    @Override
    public void fillPolygon(GenericPolygon genericPolygon) {
        int n;
        GeneralPath generalPath = new GeneralPath(1, genericPolygon.getSize());
        generalPath.moveTo((float)genericPolygon.getX(0), (float)genericPolygon.getY(0));
        for (n = 1; n < genericPolygon.getSize(); ++n) {
            generalPath.lineTo((float)genericPolygon.getX(n), (float)genericPolygon.getY(n));
        }
        generalPath.closePath();
        this.mG.fill(generalPath);
        if (isMac) {
            generalPath = new GeneralPath(1, genericPolygon.getSize());
            generalPath.moveTo((float)genericPolygon.getX(0) - 0.5f, (float)genericPolygon.getY(0) - 0.5f);
            for (n = 1; n < genericPolygon.getSize(); ++n) {
                generalPath.lineTo((float)genericPolygon.getX(n) - 0.5f, (float)genericPolygon.getY(n) - 0.5f);
            }
            generalPath.closePath();
        }
        this.mG.draw(generalPath);
    }

    @Override
    public float getLineWidth() {
        return ((BasicStroke)this.mG.getStroke()).getLineWidth();
    }

    @Override
    public void setLineWidth(float f) {
        this.mG.setStroke(new BasicStroke(f, 1, 1));
    }

    @Override
    public int getRGB() {
        return this.mG.getColor().getRGB();
    }

    @Override
    public void setRGB(int n) {
        Color color = new Color(n);
        this.mG.setColor(color);
        this.mG.setPaint(color);
    }

    @Override
    public void drawString(double d, double d2, String string) {
        this.mG.drawString(string, (float)Math.round(d), (float)Math.round(d2));
    }

    @Override
    public void drawCenteredString(double d, double d2, String string) {
        GlyphVector glyphVector = this.mG.getFont().createGlyphVector(this.mG.getFontRenderContext(), string);
        double d3 = glyphVector.getLogicalBounds().getWidth();
        this.mG.drawGlyphVector(glyphVector, (float)(d - d3 / 2.0), (float)(d2 + (double)this.mG.getFont().getSize() / 3.0));
    }

    @Override
    public GenericRectangle getBounds(String string) {
        Rectangle2D rectangle2D = this.mG.getFontMetrics().getStringBounds(string, this.mG);
        return new GenericRectangle(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2) {
        this.mG.drawImage((Image)genericImage.get(), Math.round((float)d), Math.round((float)d2), null);
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2, double d3, double d4, double d5, double d6) {
        this.mG.drawImage((Image)genericImage.get(), Math.round((float)d3), Math.round((float)d4), Math.round((float)(d3 + d5)), Math.round((float)(d4 + d6)), Math.round((float)d), Math.round((float)d2), Math.round((float)(d + d5)), Math.round((float)(d2 + d6)), null);
    }

    @Override
    public void drawImage(GenericImage genericImage, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.mG.drawImage((Image)genericImage.get(), Math.round((float)d5), Math.round((float)d6), Math.round((float)(d5 + d7)), Math.round((float)(d6 + d8)), Math.round((float)d), Math.round((float)d2), Math.round((float)(d + d3)), Math.round((float)(d2 + d4)), null);
    }

    @Override
    public boolean isDarkBackground() {
        return LookAndFeelHelper.isDarkLookAndFeel();
    }

    @Override
    public int getForegroundRGB() {
        Color color = UIManager.getColor("TextArea.foreground");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public int getBackgroundRGB() {
        Color color = UIManager.getColor("TextArea.background");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public int getSelectionBackgroundRGB() {
        Color color = UIManager.getColor("TextArea.selectionBackground");
        return color == null ? 0 : color.getRGB();
    }

    @Override
    public GenericImage createARGBImage(int n, int n2) {
        return new SwingImage(n, n2);
    }
}

