/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.HiDPIIcon;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class HiDPIToggleButton
extends JToggleButton {
    private String mImageName1;
    private String mImageName2;

    public HiDPIToggleButton(String string, String string2, String string3, String string4) {
        this.mImageName1 = string;
        this.mImageName2 = string2;
        this.updateIconSet();
        if (string4 != null) {
            this.setActionCommand(string4);
        }
        this.setFocusable(false);
        if (string3 != null) {
            this.setToolTipText(string3);
        }
    }

    private void updateIconSet() {
        if (this.mImageName1 != null) {
            this.setIcon(HiDPIIcon.createIcon(this.mImageName1, 0, false));
            this.setSelectedIcon(HiDPIIcon.createIcon(this.mImageName2 != null ? this.mImageName2 : this.mImageName1, 0, false));
            this.setDisabledIcon(HiDPIIcon.createIcon(this.mImageName1, 0, true));
            this.setDisabledSelectedIcon(HiDPIIcon.createIcon(this.mImageName2 != null ? this.mImageName2 : this.mImageName1, 0, true));
            Icon icon = this.getIcon();
            int n = Math.round((float)icon.getIconWidth() / HiDPIHelper.getRetinaScaleFactor()) + 2;
            int n2 = Math.round((float)icon.getIconHeight() / HiDPIHelper.getRetinaScaleFactor()) + 2;
            this.setPreferredSize(new Dimension(n, n2));
        }
    }

    @Override
    public void updateUI() {
        this.updateIconSet();
        super.updateUI();
    }
}

