/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.editor.FXEditorArea;
import com.actelion.research.gui.editor.FXEditorPane;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.util.ArrayList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class FXEditorDialog
extends Stage {
    private static final String DEFAULT_MOLECULE_TITLE = "Structure Editor";
    private static final String DEFAULT_REACTION_TITLE = "Reaction Editor";
    private StereoMolecule mMolecule;
    private FXEditorArea mArea;
    private boolean mIsCancelled;
    private ArrayList<StructureListener> mListener;

    public FXEditorDialog(Window window, StereoMolecule stereoMolecule) {
        this(window, stereoMolecule, Modality.APPLICATION_MODAL);
    }

    public FXEditorDialog(Window window, Reaction reaction) {
        this(window, reaction, Modality.APPLICATION_MODAL);
    }

    public FXEditorDialog(Window window, StereoMolecule stereoMolecule, Modality modality) {
        super(StageStyle.DECORATED);
        this.mMolecule = stereoMolecule == null ? new StereoMolecule() : new StereoMolecule(stereoMolecule);
        this.initialize(window, modality, DEFAULT_MOLECULE_TITLE, 0);
    }

    public FXEditorDialog(Window window, StereoMolecule[] stereoMoleculeArray, Modality modality) {
        super(StageStyle.DECORATED);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, modality, DEFAULT_MOLECULE_TITLE, 1);
        if (stereoMoleculeArray != null) {
            this.mArea.getGenericDrawArea().setFragments(stereoMoleculeArray);
        }
    }

    public FXEditorDialog(Window window, Reaction reaction, Modality modality) {
        super(StageStyle.DECORATED);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, modality, DEFAULT_REACTION_TITLE, 4);
        if (reaction != null) {
            this.mArea.getGenericDrawArea().setReaction(reaction);
        }
    }

    public void initialize(Window window, Modality modality, String string, int n) {
        this.initOwner(window);
        this.initModality(modality);
        this.setTitle(string);
        FXEditorPane fXEditorPane = new FXEditorPane(this.mMolecule, n);
        this.mArea = fXEditorPane.getFXDrawArea();
        Button button = new Button("Help");
        Button button2 = new Button("Cancel");
        Button button3 = new Button("OK");
        button.addEventHandler(ActionEvent.ACTION, actionEvent -> this.mArea.getGenericDrawArea().showHelpDialog());
        button2.addEventHandler(ActionEvent.ACTION, actionEvent -> this.close());
        button3.addEventHandler(ActionEvent.ACTION, actionEvent -> {
            for (StructureListener structureListener : this.mListener) {
                structureListener.structureChanged(this.mMolecule);
            }
            this.mIsCancelled = false;
            this.close();
        });
        int n2 = HiDPIHelper.scale(8.0f);
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets((double)n2, (double)n2, (double)n2, (double)n2));
        gridPane.setHgap((double)n2);
        gridPane.add((Node)button2, 0, 0);
        gridPane.add((Node)button3, 1, 0);
        GridPane gridPane2 = new GridPane();
        gridPane2.setPadding(new Insets((double)n2, (double)n2, (double)n2, (double)n2));
        gridPane2.add((Node)button, 0, 0);
        BorderPane borderPane = new BorderPane();
        borderPane.setLeft((Node)gridPane2);
        borderPane.setRight((Node)gridPane);
        BorderPane borderPane2 = new BorderPane();
        borderPane2.setCenter((Node)fXEditorPane);
        borderPane2.setBottom((Node)borderPane);
        Scene scene = new Scene((Parent)borderPane2, (double)HiDPIHelper.scale(n == 4 ? 800.0f : 480.0f), (double)HiDPIHelper.scale(400.0f), true, SceneAntialiasing.BALANCED);
        this.setScene(scene);
        this.mListener = new ArrayList();
        this.mIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public StereoMolecule getStructure() {
        return this.mMolecule;
    }

    public Reaction getReaction() {
        return this.mArea.getGenericDrawArea().getReaction();
    }

    public Reaction getReactionAndDrawings() {
        return this.mArea.getGenericDrawArea().getReactionAndDrawings();
    }

    public GenericEditorArea getDrawArea() {
        return this.mArea.getGenericDrawArea();
    }

    public void addStructureListener(StructureListener structureListener) {
        this.mListener.add(structureListener);
    }
}

