/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.clipboard.ClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.fx.FXDrawContext;
import com.actelion.research.gui.fx.FXKeyHandler;
import com.actelion.research.gui.fx.FXMouseHandler;
import com.actelion.research.gui.fx.FXUIHelper;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FXEditorArea
extends Canvas
implements GenericCanvas {
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private GenericEditorArea mDrawArea;
    private FXKeyHandler mKeyHandler;
    private volatile boolean mDrawPending;

    public FXEditorArea(StereoMolecule stereoMolecule, int n) {
        this.mDrawArea = new GenericEditorArea(stereoMolecule, n, new FXUIHelper((Node)this), this);
        this.widthProperty().addListener(observable -> this.repaint());
        this.heightProperty().addListener(observable -> this.repaint());
        this.initializeDragAndDrop(3);
        FXMouseHandler fXMouseHandler = new FXMouseHandler(this.mDrawArea);
        fXMouseHandler.addListener(this.mDrawArea);
        this.setOnMousePressed(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 1));
        this.setOnMouseReleased(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 2));
        this.setOnMouseEntered(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 4));
        this.setOnMouseMoved(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 6));
        this.setOnMouseDragged(mouseEvent -> fXMouseHandler.fireEvent((MouseEvent)mouseEvent, 7));
        this.mKeyHandler = new FXKeyHandler(this.mDrawArea);
        this.mKeyHandler.addListener(this.mDrawArea);
        this.setOnKeyPressed(keyEvent -> this.mKeyHandler.fireEvent((KeyEvent)keyEvent, 1));
        this.setOnKeyReleased(keyEvent -> this.mKeyHandler.fireEvent((KeyEvent)keyEvent, 2));
        this.getGenericDrawArea().setClipboardHandler(new ClipboardHandler());
    }

    private void draw() {
        this.mDrawPending = false;
        double d = this.getWidth();
        double d2 = this.getHeight();
        GraphicsContext graphicsContext = this.getGraphicsContext2D();
        graphicsContext.clearRect(0.0, 0.0, d, d2);
        graphicsContext.setStroke((Paint)Color.RED);
        graphicsContext.strokeLine(0.0, 0.0, d, d2);
        graphicsContext.strokeLine(0.0, d2, d, 0.0);
        this.mDrawArea.paintContent(new FXDrawContext(graphicsContext));
    }

    public boolean isResizable() {
        return true;
    }

    public double prefWidth(double d) {
        return this.getWidth();
    }

    public double prefHeight(double d) {
        return this.getHeight();
    }

    public FXKeyHandler getKeyHandler() {
        return this.mKeyHandler;
    }

    public GenericEditorArea getGenericDrawArea() {
        return this.mDrawArea;
    }

    @Override
    public double getCanvasWidth() {
        return this.getWidth();
    }

    @Override
    public double getCanvasHeight() {
        return this.getHeight();
    }

    @Override
    public int getBackgroundRGB() {
        Paint paint;
        BackgroundFill backgroundFill;
        Background background;
        Parent parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Pane); parent = parent.getParent()) {
        }
        if (parent != null && parent instanceof Pane && (background = ((Pane)parent).getBackground()) != null && (backgroundFill = (BackgroundFill)background.getFills().get(0)) != null && (paint = backgroundFill.getFill()) instanceof Color) {
            Color color = (Color)paint;
            return (Math.round(255.0f * (float)color.getRed()) << 16) + (Math.round(255.0f * (float)color.getGreen()) << 8) + Math.round(255.0f * (float)color.getBlue());
        }
        return 0xE0E0E0;
    }

    @Override
    public GenericDrawContext getDrawContext() {
        return new FXDrawContext(this.getGraphicsContext2D());
    }

    @Override
    public void repaint() {
        if (!this.mDrawPending) {
            this.mDrawPending = true;
            Platform.runLater(() -> this.draw());
        }
    }

    private void initializeDragAndDrop(int n) {
        if (n != 0) {
            MoleculeDropAdapter moleculeDropAdapter = new MoleculeDropAdapter(){

                @Override
                public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                    FXEditorArea.this.mDrawArea.addPastedOrDropped(stereoMolecule, new GenericPoint(point.x, point.y));
                }
            };
        }
    }

    static class OurFlavorMap
    implements FlavorMap {
        OurFlavorMap() {
        }

        @Override
        public Map<DataFlavor, String> getNativesForFlavors(DataFlavor[] dataFlavorArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getNativesForFlavors(dataFlavorArray);
        }

        @Override
        public Map<String, DataFlavor> getFlavorsForNatives(String[] stringArray) {
            FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
            return flavorMap.getFlavorsForNatives(stringArray);
        }
    }
}

