/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class MySplitPane
extends JSplitPane {
    private static final long serialVersionUID = 537331494L;
    private double mProportionalLocation;
    private boolean mMouseDown;

    public MySplitPane(int n, Component component, Component component2, double d) {
        super(n, true, component, component2);
        d = Math.min(1.0, Math.max(0.0, d));
        this.setDividerLocation(d);
        this.setResizeWeight(d);
        this.setBorder(null);
        this.mProportionalLocation = d;
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)splitPaneUI).getDivider().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    MySplitPane.this.mMouseDown = true;
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    MySplitPane.this.mMouseDown = false;
                }
            });
        }
    }

    public boolean isDragged() {
        return this.mMouseDown;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.mProportionalLocation != -1.0) {
            int n = (this.getOrientation() == 0 ? this.getHeight() : this.getWidth()) - this.getDividerSize();
            int n2 = (int)(this.mProportionalLocation * (double)n);
            if (Math.abs(n2 - this.getDividerLocation()) > 1) {
                super.setDividerLocation(n2);
            } else {
                this.mProportionalLocation = -1.0;
            }
        }
        super.paintComponent(graphics);
    }
}

