/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dock;

import com.actelion.research.gui.dock.Dockable;
import com.actelion.research.gui.dock.PopupProvider;
import com.actelion.research.gui.swing.SwingCursorHelper;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;

public class HeaderMouseAdapter
extends MouseInputAdapter {
    private PopupProvider mPopupProvider = null;
    private JLabel mTitleLabel;
    private Dockable mDockable;
    private boolean mIsMouseDown;

    public HeaderMouseAdapter(JLabel jLabel, Dockable dockable) {
        this.mTitleLabel = jLabel;
        this.mDockable = dockable;
    }

    public PopupProvider getPopupProvider() {
        return this.mPopupProvider;
    }

    public void setPopupProvider(PopupProvider popupProvider) {
        this.mPopupProvider = popupProvider;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mTitleLabel.setCursor(SwingCursorHelper.getCursor(2));
        this.mIsMouseDown = false;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.mIsMouseDown) {
            this.mTitleLabel.setCursor(SwingCursorHelper.getCursor(11));
        }
        this.mIsMouseDown = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.handlePopupTrigger(mouseEvent)) {
            this.mTitleLabel.setCursor(SwingCursorHelper.getCursor(mouseEvent.getButton() == 1 ? 4 : 11));
            this.mIsMouseDown = true;
            this.mDockable.getDockingPanel().selectDockable(this.mDockable);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupTrigger(mouseEvent);
        this.mTitleLabel.setCursor(SwingCursorHelper.getCursor(2));
        this.mIsMouseDown = false;
    }

    private boolean handlePopupTrigger(MouseEvent mouseEvent) {
        if (this.mPopupProvider != null && mouseEvent.isPopupTrigger()) {
            this.mTitleLabel.setCursor(SwingCursorHelper.getCursor(11));
            JPopupMenu jPopupMenu = this.mPopupProvider.createPopupMenu(this.mTitleLabel.getText(), this.mDockable.isMaximized());
            jPopupMenu.show(this.mTitleLabel, mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }
}

