/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class ReactionDropAdapter
implements DropTargetListener {
    public static final boolean debug = false;
    private boolean active_ = true;
    private final int mAllowedDropAction = 3;

    public void onDropReaction(Reaction reaction, Point point) {
        this.DEBUG("ReactionDropAdapter.onDropReaction(). Override this! " + reaction);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("DragEnter");
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("DragOver");
    }

    public void setActive(boolean bl) {
        this.active_ = bl;
    }

    public boolean isActive() {
        return this.active_;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.DEBUG("dropActionChanged");
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.DEBUG("dragExit");
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.active_) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.DEBUG("ReactionDropAdapter   ClassLoader " + classLoader);
            this.DEBUG("ReactionDropAdapter   Ignoring setContextclassloader!!!");
            this.DEBUG("ReactionDropAdapter " + dropTargetDropEvent);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                this.DEBUG("Transferable is " + transferable);
                DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
                Reaction reaction = null;
                if (dataFlavor != null) {
                    dropTargetDropEvent.acceptDrop(3);
                    this.DEBUG("Chose is " + dataFlavor);
                    Object object = transferable.getTransferData(dataFlavor);
                    this.DEBUG("Object is " + object);
                    reaction = this.createFromDataFlavor(dataFlavor, object);
                    if (reaction != null) {
                        this.onDropReaction(reaction, dropTargetDropEvent.getLocation());
                        dropTargetDropEvent.dropComplete(true);
                    } else {
                        System.err.println("Drop failed: " + dropTargetDropEvent);
                        dropTargetDropEvent.dropComplete(false);
                    }
                    return;
                }
                System.err.println("Drop failed: " + dropTargetDropEvent);
                dropTargetDropEvent.rejectDrop();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public DataFlavor[] getFlavors() {
        return ChemistryFlavors.REACTION_FLAVORS;
    }

    protected Reaction createFromDataFlavor(DataFlavor dataFlavor, Object object) throws Exception {
        Reaction reaction = null;
        if (dataFlavor.equals(ChemistryFlavors.DF_SERIALIZED_REACTION) && object instanceof Reaction) {
            reaction = new Reaction((Reaction)object);
        } else if (dataFlavor.equals(ChemistryFlavors.DF_REACTION_SMILES) && object instanceof String) {
            reaction = new SmilesParser().parseReaction(((String)object).getBytes());
        } else if (dataFlavor.equals(DataFlavor.stringFlavor) && object instanceof String) {
            try {
                reaction = ReactionEncoder.decode((String)object, true);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to instantiate reaction from text flavor " + object);
                reaction = null;
            }
        } else {
            System.err.println("Unable to instantiate flavor " + dataFlavor);
        }
        return reaction;
    }

    protected boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        for (int i = 0; i < ChemistryFlavors.REACTION_FLAVORS.length; ++i) {
            if (!dropTargetDragEvent.isDataFlavorSupported(ChemistryFlavors.REACTION_FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        for (int i = 0; i < ChemistryFlavors.REACTION_FLAVORS.length; ++i) {
            if (!dropTargetDropEvent.isDataFlavorSupported(ChemistryFlavors.REACTION_FLAVORS[i])) continue;
            return ChemistryFlavors.REACTION_FLAVORS[i];
        }
        return null;
    }

    public boolean isDropOK(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        return (dropTargetDragEvent.getDropAction() & 3) != 0;
    }

    private void DEBUG(String string) {
    }
}

