/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;

public class JScrollablePopupMenu
extends JPopupMenu {
    protected int maximumVisibleRows = 24;
    private JScrollBar popupScrollBar;

    public JScrollablePopupMenu() {
        this(null);
    }

    public JScrollablePopupMenu(String string) {
        super(string);
        this.setLayout(new ScrollPopupMenuLayout());
        super.add(this.getScrollBar());
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                JScrollBar jScrollBar = JScrollablePopupMenu.this.getScrollBar();
                int n = mouseWheelEvent.getScrollType() == 0 ? mouseWheelEvent.getUnitsToScroll() * jScrollBar.getUnitIncrement() : (mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1) * jScrollBar.getBlockIncrement();
                jScrollBar.setValue(jScrollBar.getValue() + n);
                mouseWheelEvent.consume();
            }
        });
    }

    protected JScrollBar getScrollBar() {
        if (this.popupScrollBar == null) {
            this.popupScrollBar = new JScrollBar(1);
            this.popupScrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    JScrollablePopupMenu.this.doLayout();
                    JScrollablePopupMenu.this.repaint();
                }
            });
            this.popupScrollBar.setVisible(false);
        }
        return this.popupScrollBar;
    }

    public int getMaximumVisibleRows() {
        return this.maximumVisibleRows;
    }

    public void setMaximumVisibleRows(int n) {
        this.maximumVisibleRows = n;
    }

    @Override
    public void paintChildren(Graphics graphics) {
        Insets insets = this.getInsets();
        graphics.clipRect(insets.left, insets.top, this.getWidth(), this.getHeight() - insets.top - insets.bottom);
        super.paintChildren(graphics);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (this.maximumVisibleRows < this.getComponentCount() - 1) {
            this.getScrollBar().setVisible(true);
        }
    }

    @Override
    public void remove(int n) {
        super.remove(++n);
        if (this.maximumVisibleRows >= this.getComponentCount() - 1) {
            this.getScrollBar().setVisible(false);
        }
    }

    @Override
    public void show(Component component, int n, int n2) {
        JScrollBar jScrollBar = this.getScrollBar();
        if (jScrollBar.isVisible()) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            int n7 = 0;
            for (Component n10 : this.getComponents()) {
                if (n10 instanceof JScrollBar) continue;
                Dimension dimension = n10.getPreferredSize();
                n7 = Math.max(n7, dimension.width);
                if (n6 < 0) {
                    n6 = dimension.height;
                }
                if (n5++ < this.maximumVisibleRows) {
                    n3 += dimension.height;
                }
                n4 += dimension.height;
            }
            Insets insets = this.getInsets();
            int n8 = insets.left + insets.right;
            int n9 = insets.top + insets.bottom;
            jScrollBar.setUnitIncrement(n6);
            jScrollBar.setBlockIncrement(n3);
            jScrollBar.setValues(0, n9 + n3, 0, n9 + n4);
            int n10 = n9 + n3;
            this.setPopupSize(new Dimension(n7 += jScrollBar.getPreferredSize().width + n8, n10));
        }
        super.show(component, n, n2);
    }

    protected static class ScrollPopupMenuLayout
    implements LayoutManager {
        protected ScrollPopupMenuLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = Integer.MAX_VALUE;
            Dimension dimension = new Dimension();
            for (Component component : container.getComponents()) {
                Serializable serializable;
                if (!component.isVisible()) continue;
                if (component instanceof JScrollBar) {
                    serializable = (JScrollBar)component;
                    n = ((JScrollBar)serializable).getVisibleAmount();
                    continue;
                }
                serializable = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable).width);
                dimension.height += ((Dimension)serializable).height;
            }
            Insets insets = container.getInsets();
            dimension.height = Math.min(dimension.height + insets.top + insets.bottom, n);
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = Integer.MAX_VALUE;
            Dimension dimension = new Dimension();
            for (Component component : container.getComponents()) {
                Serializable serializable;
                if (!component.isVisible()) continue;
                if (component instanceof JScrollBar) {
                    serializable = (JScrollBar)component;
                    n = ((JScrollBar)serializable).getVisibleAmount();
                    continue;
                }
                serializable = component.getMinimumSize();
                dimension.width = Math.max(dimension.width, ((Dimension)serializable).width);
                dimension.height += ((Dimension)serializable).height;
            }
            Insets insets = container.getInsets();
            dimension.height = Math.min(dimension.height + insets.top + insets.bottom, n);
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            Serializable serializable;
            Insets insets = container.getInsets();
            int n = container.getWidth() - insets.left - insets.right;
            int n2 = container.getHeight() - insets.top - insets.bottom;
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = 0;
            for (Component component : container.getComponents()) {
                if (!(component instanceof JScrollBar) || !component.isVisible()) continue;
                serializable = (JScrollBar)component;
                Dimension dimension = ((JComponent)serializable).getPreferredSize();
                ((Component)serializable).setBounds(n3 + n - dimension.width, n4, dimension.width, n2);
                n -= dimension.width;
                n5 = ((JScrollBar)serializable).getValue();
            }
            n4 -= n5;
            for (Component component : container.getComponents()) {
                if (component instanceof JScrollBar || !component.isVisible()) continue;
                serializable = component.getPreferredSize();
                component.setBounds(n3, n4, n, ((Dimension)serializable).height);
                n4 += ((Dimension)serializable).height;
            }
        }
    }
}

