/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.JScrollablePopupMenu;
import java.awt.Component;
import java.awt.ComponentOrientation;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class JScrollableMenu
extends JMenu {
    private JPopupMenu popupMenu;

    public JScrollableMenu() {
        this("");
    }

    public JScrollableMenu(String string) {
        super(string);
    }

    public JScrollableMenu(Action action) {
        this();
        this.setAction(action);
    }

    protected void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            this.popupMenu = new JScrollablePopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
        }
    }

    @Override
    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    @Override
    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    @Override
    public void setMenuLocation(int n, int n2) {
        super.setMenuLocation(n, n2);
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    @Override
    public Component add(Component component) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    @Override
    public Component add(Component component, int n) {
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component, n);
        return component;
    }

    @Override
    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    @Override
    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    @Override
    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    @Override
    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    @Override
    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n);
    }

    @Override
    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
    }

    @Override
    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n);
        }
    }

    @Override
    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    @Override
    public void removeAll() {
        this.popupMenu = null;
    }

    @Override
    public int getMenuComponentCount() {
        return this.popupMenu == null ? 0 : this.popupMenu.getComponentCount();
    }

    @Override
    public Component getMenuComponent(int n) {
        return this.popupMenu == null ? null : this.popupMenu.getComponent(n);
    }

    @Override
    public Component[] getMenuComponents() {
        return this.popupMenu == null ? new Component[]{} : this.popupMenu.getComponents();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    @Override
    public MenuElement[] getSubElements() {
        MenuElement[] menuElementArray;
        if (this.popupMenu == null) {
            menuElementArray = new MenuElement[]{};
        } else {
            MenuElement[] menuElementArray2 = new MenuElement[1];
            menuElementArray = menuElementArray2;
            menuElementArray2[0] = this.popupMenu;
        }
        return menuElementArray;
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            int n = this.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                this.getMenuComponent(i).applyComponentOrientation(componentOrientation);
            }
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this.popupMenu != null) {
            this.popupMenu.setComponentOrientation(componentOrientation);
        }
    }
}

