/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.gui.HeaderPaintHelper;
import com.actelion.research.gui.MultiPanelDragListener;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JMultiPanelTitle
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 537921555L;
    public static final int HEIGHT = HiDPIHelper.scale(10.0f);
    private MultiPanelDragListener mDragListener;
    private String mTitle;
    private boolean mDragEnabled;

    public JMultiPanelTitle(MultiPanelDragListener multiPanelDragListener, String string) {
        this.mDragListener = multiPanelDragListener;
        this.mTitle = string;
        this.mDragEnabled = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setDragEnabled(boolean bl) {
        this.mDragEnabled = bl;
    }

    public void setTitle(String string) {
        this.mTitle = string;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(HeaderPaintHelper.getHeaderPaint(true, dimension.height));
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setPaint(paint);
        graphics.setColor(UIManager.getColor("Label.foreground"));
        graphics.setFont(UIManager.getFont("Label.font").deriveFont(0, HEIGHT - 1));
        int n = (int)graphics.getFontMetrics().getStringBounds(this.mTitle, graphics).getWidth();
        graphics.drawString(this.mTitle, (dimension.width - n) / 2, HEIGHT - 2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mDragEnabled) {
            this.mDragListener.dragStarted(mouseEvent.getY(), this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mDragEnabled) {
            this.setCursor(Cursor.getPredefinedCursor(9));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mDragEnabled) {
            this.mDragListener.dragContinued(mouseEvent.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

