/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.util.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JLoginDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 537920792L;
    public static final String cLoginCancel = "loginCancel";
    public static final String cLoginOK = "loginOK";
    public static final String PREFERENCES_KEY_USERID = "databaseUserID";
    private JTextField mTextFieldUserID;
    private JPasswordField mTextFieldPassword;

    public JLoginDialog(Window window, ActionListener actionListener) {
        super(window, "Database Login", Dialog.DEFAULT_MODALITY_TYPE);
        this.initialize(actionListener);
        this.setLocationRelativeTo(window);
    }

    private void initialize(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        jPanel.setLayout(new GridLayout(2, 2, 4, 4));
        jPanel.add(new JLabel("User-ID:", 11));
        this.mTextFieldUserID = new JTextField(12);
        jPanel.add(this.mTextFieldUserID);
        jPanel.add(new JLabel("Password:", 11));
        this.mTextFieldPassword = new JPasswordField(12);
        jPanel.add(this.mTextFieldPassword);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 8, 8, 8));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 6, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand(cLoginCancel);
        jButton.addActionListener(actionListener);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.setActionCommand(cLoginOK);
        jButton2.addActionListener(actionListener);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "East");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        String string = Prefs.getString(PREFERENCES_KEY_USERID, "");
        if (string != null) {
            this.mTextFieldUserID.setText(string);
            this.addWindowListener(this);
        }
        this.pack();
    }

    public String getUserID() {
        String string = this.mTextFieldUserID.getText();
        if (string.length() != 0) {
            Prefs.setString(PREFERENCES_KEY_USERID, string);
        }
        return string;
    }

    public String getPassword() {
        return new String(this.mTextFieldPassword.getPassword());
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        SwingUtilities.invokeLater(() -> this.mTextFieldPassword.requestFocus());
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

