/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.RDFileParser;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.SwingCanvas;
import com.actelion.research.gui.clipboard.ClipboardHandler;
import com.actelion.research.gui.dnd.MoleculeDropAdapter;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.dnd.ReactionDropAdapter;
import com.actelion.research.gui.dnd.ReactionTransferable;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingCursorHelper;
import com.actelion.research.gui.swing.SwingDrawContext;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class JChemistryView
extends SwingCanvas
implements ActionListener,
DragGestureListener,
DragSourceListener,
MouseListener,
MouseMotionListener {
    public static final int PASTE_AND_DROP_OPTION_ALLOW_FRAGMENT_STATE_CHANGE = 1;
    public static final int PASTE_AND_DROP_OPTION_KEEP_ATOM_COLORS = 2;
    public static final int PASTE_AND_DROP_OPTION_KEEP_BOND_HIGHLIGHTING = 4;
    public static final int PASTE_AND_DROP_OPTION_REMOVE_CATALYSTS = 8;
    public static final int PASTE_AND_DROP_OPTION_REMOVE_DRAWING_OBJECTS = 16;
    public static final int PASTE_AND_DROP_OPTION_LAYOUT_REACTION = 32;
    private static final String ITEM_COPY_RXN = "Copy Reaction";
    private static final String ITEM_PASTE_RXN = "Paste Reaction";
    private static final String ITEM_USE_TEMPLATE = "Use Template";
    private static final String ITEM_OPEN_RXN = "Open Reaction File...";
    private static final String ITEM_SAVE_RXN = "Save Reaction File...";
    private static final String ITEM_COPY_MOLS = "Copy Molecules";
    private static final String ITEM_PASTE_MOLS = "Paste Molecules";
    private static final long serialVersionUID = 20150204L;
    private static final int UPDATE_REDRAW_ONLY = 0;
    private static final int UPDATE_CHECK_COORDS = 1;
    private static final int UPDATE_SCALE_COORDS = 2;
    private static final int PASTE_AND_DROP_OPTIONS_DEFAULT = 0;
    private static final int ALLOWED_DRAG_ACTIONS = 3;
    private static final int ALLOWED_DROP_ACTIONS = 3;
    private static final int DRAG_MARGIN = 12;
    private static final int DRAG_TYPE_NONE = -1;
    private static final int DRAG_TYPE_REACTION = -2;
    private ExtendedDepictor mDepictor;
    private ArrayList<StructureListener> mListener;
    private Dimension mSize;
    private int mChemistryType;
    private int mUpdateMode;
    private int mDisplayMode;
    private int mDragType;
    private int mCopyOrDragActions;
    private int mPasteOrDropActions;
    private int mPasteAndDropOptions;
    private boolean mIsDragging;
    private boolean mAllowDropOrPasteWhenDisabled;
    private boolean mIsEditable;
    private boolean mShowBorder;
    private int mFragmentNoColor;
    private MoleculeDropAdapter mMoleculeDropAdapter = null;
    private ReactionDropAdapter mReactionDropAdapter = null;

    public JChemistryView(int n) {
        this(n, 3, 3);
    }

    public JChemistryView(int n, int n2, int n3) {
        this.mChemistryType = n;
        this.mCopyOrDragActions = n2;
        this.mPasteOrDropActions = n3;
        this.mPasteAndDropOptions = 0;
        this.initializeDragAndDrop();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mDragType = -1;
        this.mIsEditable = false;
    }

    public int getChemistryType() {
        return this.mChemistryType;
    }

    public void setContent(StereoMolecule stereoMolecule) {
        this.setContent(stereoMolecule, null);
    }

    public void setContent(StereoMolecule[] stereoMoleculeArray) {
        this.setContent(stereoMoleculeArray, null);
    }

    public void setContent(Reaction reaction) {
        this.setContent(reaction, null);
    }

    public void setContent(StereoMolecule stereoMolecule, DrawingObjectList drawingObjectList) {
        this.mDepictor = new ExtendedDepictor(stereoMolecule, drawingObjectList);
        this.mDepictor.setDisplayMode(this.mDisplayMode);
        this.mDepictor.setFragmentNoColor(this.mFragmentNoColor);
        this.mUpdateMode = 2;
        this.mDragType = -1;
        this.repaint();
    }

    public void setContent(StereoMolecule[] stereoMoleculeArray, DrawingObjectList drawingObjectList) {
        this.mDepictor = new ExtendedDepictor(stereoMoleculeArray, drawingObjectList);
        this.mDepictor.setDisplayMode(this.mDisplayMode);
        this.mDepictor.setFragmentNoColor(this.mFragmentNoColor);
        this.mUpdateMode = 2;
        this.mDragType = -1;
        this.repaint();
    }

    public void setContent(Reaction reaction, DrawingObjectList drawingObjectList) {
        this.mDepictor = new ExtendedDepictor(reaction, drawingObjectList, reaction == null ? false : reaction.isReactionLayoutRequired());
        this.mDepictor.setDisplayMode(this.mDisplayMode);
        this.mDepictor.setFragmentNoColor(this.mFragmentNoColor);
        this.mUpdateMode = 2;
        this.mDragType = -1;
        this.repaint();
    }

    public void setPasteAndDropOptions(int n) {
        this.mPasteAndDropOptions = n;
    }

    public void setAllowDropOrPasteWhenDisabled(boolean bl) {
        this.mAllowDropOrPasteWhenDisabled = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = bl != this.isEnabled();
        super.setEnabled(bl);
        if (bl2) {
            if (this.mMoleculeDropAdapter != null) {
                this.mMoleculeDropAdapter.setActive(bl);
            }
            if (this.mReactionDropAdapter != null) {
                this.mReactionDropAdapter.setActive(bl);
            }
            if (bl) {
                this.mDepictor.setOverruleColor(0, 0);
            } else {
                this.mDepictor.setOverruleColor(0xFF000000 | ColorHelper.getContrastColor(-8355712, this.getBackground().getRGB()), 0xFF000000 | this.getBackground().getRGB());
            }
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.mIsEditable;
    }

    public void setEditable(boolean bl) {
        if (this.mIsEditable != bl) {
            this.mIsEditable = bl;
        }
    }

    public void setFragmentNoColor(int n) {
        this.mFragmentNoColor = n;
        if (this.mDepictor != null) {
            this.mDepictor.setFragmentNoColor(n);
        }
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
        if (this.mDepictor != null) {
            this.mDepictor.setDisplayMode(n);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        if (this.mDepictor == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return;
        }
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        SwingDrawContext swingDrawContext = new SwingDrawContext((Graphics2D)graphics);
        if (this.mSize == null || this.mSize.width != dimension.width || this.mSize.height != dimension.height || this.mUpdateMode == 2) {
            this.mDepictor.validateView(swingDrawContext, new GenericRectangle(insets.left, insets.top, dimension.width, dimension.height), 65536);
        } else if (this.mUpdateMode == 1) {
            this.mDepictor.validateView(swingDrawContext, new GenericRectangle(insets.left, insets.top, dimension.width, dimension.height), 0);
        }
        this.mSize = dimension;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Color color = graphics2D.getColor();
        Color color2 = null;
        if (!this.isEditable() || !this.isEnabled()) {
            color2 = UIManager.getColor("TextField.inactiveBackground");
        }
        if (color2 == null) {
            color2 = UIManager.getColor("TextField.background");
        }
        if (color2 == null) {
            color2 = Color.WHITE;
        }
        graphics2D.setColor(color2);
        graphics2D.fill(new Rectangle(insets.left, insets.top, dimension.width, dimension.height));
        graphics2D.setColor(color);
        this.mDepictor.setForegroundColor(this.getForeground().getRGB(), this.getBackground().getRGB());
        if (this.mShowBorder && this.mDragType != -1) {
            Color color3 = ColorHelper.perceivedBrightness(color2) < 0.5f ? ColorHelper.brighter(color2, 0.85f) : ColorHelper.darker(color2, 0.85f);
            graphics.setColor(color3);
            object = this.mDragType == -2 ? this.getChemistryBounds() : this.getMoleculeBounds(this.mDragType);
            int n = (int)Math.min(((GenericRectangle)object).height / 4.0, Math.min(((GenericRectangle)object).width / 4.0, (double)HiDPIHelper.scale(10.0f)));
            graphics.fillRoundRect((int)((GenericRectangle)object).x, (int)((GenericRectangle)object).y, (int)((GenericRectangle)object).width, (int)((GenericRectangle)object).height, n, n);
            if (this.mDragType == -2) {
                int n2 = HiDPIHelper.scale(7.0f);
                graphics.setColor(color);
                graphics.setFont(this.getFont().deriveFont((float)n2));
                int n3 = graphics.getFontMetrics().stringWidth("<press 'ALT' to drag individual molecules>");
                int n4 = (int)(((GenericRectangle)object).x + (((GenericRectangle)object).width - (double)n3) / 2.0);
                int n5 = (int)Math.max((double)n2, ((GenericRectangle)object).y - (double)n2);
                graphics.drawString("<press 'ALT' to drag individual molecules>", n4, n5);
            }
        }
        this.mDepictor.paint(swingDrawContext);
        if (this.mWarningMessage != null) {
            int n = HiDPIHelper.scale(12.0f);
            graphics.setFont(this.getFont().deriveFont(1, n));
            object = graphics.getColor();
            graphics.setColor(Color.RED);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.mWarningMessage, graphics);
            graphics.drawString(this.mWarningMessage, insets.left + (int)((double)dimension.width - rectangle2D.getWidth()) / 2, insets.top + fontMetrics.getHeight());
            graphics.setColor((Color)object);
        }
        this.mUpdateMode = 0;
    }

    public GenericRectangle getMoleculeBounds(int n) {
        return this.mDepictor == null || n >= this.mDepictor.getMoleculeCount() ? null : this.mDepictor.getMoleculeDepictor(n).getBoundingRect();
    }

    public GenericRectangle getChemistryBounds() {
        if (this.mDepictor == null || this.mDepictor.getMoleculeCount() == 0) {
            return null;
        }
        GenericRectangle genericRectangle = null;
        for (int i = 0; i < this.mDepictor.getMoleculeCount(); ++i) {
            GenericRectangle genericRectangle2 = this.mDepictor.getMoleculeDepictor(i).getBoundingRect();
            if (genericRectangle2 == null) continue;
            genericRectangle = genericRectangle == null ? genericRectangle2 : genericRectangle.union(genericRectangle2);
        }
        return genericRectangle;
    }

    private void updateBorder(boolean bl) {
        if (this.mShowBorder != bl) {
            this.mShowBorder = bl;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        if (actionEvent.getActionCommand().equals(ITEM_COPY_MOLS)) {
            object = new ClipboardHandler();
            if (this.mDepictor.getMoleculeCount() == 1) {
                ((ClipboardHandler)object).copyMolecule(this.mDepictor.getMolecule(0));
            } else {
                serializable = new StereoMolecule();
                for (int i = 0; i < this.mDepictor.getMoleculeCount(); ++i) {
                    AbstractDepictor abstractDepictor = this.mDepictor.getMoleculeDepictor(i);
                    int n = ((Molecule)serializable).getAllAtoms();
                    StereoMolecule stereoMolecule = this.mDepictor.getMolecule(i);
                    stereoMolecule.copyMolecule((Molecule)serializable);
                    DepictorTransformation depictorTransformation = abstractDepictor.getTransformation();
                    for (int j = 0; j < stereoMolecule.getAllAtoms(); ++j) {
                        ((Molecule)serializable).setAtomX(j + n, depictorTransformation.transformX(stereoMolecule.getAtomX(j)));
                        ((Molecule)serializable).setAtomY(j + n, depictorTransformation.transformY(stereoMolecule.getAtomY(j)));
                    }
                }
                ((ClipboardHandler)object).copyMolecule((StereoMolecule)serializable);
            }
        }
        if (actionEvent.getActionCommand().equals(ITEM_COPY_RXN)) {
            object = new ClipboardHandler();
            serializable = this.mDepictor.getReaction();
            ((ClipboardHandler)object).copyReaction((Reaction)serializable);
        }
        if (actionEvent.getActionCommand().equals(ITEM_PASTE_MOLS) && this.mIsEditable) {
            object = new ClipboardHandler();
            serializable = ((ClipboardHandler)object).pasteMolecule();
            if (serializable != null) {
                this.pasteOrDropMolecule((StereoMolecule)serializable);
            } else {
                this.showWarningMessage("No molecule on clipboard!");
            }
        }
        if (actionEvent.getActionCommand().equals(ITEM_PASTE_RXN) && this.mIsEditable) {
            object = new ClipboardHandler();
            serializable = ((ClipboardHandler)object).pasteReaction();
            if (serializable != null) {
                this.pasteOrDropReaction((Reaction)serializable);
            } else {
                this.showWarningMessage("No reaction on clipboard!");
            }
        }
        if (actionEvent.getActionCommand().startsWith(ITEM_USE_TEMPLATE) && this.mIsEditable) {
            object = ReactionEncoder.decode(actionEvent.getActionCommand().substring(ITEM_USE_TEMPLATE.length()), true);
            if (object != null) {
                this.pasteOrDropReaction((Reaction)object);
            } else {
                this.showWarningMessage("Could not decode template!");
            }
        }
        if (actionEvent.getActionCommand().equals(ITEM_OPEN_RXN) && this.mIsEditable) {
            FileHelper.getFileAsync(this, "Please select a reaction file", 197632, file -> {
                if (file != null) {
                    try {
                        Reaction reaction = null;
                        if (FileHelper.getFileType(file.getName()) == 1024) {
                            reaction = new RXNFileParser().getReaction((File)file);
                        } else {
                            RDFileParser rDFileParser = new RDFileParser((File)file);
                            if (rDFileParser.isReactionNext()) {
                                reaction = rDFileParser.getNextReaction();
                            }
                        }
                        if (reaction != null) {
                            this.pasteOrDropReaction(reaction);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if (actionEvent.getActionCommand().equals(ITEM_SAVE_RXN)) {
            object = this.mDepictor.getReaction();
            new FileHelper(this).saveRXNFile((Reaction)object);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.handlePopupTrigger(mouseEvent);
        this.setCursor(SwingCursorHelper.getCursor(this.mDragType == -1 ? 11 : 4));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.handlePopupTrigger(mouseEvent);
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JMenuItem jMenuItem;
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (this.mChemistryType == 0) {
                if ((this.mCopyOrDragActions & 1) != 0 && this.mDepictor.getMoleculeCount() != 0) {
                    jMenuItem = new JMenuItem(ITEM_COPY_MOLS);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
                if ((this.isEnabled() || this.mAllowDropOrPasteWhenDisabled) && this.mIsEditable && this.mCopyOrDragActions != 0) {
                    jMenuItem = new JMenuItem(ITEM_PASTE_MOLS);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
            }
            if (this.mChemistryType == 1) {
                if ((this.mCopyOrDragActions & 1) != 0 && this.mDepictor.getReaction() != null && !this.mDepictor.getReaction().isEmpty()) {
                    jMenuItem = new JMenuItem(ITEM_COPY_RXN);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
                if ((this.isEnabled() || this.mAllowDropOrPasteWhenDisabled) && this.mIsEditable) {
                    if (this.mCopyOrDragActions != 0) {
                        jMenuItem = new JMenuItem(ITEM_PASTE_RXN);
                        jMenuItem.addActionListener(this);
                        jPopupMenu.add(jMenuItem);
                    }
                    if (GenericEditorArea.getReactionQueryTemplates() != null && this.mDepictor.getReaction() != null && this.mDepictor.getReaction().isFragment()) {
                        jPopupMenu.addSeparator();
                        jMenuItem = null;
                        for (String[] stringArray : GenericEditorArea.getReactionQueryTemplates()) {
                            if ("SECTION".equals(stringArray[0])) {
                                if (jMenuItem != null) {
                                    jPopupMenu.add(jMenuItem);
                                }
                                jMenuItem = new JMenu("Use " + stringArray[1] + " Template");
                                continue;
                            }
                            if (jMenuItem == null) {
                                jMenuItem = new JMenu(ITEM_USE_TEMPLATE);
                            }
                            JMenuItem jMenuItem2 = new JMenuItem(stringArray[0]);
                            jMenuItem2.setActionCommand(ITEM_USE_TEMPLATE + stringArray[1]);
                            jMenuItem2.addActionListener(this);
                            ((JMenu)jMenuItem).add(jMenuItem2);
                        }
                        jPopupMenu.add(jMenuItem);
                    }
                    if (jPopupMenu.getComponentCount() != 0) {
                        jPopupMenu.addSeparator();
                    }
                    jMenuItem = new JMenuItem(ITEM_OPEN_RXN);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
                if (this.mDepictor.getReaction() != null && !this.mDepictor.getReaction().isEmpty()) {
                    if (jPopupMenu.getComponentCount() != 0 || this.isEnabled() || this.mAllowDropOrPasteWhenDisabled) {
                        jPopupMenu.addSeparator();
                    }
                    jMenuItem = new JMenuItem(ITEM_SAVE_RXN);
                    jMenuItem.addActionListener(this);
                    jPopupMenu.add(jMenuItem);
                }
            }
            if (jPopupMenu.getComponentCount() != 0) {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.mIsDragging) {
            this.mDragType = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        if (this.mDepictor != null && (this.mCopyOrDragActions & 1) != 0) {
            boolean bl;
            boolean bl2 = bl = this.mChemistryType != 1 || mouseEvent.isAltDown();
            if (bl) {
                for (int i = 0; i < this.mDepictor.getMoleculeCount(); ++i) {
                    Rectangle rectangle = this.shrink(this.mDepictor.getMoleculeDepictor(i).getBoundingRect());
                    if (rectangle == null || !rectangle.contains(n, n2)) continue;
                    n3 = i;
                    break;
                }
            } else {
                Rectangle rectangle = this.shrink(this.getChemistryBounds());
                if (rectangle != null && rectangle.contains(n, n2)) {
                    n3 = -2;
                }
            }
            if (this.mDragType != n3) {
                this.mDragType = n3;
                this.repaint();
            }
        }
        this.updateBorder(n3 != -1);
        this.setCursor(SwingCursorHelper.getCursor(this.mDragType == -1 ? 11 : 2));
    }

    private Rectangle shrink(GenericRectangle genericRectangle) {
        if (genericRectangle == null) {
            return null;
        }
        int n = HiDPIHelper.scale(12.0f);
        int n2 = Math.min(n, (int)genericRectangle.width / 6);
        int n3 = Math.min(n, (int)genericRectangle.height / 6);
        return new Rectangle((int)genericRectangle.x + n2, (int)genericRectangle.y + n3, (int)genericRectangle.width - 2 * n2, (int)genericRectangle.height - 2 * n3);
    }

    public void addStructureListener(StructureListener structureListener) {
        if (this.mListener == null) {
            this.mListener = new ArrayList();
        }
        this.mListener.add(structureListener);
    }

    public void removeStructureListener(StructureListener structureListener) {
        if (this.mListener != null) {
            this.mListener.remove(structureListener);
        }
    }

    public void informListeners() {
        if (this.mListener != null) {
            for (StructureListener structureListener : this.mListener) {
                structureListener.structureChanged(null);
            }
        }
    }

    public boolean canDrop() {
        return this.isEditable() && (this.isEnabled() || this.mAllowDropOrPasteWhenDisabled) && !this.mIsDragging;
    }

    private void initializeDragAndDrop() {
        if (this.mCopyOrDragActions != 0) {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, this.mCopyOrDragActions, this);
        }
        if (this.mPasteOrDropActions != 0) {
            if (this.mChemistryType == 0) {
                this.mMoleculeDropAdapter = new MoleculeDropAdapter(){

                    @Override
                    public void onDropMolecule(StereoMolecule stereoMolecule, Point point) {
                        if (stereoMolecule != null && JChemistryView.this.canDrop()) {
                            JChemistryView.this.pasteOrDropMolecule(stereoMolecule);
                            JChemistryView.this.onDrop();
                        }
                        JChemistryView.this.updateBorder(false);
                    }

                    @Override
                    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                        boolean bl;
                        boolean bl2 = bl = JChemistryView.this.canDrop() && this.isDropOK(dropTargetDragEvent);
                        if (!bl) {
                            dropTargetDragEvent.rejectDrag();
                        }
                    }

                    @Override
                    public void dragExit(DropTargetEvent dropTargetEvent) {
                    }
                };
                new DropTarget(this, this.mPasteOrDropActions, this.mMoleculeDropAdapter, true);
            }
            if (this.mChemistryType == 1) {
                this.mReactionDropAdapter = new ReactionDropAdapter(){

                    @Override
                    public void onDropReaction(Reaction reaction, Point point) {
                        if (reaction != null && JChemistryView.this.canDrop()) {
                            JChemistryView.this.pasteOrDropReaction(reaction);
                            JChemistryView.this.onDrop();
                        }
                        JChemistryView.this.updateBorder(false);
                    }

                    @Override
                    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                        boolean bl;
                        boolean bl2 = bl = JChemistryView.this.canDrop() && this.isDropOK(dropTargetDragEvent);
                        if (!bl) {
                            dropTargetDragEvent.rejectDrag();
                        }
                    }

                    @Override
                    public void dragExit(DropTargetEvent dropTargetEvent) {
                    }
                };
                new DropTarget(this, this.mPasteOrDropActions, this.mReactionDropAdapter, true);
            }
        }
    }

    private void pasteOrDropMolecule(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        if ((this.mPasteAndDropOptions & 2) == 0) {
            stereoMolecule2.removeAtomColors();
        }
        if ((this.mPasteAndDropOptions & 4) == 0) {
            stereoMolecule2.removeBondHiliting();
        }
        if ((this.mPasteAndDropOptions & 1) == 0 && this.mDepictor != null) {
            stereoMolecule2.setFragment(this.mDepictor.isFragment());
        }
        this.setContent(stereoMolecule2);
        this.repaint();
        this.informListeners();
    }

    private void pasteOrDropReaction(Reaction reaction) {
        int n;
        Reaction reaction2 = new Reaction(reaction);
        if ((this.mPasteAndDropOptions & 2) == 0) {
            for (n = 0; n < reaction2.getMolecules(); ++n) {
                reaction2.getMolecule(n).removeAtomColors();
            }
        }
        if ((this.mPasteAndDropOptions & 4) == 0) {
            for (n = 0; n < reaction2.getMolecules(); ++n) {
                reaction2.getMolecule(n).removeBondHiliting();
            }
        }
        if ((this.mPasteAndDropOptions & 1) == 0 && this.mDepictor != null) {
            reaction2.setFragment(this.mDepictor.isFragment());
        }
        if ((this.mPasteAndDropOptions & 8) != 0) {
            reaction2.removeCatalysts();
        }
        if ((this.mPasteAndDropOptions & 0x10) != 0) {
            reaction2.removeDrawingObjects();
        }
        this.setContent(reaction2);
        this.repaint();
        this.informListeners();
    }

    public Transferable getMoleculeTransferable() {
        StereoMolecule stereoMolecule = this.mDragType < 0 ? null : this.mDepictor.getMolecule(this.mDragType).getCompactCopy();
        return new MoleculeTransferable(stereoMolecule);
    }

    public Transferable getReactionTransferable() {
        return new ReactionTransferable(this.mDepictor.getReaction());
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 3) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        System.out.println("dragDropEnd()");
        this.mIsDragging = false;
        this.mDragType = -1;
        this.repaint();
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 3) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if ((dragGestureEvent.getDragAction() & 3) != 0 && this.mDragType != -1) {
            Transferable transferable;
            Transferable transferable2 = transferable = this.mDragType == -2 ? this.getReactionTransferable() : this.getMoleculeTransferable();
            if (transferable != null) {
                try {
                    dragGestureEvent.startDrag(SwingCursorHelper.getCursor(4), transferable, this);
                    this.mIsDragging = true;
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    System.err.println(invalidDnDOperationException);
                }
            }
        }
    }

    protected void onDragEnter() {
    }

    protected void onDragExit() {
    }

    protected void onDragOver() {
    }

    protected void onDrop() {
    }
}

