/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Deprecated
public class JAtomLabelDialog
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 537395731L;
    private static final String[] RADICAL_STATES = new String[]{"None", "One electron (duplet)", "Two electrons (triplet)", "Two electrons (singulet)"};
    private Window mOwner;
    private ExtendedMolecule mMol;
    private int mAtom;
    private JTextField mTextFieldLabel;
    private JTextField mTextFieldMass;
    private JTextField mTextFieldValence;
    private JComboBox mComboBoxRadical;
    protected Runnable onOK;
    protected Runnable onCancel;

    protected JAtomLabelDialog(Window window, ExtendedMolecule extendedMolecule, int n, Runnable runnable, Runnable runnable2) {
        super(window, Dialog.DEFAULT_MODALITY_TYPE);
        this.mOwner = window;
        this.mMol = extendedMolecule;
        this.mAtom = n;
        this.onOK = runnable;
        this.onCancel = runnable2;
        this.init();
    }

    protected JAtomLabelDialog(Window window, ExtendedMolecule extendedMolecule, int n) {
        super(window, Dialog.DEFAULT_MODALITY_TYPE);
        this.mOwner = window;
        this.mMol = extendedMolecule;
        this.mAtom = n;
        this.init();
    }

    private void init() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        double[][] dArrayArray = new double[][]{{8.0, -2.0, 8.0, -2.0, 8.0}, {8.0, -2.0, 4.0, -2.0, 12.0, -2.0, 4.0, -2.0, 12.0, -2.0, 4.0, -2.0, 12.0, -2.0, 8.0}};
        jPanel.setLayout(new TableLayout(dArrayArray));
        this.mTextFieldLabel = new JTextField(1);
        this.mTextFieldLabel.addActionListener(this);
        jPanel.add((Component)new JLabel("Atom Label:", 4), "1,1");
        jPanel.add((Component)this.mTextFieldLabel, "3,1");
        jPanel.add((Component)new JLabel("(examples: 'D', 'Li', 'Cys', 'R12', 'R3@C')", 4), "1,3,3,3");
        this.mTextFieldMass = new JTextField(1);
        this.mTextFieldMass.addActionListener(this);
        jPanel.add((Component)new JLabel("Atom Mass:", 4), "1,5");
        jPanel.add((Component)this.mTextFieldMass, "3,5");
        jPanel.add((Component)new JLabel("(empty for natural abundance)", 4), "1,7,3,7");
        this.mTextFieldValence = new JTextField(1);
        this.mTextFieldValence.addActionListener(this);
        jPanel.add((Component)new JLabel("Abnormal Valence:", 4), "1,9");
        jPanel.add((Component)this.mTextFieldValence, "3,9");
        jPanel.add((Component)new JLabel("(empty for default valence)", 4), "1,11,3,11");
        if (this.mAtom != -1) {
            object2 = this.mMol.getAtomLabel(this.mAtom);
            object = this.mMol.getAtomCustomLabel(this.mAtom);
            this.mTextFieldLabel.setText((String)(object == null ? object2 : (String)object + "@" + (String)object2));
            if (this.mMol.getAtomMass(this.mAtom) != 0) {
                this.mTextFieldMass.setText("" + this.mMol.getAtomMass(this.mAtom));
            }
            if (this.mMol.getAtomAbnormalValence(this.mAtom) != -1) {
                this.mTextFieldValence.setText("" + this.mMol.getAtomAbnormalValence(this.mAtom));
            }
        }
        this.mComboBoxRadical = new JComboBox<String>(RADICAL_STATES);
        if (this.mAtom != -1) {
            int n = this.mMol.getAtomRadical(this.mAtom);
            this.mComboBoxRadical.setSelectedIndex(n == 32 ? 1 : (n == 48 ? 2 : (n == 16 ? 3 : 0)));
        }
        jPanel.add((Component)new JLabel("Radical State:", 4), "1,13");
        jPanel.add((Component)this.mComboBoxRadical, "3,13");
        object2 = new JPanel();
        ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(12, 8, 8, 8));
        ((Container)object2).setLayout(new BorderLayout());
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout(1, 2, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        ((Container)object).add(jButton2);
        ((Container)object2).add((Component)object, "East");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)object2, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.pack();
        this.setLocationRelativeTo(this.mOwner);
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && this.onCancel != null) {
            this.onCancel.run();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            this.processAtomLabel();
        } else if (actionEvent.getActionCommand() == "Cancel") {
            this.dispose();
            if (this.onCancel != null) {
                this.onCancel.run();
            }
        } else if (actionEvent.getActionCommand() == "OK") {
            this.processAtomLabel();
            if (this.onOK != null) {
                this.onOK.run();
            }
        }
    }

    private void processAtomLabel() {
        int n;
        String string = this.mTextFieldLabel.getText();
        String string2 = null;
        if (string.length() != 0 && (n = string.indexOf(64)) != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.length() != 0 && ((n = Molecule.getAtomicNoFromLabel(string)) != 0 || string.equals("?"))) {
            int n2 = 0;
            if (this.mTextFieldMass.getText().length() != 0) {
                try {
                    n2 = Integer.parseInt(this.mTextFieldMass.getText());
                    if (n2 < Molecule.cRoundedMass[n] - 18 || n2 > Molecule.cRoundedMass[n] + 12) {
                        JOptionPane.showMessageDialog(this.mOwner, "Your mass is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.mOwner, "Your mass is not a number!");
                    return;
                }
            }
            int n3 = -1;
            if (this.mTextFieldValence.getText().length() != 0) {
                try {
                    n3 = Integer.parseInt(this.mTextFieldValence.getText());
                    if (n3 < 0 || n3 > 15) {
                        JOptionPane.showMessageDialog(this.mOwner, "Your valence is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this.mOwner, "Your valence is not a number!");
                    return;
                }
            }
            int n4 = this.mComboBoxRadical.getSelectedIndex() == 1 ? 32 : (this.mComboBoxRadical.getSelectedIndex() == 2 ? 48 : (this.mComboBoxRadical.getSelectedIndex() == 3 ? 16 : 0));
            this.mMol.changeAtom(this.mAtom, n, n2, n3, n4);
            if (string2 != null) {
                this.mMol.setAtomCustomLabel(this.mAtom, string2);
            }
            this.dispose();
        }
    }
}

