/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction.mapping;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.mapping.MappingScorer;
import java.util.ArrayList;
import java.util.TreeMap;

public class ReactionCenterMapper {
    private static final int MAX_PERMUTATION_COUNT = 4000000;
    private ArrayList<UnmappedCenterAtoms> mAtomClasses;
    private StereoMolecule mReactant;
    private StereoMolecule mProduct;
    private int[] mReactantMapNo;
    private int[] mProductMapNo;
    private int mStartMapNo;
    private int mMapNo;

    public ReactionCenterMapper(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int[] nArray, int[] nArray2, int n) {
        UnmappedCenterAtoms unmappedCenterAtoms;
        int n2;
        int n3;
        this.mReactant = stereoMolecule;
        this.mProduct = stereoMolecule2;
        this.mReactantMapNo = nArray;
        this.mProductMapNo = nArray2;
        this.mStartMapNo = n;
        this.mMapNo = n;
        TreeMap<Integer, UnmappedCenterAtoms> treeMap = new TreeMap<Integer, UnmappedCenterAtoms>();
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (nArray[n3] != 0) continue;
            n2 = stereoMolecule.getAtomicNo(n3) + (stereoMolecule.getAtomMass(n3) << 16);
            unmappedCenterAtoms = (UnmappedCenterAtoms)treeMap.get(n2);
            if (unmappedCenterAtoms == null) {
                unmappedCenterAtoms = new UnmappedCenterAtoms();
                treeMap.put(n2, unmappedCenterAtoms);
            }
            unmappedCenterAtoms.addReactantAtom(n3);
        }
        for (n3 = 0; n3 < stereoMolecule2.getAtoms(); ++n3) {
            if (nArray2[n3] != 0) continue;
            n2 = stereoMolecule2.getAtomicNo(n3) + (stereoMolecule2.getAtomMass(n3) << 16);
            unmappedCenterAtoms = (UnmappedCenterAtoms)treeMap.get(n2);
            if (unmappedCenterAtoms == null) {
                unmappedCenterAtoms = new UnmappedCenterAtoms();
                treeMap.put(n2, unmappedCenterAtoms);
            }
            unmappedCenterAtoms.addProductAtom(n3);
        }
        this.mAtomClasses = new ArrayList();
        for (UnmappedCenterAtoms unmappedCenterAtoms2 : treeMap.values()) {
            if (unmappedCenterAtoms2.mapObviousAtoms()) continue;
            this.mAtomClasses.add(unmappedCenterAtoms2);
        }
    }

    public float completeAndScoreMapping() {
        int n;
        boolean bl;
        Object object;
        MappingScorer mappingScorer = new MappingScorer(this.mReactant, this.mProduct);
        int[] nArray = mappingScorer.createReactantToProductAtomMap(this.mReactantMapNo, this.mProductMapNo);
        if (this.mAtomClasses.size() == 0) {
            return mappingScorer.scoreMapping(nArray);
        }
        double d = 1.0;
        for (UnmappedCenterAtoms object22 : this.mAtomClasses) {
            d *= object22.getPermutationCount();
        }
        if (d > 4000000.0) {
            System.out.println("permutationCount exceeds maximum:" + d);
            return 0.0f;
        }
        int n2 = 0;
        int[] nArray2 = new int[this.mAtomClasses.size()];
        int[] nArray3 = new int[this.mAtomClasses.size()];
        for (int f = 0; f < this.mAtomClasses.size(); ++f) {
            object = this.mAtomClasses.get(f);
            nArray3[f] = ((UnmappedCenterAtoms)object).initializePermutations();
            nArray2[f] = n2;
            n2 += ((UnmappedCenterAtoms)object).getMappableAtomCount();
        }
        float f = -1.0E10f;
        object = null;
        int[] nArray4 = null;
        int[] nArray5 = new int[this.mAtomClasses.size()];
        boolean bl2 = bl = this.mAtomClasses.size() != 0;
        block2: while (bl) {
            for (int n4 = 0; n4 < this.mAtomClasses.size(); ++n4) {
                this.mAtomClasses.get(n4).completeReactantToProductAtomMap(nArray5[n4], nArray);
            }
            float i = mappingScorer.scoreMapping(nArray);
            if (f < i) {
                f = i;
                object = new int[n2];
                nArray4 = new int[n2];
                n = 0;
                for (int j = 0; j < this.mAtomClasses.size(); ++j) {
                    UnmappedCenterAtoms unmappedCenterAtoms = this.mAtomClasses.get(j);
                    unmappedCenterAtoms.getReactantAtoms(nArray5[j], (int[])object, n);
                    unmappedCenterAtoms.getProductAtoms(nArray5[j], nArray4, n);
                    n += unmappedCenterAtoms.mMappableAtomCount;
                }
            }
            bl = false;
            for (n = 0; n < nArray5.length; ++n) {
                int n3 = n;
                nArray5[n3] = nArray5[n3] + 1;
                if (nArray5[n] < nArray3[n]) {
                    bl = true;
                    continue block2;
                }
                nArray5[n] = 0;
            }
        }
        if ((double)f != -1.0E10) {
            int n4 = this.mMapNo;
            for (n = 0; n < n2; ++n) {
                this.mReactantMapNo[object[n]] = ++n4;
                this.mProductMapNo[nArray4[n]] = n4;
            }
        }
        return f;
    }

    public int getMappedAtomCount() {
        return this.mMapNo - this.mStartMapNo;
    }

    class UnmappedCenterAtoms {
        private int[] mReactantAtom = new int[0];
        private int[] mProductAtom = new int[0];
        private int mMappableAtomCount = 0;
        private ArrayList<int[]> mPermutationList;

        UnmappedCenterAtoms() {
        }

        public void addReactantAtom(int n) {
            this.mReactantAtom = this.addAtom(n, this.mReactantAtom);
            if (this.mReactantAtom.length <= this.mProductAtom.length) {
                this.mMappableAtomCount = this.mReactantAtom.length;
            }
        }

        public void addProductAtom(int n) {
            this.mProductAtom = this.addAtom(n, this.mProductAtom);
            if (this.mProductAtom.length <= this.mReactantAtom.length) {
                this.mMappableAtomCount = this.mProductAtom.length;
            }
        }

        public boolean mapObviousAtoms() {
            if (this.mMappableAtomCount == 0) {
                return true;
            }
            if (this.mReactantAtom.length == 1 && this.mProductAtom.length == 1) {
                ReactionCenterMapper.this.mMapNo++;
                ((ReactionCenterMapper)ReactionCenterMapper.this).mReactantMapNo[this.mReactantAtom[0]] = ReactionCenterMapper.this.mMapNo;
                ((ReactionCenterMapper)ReactionCenterMapper.this).mProductMapNo[this.mProductAtom[0]] = ReactionCenterMapper.this.mMapNo;
                return true;
            }
            boolean bl = this.areEqualSingleAtoms(this.mReactantAtom, ReactionCenterMapper.this.mReactant);
            if (bl && this.mReactantAtom.length <= this.mProductAtom.length) {
                for (int i = 0; i < this.mReactantAtom.length; ++i) {
                    ReactionCenterMapper.this.mMapNo++;
                    ((ReactionCenterMapper)ReactionCenterMapper.this).mReactantMapNo[this.mReactantAtom[i]] = ReactionCenterMapper.this.mMapNo;
                    ((ReactionCenterMapper)ReactionCenterMapper.this).mProductMapNo[this.mProductAtom[i]] = ReactionCenterMapper.this.mMapNo;
                }
                return true;
            }
            boolean bl2 = this.areEqualSingleAtoms(this.mProductAtom, ReactionCenterMapper.this.mProduct);
            if (bl2 && this.mReactantAtom.length >= this.mProductAtom.length) {
                for (int i = 0; i < this.mProductAtom.length; ++i) {
                    ReactionCenterMapper.this.mMapNo++;
                    ((ReactionCenterMapper)ReactionCenterMapper.this).mReactantMapNo[this.mReactantAtom[i]] = ReactionCenterMapper.this.mMapNo;
                    ((ReactionCenterMapper)ReactionCenterMapper.this).mProductMapNo[this.mProductAtom[i]] = ReactionCenterMapper.this.mMapNo;
                }
                return true;
            }
            return false;
        }

        public double getPermutationCount() {
            int n = Math.max(this.mReactantAtom.length, this.mProductAtom.length);
            double d = 1.0;
            for (int i = n - this.mMappableAtomCount + 1; i <= n; ++i) {
                d *= (double)i;
            }
            return d;
        }

        public int getMappableAtomCount() {
            return this.mMappableAtomCount;
        }

        private boolean areEqualSingleAtoms(int[] nArray, StereoMolecule stereoMolecule) {
            int[] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                if (stereoMolecule.getConnAtoms(n2) == 0) continue;
                return false;
            }
            int n3 = stereoMolecule.getAtomCharge(nArray[0]);
            for (n = 1; n < nArray.length; ++n) {
                if (stereoMolecule.getAtomCharge(nArray[n]) == n3) continue;
                return false;
            }
            return true;
        }

        public int initializePermutations() {
            this.mPermutationList = new ArrayList();
            int[] nArray = new int[this.mMappableAtomCount];
            boolean[] blArray = new boolean[Math.max(this.mReactantAtom.length, this.mProductAtom.length)];
            this.permute(0, blArray, nArray);
            return this.mPermutationList.size();
        }

        private void permute(int n, boolean[] blArray, int[] nArray) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                blArray[i] = true;
                nArray[n] = i;
                if (n + 1 == nArray.length) {
                    this.mPermutationList.add((int[])nArray.clone());
                } else {
                    this.permute(n + 1, blArray, nArray);
                }
                blArray[i] = false;
            }
        }

        public void completeReactantToProductAtomMap(int n, int[] nArray) {
            int[] nArray2 = this.mPermutationList.get(n);
            if (this.mReactantAtom.length <= this.mProductAtom.length) {
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[this.mReactantAtom[i]] = this.mProductAtom[nArray2[i]];
                }
            } else {
                for (int n2 : this.mReactantAtom) {
                    nArray[n2] = -1;
                }
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[this.mReactantAtom[nArray2[i]]] = this.mProductAtom[i];
                }
            }
        }

        public void getReactantAtoms(int n, int[] nArray, int n2) {
            if (this.mReactantAtom.length <= this.mProductAtom.length) {
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[n2 + i] = this.mReactantAtom[i];
                }
            } else {
                int[] nArray2 = this.mPermutationList.get(n);
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[n2 + i] = this.mReactantAtom[nArray2[i]];
                }
            }
        }

        public void getProductAtoms(int n, int[] nArray, int n2) {
            if (this.mReactantAtom.length > this.mProductAtom.length) {
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[n2 + i] = this.mProductAtom[i];
                }
            } else {
                int[] nArray2 = this.mPermutationList.get(n);
                for (int i = 0; i < this.mMappableAtomCount; ++i) {
                    nArray[n2 + i] = this.mProductAtom[nArray2[i]];
                }
            }
        }

        private int[] addAtom(int n, int[] nArray) {
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray.length] = n;
            return nArray2;
        }
    }
}

