/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.TransformerRule;
import com.actelion.research.util.SortedList;
import java.util.ArrayList;
import java.util.Arrays;

public class Transformer {
    private SortedList<TransformerRule> mRuleList;
    private int[] mMinFreeValence;
    private int mBondGain;
    private StereoMolecule mReactant;
    private StereoMolecule mTargetMolecule;
    private SSSearcher mSSSearcher;
    private ArrayList<int[]> mMatchList;
    private String mName;

    public Transformer(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, String string) {
        int n;
        TransformerRule transformerRule;
        int n2;
        this.mName = string;
        stereoMolecule.ensureHelperArrays(7);
        stereoMolecule2.ensureHelperArrays(7);
        this.mBondGain = stereoMolecule2.getBonds() - stereoMolecule.getBonds();
        this.mReactant = stereoMolecule;
        this.mRuleList = new SortedList();
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            this.mRuleList.add(new TransformerRule(stereoMolecule, n2));
        }
        for (n2 = 0; n2 < stereoMolecule2.getBonds(); ++n2) {
            transformerRule = new TransformerRule(stereoMolecule2, n2);
            n = this.mRuleList.getIndex(transformerRule);
            if (n == -1) {
                transformerRule.finishProductOnly();
                this.mRuleList.add(transformerRule);
                continue;
            }
            this.mRuleList.get(n).finishWithProduct(transformerRule);
        }
        for (n2 = this.mRuleList.size() - 1; n2 >= 0; --n2) {
            transformerRule = this.mRuleList.get(n2);
            if (!transformerRule.isFinished()) {
                transformerRule.finishNoProduct();
                continue;
            }
            if (!this.mRuleList.get(n2).isNoChange()) continue;
            this.mRuleList.remove(n2);
        }
        this.mMinFreeValence = new int[stereoMolecule.getAtoms()];
        block3: for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            for (int i = 0; i < stereoMolecule2.getAtoms(); ++i) {
                if (stereoMolecule2.getAtomMapNo(i) != stereoMolecule.getAtomMapNo(n2)) continue;
                n = stereoMolecule.getFreeValence(n2) - stereoMolecule2.getFreeValence(i);
                this.mMinFreeValence[n2] = n > 0 ? n : 0;
                continue block3;
            }
        }
        this.mSSSearcher = new SSSearcher();
    }

    public int setMolecule(StereoMolecule stereoMolecule, int n) {
        this.mTargetMolecule = stereoMolecule;
        this.mSSSearcher.setMol(this.mReactant, this.mTargetMolecule);
        int n2 = 8;
        if (this.mSSSearcher.findFragmentInMolecule(n, n2) == 0) {
            this.mMatchList = null;
            return 0;
        }
        this.mMatchList = this.mSSSearcher.getMatchList();
        block0: for (int i = this.mMatchList.size() - 1; i >= 0; --i) {
            int[] nArray = this.mMatchList.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == -1 || this.mMinFreeValence[j] <= 0 || this.mMinFreeValence[j] <= this.mTargetMolecule.getFreeValence(nArray[j])) continue;
                this.mMatchList.remove(i);
                continue block0;
            }
        }
        return this.mMatchList.size();
    }

    public int[] getTransformedBondList(StereoMolecule stereoMolecule, int n) {
        int n2;
        stereoMolecule.ensureHelperArrays(1);
        int[] nArray = new int[stereoMolecule.getBonds() + this.mBondGain];
        int n3 = 0;
        int[] nArray2 = this.mMatchList.get(n);
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        for (n2 = 0; n2 < this.mRuleList.size(); ++n2) {
            int n4 = this.mRuleList.get(n2).addBondCode(stereoMolecule, nArray2, blArray);
            if (n4 == -1) continue;
            nArray[n3++] = n4;
        }
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            if (blArray[n2]) continue;
            nArray[n3++] = TransformerRule.getBondCode(stereoMolecule.getBondAtom(0, n2), stereoMolecule.getBondAtom(1, n2), stereoMolecule.getBondOrder(n2));
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public void applyTransformation(StereoMolecule stereoMolecule, int n) {
        stereoMolecule.ensureHelperArrays(1);
        int[] nArray = this.mMatchList.get(n);
        for (int i = 0; i < this.mRuleList.size(); ++i) {
            TransformerRule transformerRule = this.mRuleList.get(i);
            transformerRule.adaptBondOrder(stereoMolecule, nArray);
        }
        stereoMolecule.deleteMarkedAtomsAndBonds();
    }

    public String getName() {
        return this.mName;
    }
}

