/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.SortedStringList;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Reactor {
    public static final int MODE_RETAIN_COORDINATES = 1;
    public static final int MODE_FULLY_MAP_REACTIONS = 2;
    public static final int MODE_REMOVE_DUPLICATE_PRODUCTS = 4;
    public static final int MODE_ALLOW_CHARGE_CORRECTIONS = 8;
    private Reaction mGenericReaction;
    private SSSearcher mSSSearcher;
    private StereoMolecule[] mReactant;
    private int[][] mMinFreeValence;
    private boolean[][] mIsReactionCenter;
    private boolean mRetainCoordinates;
    private boolean mFullyMapReactions;
    private boolean mUniqueProductsOnly;
    private boolean mAllowChargeCorrections;
    private int mMaxGenericMapNo;
    private int mMaxCount;
    private int mReactantMatchCombinationCount;
    private ArrayList<int[]>[] mMatchList;
    private int[][][] mReactantMapNo;
    private StereoMolecule[][] mProduct;
    private String[][] mIDCode;
    private boolean[] mIsDuplicate;

    public Reactor(Reaction reaction) {
        this(reaction, false, false, Integer.MAX_VALUE, true);
    }

    public Reactor(Reaction reaction, boolean bl) {
        this(reaction, (bl ? 1 : 0) + 4, Integer.MAX_VALUE);
    }

    @Deprecated
    public Reactor(Reaction reaction, boolean bl, boolean bl2, int n, boolean bl3) {
        this(reaction, (bl ? 1 : 0) + (bl2 ? 2 : 0) + (bl3 ? 4 : 0), n);
    }

    public Reactor(Reaction reaction, int n, int n2) {
        int n3;
        StereoMolecule stereoMolecule;
        int n4;
        int n5;
        int n6;
        StereoMolecule stereoMolecule2;
        int n7;
        this.mRetainCoordinates = (n & 1) != 0;
        this.mFullyMapReactions = (n & 2) != 0;
        this.mUniqueProductsOnly = (n & 4) != 0;
        this.mAllowChargeCorrections = (n & 8) != 0;
        this.mMaxCount = n2;
        this.mGenericReaction = reaction;
        this.mReactant = new StereoMolecule[reaction.getReactants()];
        for (n7 = 0; n7 < reaction.getReactants(); ++n7) {
            reaction.getReactant(n7).setFragment(true);
            reaction.getReactant(n7).ensureHelperArrays(15);
        }
        for (n7 = 0; n7 < reaction.getProducts(); ++n7) {
            reaction.getProduct(n7).ensureHelperArrays(15);
        }
        this.removeMappingErrors(reaction);
        this.mMinFreeValence = new int[reaction.getReactants()][];
        for (n7 = 0; n7 < reaction.getReactants(); ++n7) {
            stereoMolecule2 = reaction.getReactant(n7);
            this.mMinFreeValence[n7] = new int[stereoMolecule2.getAtoms()];
            for (n6 = 0; n6 < stereoMolecule2.getAtoms(); ++n6) {
                n5 = stereoMolecule2.getAtomMapNo(n6);
                if (n5 == 0) continue;
                for (n4 = 0; n4 < reaction.getProducts(); ++n4) {
                    stereoMolecule = reaction.getProduct(n4);
                    for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                        if (stereoMolecule.getAtomMapNo(n3) != n5) continue;
                        int n8 = stereoMolecule2.getFreeValence(n6) - stereoMolecule.getFreeValence(n3);
                        this.mMinFreeValence[n7][n6] = n8 > 0 ? n8 : 0;
                    }
                }
            }
        }
        this.mIsReactionCenter = new boolean[reaction.getProducts()][];
        for (n7 = 0; n7 < reaction.getProducts(); ++n7) {
            stereoMolecule2 = reaction.getProduct(n7);
            this.mIsReactionCenter[n7] = new boolean[stereoMolecule2.getAtoms()];
            for (n6 = 0; n6 < stereoMolecule2.getAtoms(); ++n6) {
                n5 = stereoMolecule2.getAtomMapNo(n6);
                if (n5 == 0) continue;
                for (n4 = 0; n4 < reaction.getReactants(); ++n4) {
                    stereoMolecule = reaction.getReactant(n4);
                    for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                        if (stereoMolecule.getAtomMapNo(n3) != n5 || new IntArrayComparator().compare(this.getSortedConnectedMapNos(stereoMolecule2, n6), this.getSortedConnectedMapNos(stereoMolecule, n3)) == 0 && new IntArrayComparator().compare(this.getSortedConnectedAtomicNos(stereoMolecule2, n6), this.getSortedConnectedAtomicNos(stereoMolecule, n3)) == 0) continue;
                        this.mIsReactionCenter[n7][n6] = true;
                    }
                }
            }
        }
        this.mSSSearcher = new SSSearcher();
        this.mMatchList = new ArrayList[this.mReactant.length];
    }

    private int[] getSortedConnectedAtomicNos(StereoMolecule stereoMolecule, int n) {
        int[] nArray = new int[stereoMolecule.getConnAtoms(n) - stereoMolecule.getExcludedNeighbourCount(n)];
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            if ((stereoMolecule.getAtomQueryFeatures(n3) & 0x20000000L) != 0L) continue;
            nArray[n2++] = stereoMolecule.getAtomicNo(n3);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private int[] getSortedConnectedMapNos(StereoMolecule stereoMolecule, int n) {
        int[] nArray = new int[stereoMolecule.getConnAtoms(n) - stereoMolecule.getExcludedNeighbourCount(n)];
        int n2 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n3 = stereoMolecule.getConnAtom(n, i);
            if ((stereoMolecule.getAtomQueryFeatures(n3) & 0x20000000L) != 0L) continue;
            nArray[n2++] = stereoMolecule.getAtomMapNo(n3);
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private void removeMappingErrors(Reaction reaction) {
        int n;
        int n2;
        int n3;
        this.mMaxGenericMapNo = 0;
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = this.mGenericReaction.getMolecule(i);
            for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                if ((stereoMolecule.getAtomQueryFeatures(j) & 0x20000000L) != 0L) {
                    stereoMolecule.setAtomMapNo(j, 0, false);
                    continue;
                }
                if (this.mMaxGenericMapNo >= stereoMolecule.getAtomMapNo(j)) continue;
                this.mMaxGenericMapNo = stereoMolecule.getAtomMapNo(j);
            }
        }
        boolean[] blArray = new boolean[this.mMaxGenericMapNo + 1];
        for (n3 = 0; n3 < reaction.getReactants(); ++n3) {
            StereoMolecule stereoMolecule = reaction.getReactant(n3);
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0) continue;
                blArray[n] = true;
            }
        }
        for (n3 = 0; n3 < reaction.getProducts(); ++n3) {
            StereoMolecule stereoMolecule = reaction.getProduct(n3);
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0) continue;
                if (!blArray[n]) {
                    stereoMolecule.setAtomMapNo(n2, 0, false);
                    continue;
                }
                blArray[n] = false;
            }
        }
        for (n3 = 0; n3 < reaction.getReactants(); ++n3) {
            StereoMolecule stereoMolecule = reaction.getReactant(n3);
            for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                n = stereoMolecule.getAtomMapNo(n2);
                if (n == 0 || !blArray[n]) continue;
                stereoMolecule.setAtomMapNo(n2, 0, false);
            }
        }
    }

    public boolean setReactant(int n, StereoMolecule stereoMolecule) {
        int n2;
        this.mReactant[n] = stereoMolecule;
        this.mProduct = null;
        StereoMolecule stereoMolecule2 = this.mGenericReaction.getReactant(n);
        this.mSSSearcher.setMol(stereoMolecule2, this.mReactant[n]);
        int n3 = 8 + (this.mAllowChargeCorrections ? 0 : 1);
        if (this.mSSSearcher.findFragmentInMolecule(5, n3) == 0) {
            this.mMatchList[n] = new ArrayList();
            this.mReactantMatchCombinationCount = 0;
            return false;
        }
        this.mMatchList[n] = this.mSSSearcher.getMatchList();
        block0: for (n2 = this.mMatchList[n].size() - 1; n2 >= 0; --n2) {
            int[] nArray = this.mMatchList[n].get(n2);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                int n4 = 0;
                if (this.mAllowChargeCorrections && stereoMolecule2.getAtomCharge(i) == 0 && this.mReactant[n].getAtomCharge(nArray[i]) != 0) {
                    int n5 = this.mReactant[n].getMaxValenceUncharged(nArray[i]);
                    n4 = this.mReactant[n].getElectronValenceCorrection(nArray[i], n5);
                }
                if (this.mMinFreeValence[n][i] <= 0 || this.mMinFreeValence[n][i] <= this.mReactant[n].getFreeValence(nArray[i]) - n4) continue;
                this.mMatchList[n].remove(n2);
                continue block0;
            }
        }
        this.mReactantMatchCombinationCount = 1;
        for (n2 = 0; n2 < this.mReactant.length; ++n2) {
            this.mReactantMatchCombinationCount *= this.mMatchList[n2] == null ? 0 : this.mMatchList[n2].size();
        }
        return true;
    }

    public StereoMolecule[][] getProducts() {
        this.ensureProducts();
        StereoMolecule[][] stereoMoleculeArray = new StereoMolecule[this.getProductCount()][];
        int n = 0;
        for (int i = 0; i < this.mReactantMatchCombinationCount && n < this.mMaxCount; ++i) {
            if (this.mUniqueProductsOnly && this.mIsDuplicate[i]) continue;
            stereoMoleculeArray[n++] = this.mProduct[i];
        }
        return stereoMoleculeArray;
    }

    public String[][] getProductIDCodes() {
        this.ensureProducts();
        String[][] stringArray = new String[this.getProductCount()][];
        int n = 0;
        for (int i = 0; i < this.mReactantMatchCombinationCount && n < this.mMaxCount; ++i) {
            if (this.mUniqueProductsOnly && this.mIsDuplicate[i]) continue;
            stringArray[n++] = this.mIDCode[i];
        }
        return stringArray;
    }

    private int getProductCount() {
        int n = this.mReactantMatchCombinationCount;
        if (this.mUniqueProductsOnly) {
            for (int i = 0; i < this.mReactantMatchCombinationCount; ++i) {
                if (!this.mIsDuplicate[i]) continue;
                --n;
            }
        }
        if (this.mMaxCount > 0 && n > this.mMaxCount) {
            n = this.mMaxCount;
        }
        return n;
    }

    public Reaction[] getFullyMappedReactions() {
        this.ensureProducts();
        Reaction[] reactionArray = new Reaction[this.getProductCount()];
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.mReactant.length];
        do {
            if (!this.mIsDuplicate[n2] || !this.mUniqueProductsOnly) {
                int n3;
                reactionArray[n] = new Reaction();
                for (int i = 0; i < this.mReactant.length; ++i) {
                    StereoMolecule stereoMolecule = this.mReactant[i].getCompactCopy();
                    for (n3 = 0; n3 < this.mReactantMapNo[i][nArray[i]].length; ++n3) {
                        stereoMolecule.setAtomMapNo(n3, this.mReactantMapNo[i][nArray[i]][n3], false);
                    }
                    reactionArray[n].addReactant(stereoMolecule);
                }
                StereoMolecule[] stereoMoleculeArray = this.mProduct[n2];
                int n4 = stereoMoleculeArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    StereoMolecule stereoMolecule = stereoMoleculeArray[n3];
                    reactionArray[n].addProduct(stereoMolecule);
                }
                ++n;
            }
            ++n2;
        } while (this.nextMatchListCombination(nArray) && n < this.mMaxCount);
        return reactionArray;
    }

    private void ensureProducts() {
        int n;
        if (this.mProduct != null) {
            return;
        }
        if (this.mFullyMapReactions) {
            int n2 = this.mMaxGenericMapNo + 1;
            this.mReactantMapNo = new int[this.mReactant.length][][];
            for (int i = 0; i < this.mReactant.length; ++i) {
                this.mReactantMapNo[i] = new int[this.mMatchList[i].size()][];
                for (int j = 0; j < this.mMatchList[i].size(); ++j) {
                    this.mReactantMapNo[i][j] = this.getReactantMapNos(i, this.mMatchList[i].get(j), n2);
                }
                n2 += this.mReactant[i].getAtoms();
                StereoMolecule stereoMolecule = this.mGenericReaction.getReactant(i);
                for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                    if ((stereoMolecule.getAtomQueryFeatures(n) & 0x20000000L) != 0L) continue;
                    --n2;
                }
            }
        }
        this.mProduct = new StereoMolecule[this.mReactantMatchCombinationCount][this.mGenericReaction.getProducts()];
        this.mIDCode = new String[this.mReactantMatchCombinationCount][this.mGenericReaction.getProducts()];
        this.mIsDuplicate = new boolean[this.mReactantMatchCombinationCount];
        SortedStringList sortedStringList = new SortedStringList();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        n = 0;
        if (this.mReactantMatchCombinationCount != 0) {
            int[] nArray = new int[this.mReactant.length];
            do {
                stringBuilder.setLength(0);
                for (int i = 0; i < this.mGenericReaction.getProducts(); ++i) {
                    this.mProduct[n3][i] = this.generateProduct(this.mMatchList, nArray, i);
                    this.mIDCode[n3][i] = new Canonizer(this.mProduct[n3][i]).getIDCode();
                    stringBuilder.append(this.mIDCode[n3][i]);
                }
                boolean bl = this.mIsDuplicate[n3] = sortedStringList.addString(stringBuilder.toString()) == -1;
                if (!this.mUniqueProductsOnly || !this.mIsDuplicate[n3]) {
                    ++n;
                }
                ++n3;
            } while (this.nextMatchListCombination(nArray) && n < this.mMaxCount);
        }
    }

    private boolean nextMatchListCombination(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < this.mMatchList[i].size() - 1) {
                int n = i;
                nArray[n] = nArray[n] + 1;
                return true;
            }
            nArray[i] = 0;
        }
        return false;
    }

    private int[] getReactantMapNos(int n, int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[this.mReactant[n].getAtoms()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = -1;
        }
        StereoMolecule stereoMolecule = this.mGenericReaction.getReactant(n);
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (nArray[n3] == -1) continue;
            nArray2[nArray[n3]] = stereoMolecule.getAtomMapNo(n3);
        }
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            if (nArray2[n3] != -1) continue;
            nArray2[n3] = n2++;
        }
        return nArray2;
    }

    private StereoMolecule generateProduct(ArrayList<int[]>[] arrayListArray, int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        StereoMolecule stereoMolecule = this.mGenericReaction.getProduct(n);
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        int n12 = 0;
        int n13 = 0;
        ArrayList<Integer> arrayList = null;
        for (int i = 0; i < this.mReactant.length; ++i) {
            int n14;
            int n15;
            StereoMolecule stereoMolecule3 = this.mGenericReaction.getReactant(i);
            this.mReactant[i].ensureHelperArrays(1);
            int[] nArray2 = arrayListArray[i].get(nArray[i]);
            int[] nArray3 = new int[this.mReactant[i].getAtoms()];
            boolean[] blArray = new boolean[this.mReactant[i].getAtoms()];
            boolean[] blArray2 = new boolean[this.mReactant[i].getBonds()];
            for (n15 = 0; n15 < stereoMolecule3.getAtoms(); ++n15) {
                if (nArray2[n15] == -1) continue;
                if (stereoMolecule3.getAtomMapNo(n15) == 0) {
                    n11 = nArray2[n15];
                    blArray[n11] = true;
                    for (n14 = 0; n14 < this.mReactant[i].getConnAtoms(n11); ++n14) {
                        blArray2[this.mReactant[i].getConnBond((int)n11, (int)n14)] = true;
                    }
                    continue;
                }
                nArray3[nArray2[n15]] = stereoMolecule3.getAtomMapNo(n15);
            }
            block3: for (n15 = 0; n15 < stereoMolecule3.getBonds(); ++n15) {
                n11 = stereoMolecule3.getBondAtom(0, n15);
                n14 = stereoMolecule3.getBondAtom(1, n15);
                if (stereoMolecule3.getAtomMapNo(n11) == 0 || stereoMolecule3.getAtomMapNo(n14) == 0) continue;
                n10 = nArray2[n11];
                int n16 = nArray2[n14];
                if (n10 == -1 || n16 == -1) continue;
                for (n9 = 0; n9 < this.mReactant[i].getBonds(); ++n9) {
                    if ((this.mReactant[i].getBondAtom(0, n9) != n10 || this.mReactant[i].getBondAtom(1, n9) != n16) && (this.mReactant[i].getBondAtom(0, n9) != n16 || this.mReactant[i].getBondAtom(1, n9) != n10)) continue;
                    blArray2[n9] = true;
                    continue block3;
                }
            }
            int[] nArray4 = new int[this.mReactant[i].getAtoms()];
            block5: for (n11 = 0; n11 < this.mReactant[i].getAtoms(); ++n11) {
                if (blArray[n11]) continue;
                nArray4[n11] = this.mReactant[i].copyAtom(stereoMolecule2, n11, n12, n13);
                if (this.mFullyMapReactions) {
                    stereoMolecule2.setAtomMapNo(nArray4[n11], this.mReactantMapNo[i][nArray[i]][n11], false);
                }
                if (nArray3[n11] == 0) continue;
                stereoMolecule2.setAtomMapNo(nArray4[n11], nArray3[n11], false);
                for (n14 = 0; n14 < stereoMolecule.getAtoms(); ++n14) {
                    if (stereoMolecule.getAtomMapNo(n14) != nArray3[n11]) continue;
                    stereoMolecule2.setAtomCharge(nArray4[n11], stereoMolecule.getAtomCharge(n14));
                    stereoMolecule2.setAtomRadical(nArray4[n11], stereoMolecule.getAtomRadical(n14));
                    if (!this.mIsReactionCenter[n][n14]) continue block5;
                    n10 = this.mReactant[i].getAtomParity(n11);
                    long l = stereoMolecule.getAtomQueryFeatures(n14) & 0xC0000000L;
                    if (l == 0L) {
                        stereoMolecule2.setAtomParity(nArray4[n11], 3, false);
                        continue block5;
                    }
                    if (l == 0xC0000000L) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Integer>();
                        }
                        arrayList.add(nArray4[n11]);
                        continue block5;
                    }
                    if (n10 == 1 || n10 == 2) {
                        n8 = l == 0x80000000L ? 1 : 0;
                        for (n7 = 0; n7 < this.mReactant[i].getConnAtoms(n11); ++n7) {
                            n6 = this.mReactant[i].getConnAtom(n11, n7);
                            if (!blArray[n6]) continue;
                            for (int j = 0; j < this.mReactant[i].getConnAtoms(n11); ++j) {
                                n5 = this.mReactant[i].getConnAtom(n11, j);
                                if (blArray[n5] || n5 <= n6) continue;
                                n8 = n8 == 0 ? 1 : 0;
                            }
                        }
                        if (n8 != 0) {
                            n10 = n10 == 1 ? 2 : 1;
                        }
                        stereoMolecule2.setAtomParity(nArray4[n11], n10, false);
                        continue block5;
                    }
                    stereoMolecule2.setAtomParity(nArray4[n11], 0, false);
                    continue block5;
                }
            }
            for (n11 = 0; n11 < this.mReactant[i].getBonds(); ++n11) {
                if (blArray2[n11]) continue;
                this.mReactant[i].copyBond(stereoMolecule2, n11, n12, n13, nArray4, true);
            }
            n12 = stereoMolecule2.renumberESRGroups(1);
            n13 = stereoMolecule2.renumberESRGroups(2);
        }
        int[] nArray5 = new int[stereoMolecule.getAtoms()];
        block10: for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            int n17 = stereoMolecule.getAtomMapNo(n4);
            if (n17 == 0) {
                nArray5[n4] = stereoMolecule.copyAtom(stereoMolecule2, n4, n12, n13);
                continue;
            }
            for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
                if (stereoMolecule2.getAtomMapNo(i) != n17) continue;
                nArray5[n4] = i;
                continue block10;
            }
        }
        if (this.mRetainCoordinates) {
            for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
                stereoMolecule2.setAtomMarker(nArray5[n4], true);
                stereoMolecule2.setAtomX(nArray5[n4], stereoMolecule.getAtomX(n4));
                stereoMolecule2.setAtomY(nArray5[n4], stereoMolecule.getAtomY(n4));
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getBonds(); ++n4) {
            if (stereoMolecule.isBondBridge(n4)) continue;
            int n18 = stereoMolecule.copyBond(stereoMolecule2, n4, n12, n13, nArray5, false);
            int n19 = stereoMolecule.getBondQueryFeatures(n4) & 0x1F;
            if (n19 == 0) continue;
            boolean bl = false;
            stereoMolecule2.setBondQueryFeature(n18, 31, false);
            int n20 = stereoMolecule.getAtomMapNo(stereoMolecule.getBondAtom(0, n4));
            int n21 = stereoMolecule.getAtomMapNo(stereoMolecule.getBondAtom(1, n4));
            for (n11 = 0; !bl && n11 < this.mGenericReaction.getReactants(); ++n11) {
                StereoMolecule stereoMolecule4 = this.mGenericReaction.getReactant(n11);
                for (n10 = 0; !bl && n10 < stereoMolecule4.getBonds(); ++n10) {
                    int n22 = stereoMolecule4.getBondAtom(0, n10);
                    n9 = stereoMolecule4.getBondAtom(1, n10);
                    n8 = stereoMolecule4.getAtomMapNo(n22);
                    n7 = stereoMolecule4.getAtomMapNo(n9);
                    if (n8 == 0 || n7 == 0 || (n8 != n20 || n7 != n21) && (n8 != n21 || n7 != n20)) continue;
                    bl = true;
                    n6 = stereoMolecule4.getBondQueryFeatures(n10) & 0x1F;
                    if (n6 == 0) continue;
                    int[] nArray6 = arrayListArray[n11].get(nArray[n11]);
                    n5 = nArray6[n22];
                    int n23 = nArray6[n9];
                    int n24 = this.mReactant[n11].getBond(n5, n23);
                    int n25 = this.mReactant[n11].getBondType(n24);
                    int n26 = this.mReactant[n11].getBondOrder(n24);
                    if ((n6 &= 7) == 3 && (n19 &= 7) == 6) {
                        stereoMolecule2.setBondType(n18, n26 <= 1 ? 2 : 4);
                        continue;
                    }
                    if (n6 == 6 && n19 == 3) {
                        stereoMolecule2.setBondType(n18, n26 == 3 ? 2 : 1);
                        continue;
                    }
                    stereoMolecule2.setBondType(n18, n25);
                }
            }
        }
        stereoMolecule2.ensureHelperArrays(1);
        n4 = 0;
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            int n27;
            if (stereoMolecule.getAtomMapNo(i) == 0) {
                n27 = stereoMolecule.translateTHParity(i, nArray5);
                stereoMolecule2.setAtomParity(nArray5[i], n27, false);
                continue;
            }
            if (!this.mIsReactionCenter[n][i] || !this.copyConfigurationFromGenericProduct(stereoMolecule, i, stereoMolecule2, nArray5[i])) continue;
            n27 = stereoMolecule.translateTHParity(i, nArray5);
            stereoMolecule2.setAtomParity(nArray5[i], n27, false);
            if (n27 != 1 && n27 != 2) continue;
            int n28 = stereoMolecule.getAtomESRType(i);
            int n29 = stereoMolecule.getAtomESRGroup(i);
            if (n28 == 1) {
                n29 += n12;
            } else if (n28 == 2) {
                n29 += n13;
            }
            stereoMolecule2.setAtomESR(nArray5[i], n28, n29);
            n4 = 1;
        }
        if (n4 != 0) {
            n12 = stereoMolecule2.renumberESRGroups(1);
            n13 = stereoMolecule2.renumberESRGroups(2);
        }
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (!this.mIsReactionCenter[n][i] || blArray[i] || !stereoMolecule.isAtomParityPseudo(i) || (stereoMolecule.getAtomQueryFeatures(i) & 0xC0000000L) != 0L || stereoMolecule.getConnAtoms(i) != stereoMolecule2.getConnAtoms(nArray5[i])) continue;
            this.copyPseudoParitiesFromGenericProduct(stereoMolecule, i, stereoMolecule2, nArray5, blArray);
        }
        boolean[] blArray3 = new boolean[stereoMolecule2.getAllAtoms()];
        for (n3 = 0; n3 < nArray5.length; ++n3) {
            blArray3[nArray5[n3]] = true;
        }
        n3 = 1;
        while (n3 != 0) {
            n3 = 0;
            for (int i = 0; i < stereoMolecule2.getAllBonds(); ++i) {
                int n30 = stereoMolecule2.getBondAtom(0, i);
                n11 = stereoMolecule2.getBondAtom(1, i);
                if (blArray3[n30] && !blArray3[n11]) {
                    blArray3[n11] = true;
                    n3 = 1;
                    continue;
                }
                if (!blArray3[n11] || blArray3[n30]) continue;
                blArray3[n30] = true;
                n3 = 1;
            }
        }
        for (n2 = 0; n2 < stereoMolecule2.getAllAtoms(); ++n2) {
            stereoMolecule2.setAtomSelection(n2, !blArray3[n2]);
        }
        stereoMolecule2.deleteSelectedAtoms();
        if (!this.mFullyMapReactions) {
            for (n2 = 0; n2 < stereoMolecule2.getAllAtoms(); ++n2) {
                stereoMolecule2.setAtomMapNo(n2, 0, false);
            }
        }
        new AromaticityResolver(stereoMolecule2).locateDelocalizedDoubleBonds(null);
        stereoMolecule2.setParitiesValid(0);
        n2 = 2 | (this.mRetainCoordinates ? 8 : 0);
        new CoordinateInventor(n2).invent(stereoMolecule2);
        if (arrayList != null) {
            stereoMolecule2.ensureHelperArrays(15);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                n11 = (Integer)iterator.next();
                if (!stereoMolecule2.isAtomStereoCenter(n11)) continue;
                stereoMolecule2.setAtomParity(n11, 1, false);
                stereoMolecule2.setAtomESR(n11, 1, n12++);
            }
        }
        return stereoMolecule2;
    }

    private void copyPseudoParitiesFromGenericProduct(StereoMolecule stereoMolecule, int n, StereoMolecule stereoMolecule2, int[] nArray, boolean[] blArray) {
        int[] nArray2 = new int[stereoMolecule.getAtoms()];
        int n2 = this.findRelatedPseudoParityAtoms(stereoMolecule, n, nArray2);
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!stereoMolecule.isAtomParityPseudo(nArray2[i])) continue;
            int n4 = stereoMolecule.translateTHParity(nArray2[i], nArray);
            if (!(n4 != 1 && n4 != 2 || (n3 = stereoMolecule2.getAtomParity(nArray[nArray2[i]])) != 1 && n3 != 2)) {
                if (n4 == n3) {
                    bl = true;
                } else {
                    bl2 = true;
                }
            }
            int[] nArray3 = new int[]{nArray2[i], n4};
            arrayList.add(nArray3);
        }
        if (!(arrayList == null || bl && bl2)) {
            for (int[] nArray4 : arrayList) {
                int n5 = nArray4[1];
                if ((n5 == 1 || n5 == 2) && bl2) {
                    n5 = n5 == 1 ? 2 : 1;
                }
                stereoMolecule2.setAtomParity(nArray[nArray4[0]], n5, true);
            }
        }
    }

    private int findRelatedPseudoParityAtoms(StereoMolecule stereoMolecule, int n, int[] nArray) {
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        nArray[0] = n;
        int n2 = 1;
        blArray[n] = true;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < stereoMolecule.getConnAtoms(nArray[i]); ++j) {
                int n3;
                int n4 = stereoMolecule.getConnBond(nArray[i], j);
                if (!stereoMolecule.isRingBond(n4) && stereoMolecule.getBondOrder(n4) != 2 && !stereoMolecule.isBINAPChiralityBond(n4) || blArray[n3 = stereoMolecule.getConnAtom(nArray[i], j)]) continue;
                nArray[n2++] = n3;
                blArray[n3] = true;
            }
        }
        return n2;
    }

    private boolean copyConfigurationFromGenericProduct(StereoMolecule stereoMolecule, int n, StereoMolecule stereoMolecule2, int n2) {
        int n3;
        if (stereoMolecule.getAtomParity(n) != 0 && !stereoMolecule.isAtomParityPseudo(n) && (stereoMolecule.getAtomQueryFeatures(n) & 0xC0000000L) == 0L && (n3 = stereoMolecule.getAtomMapNo(n)) != 0) {
            for (int i = 0; i < this.mGenericReaction.getReactants(); ++i) {
                StereoMolecule stereoMolecule3 = this.mGenericReaction.getReactant(i);
                for (int j = 0; j < stereoMolecule3.getAtoms(); ++j) {
                    if (stereoMolecule3.getAtomMapNo(j) != n3) continue;
                    if (stereoMolecule.getConnAtoms(n) == stereoMolecule2.getConnAtoms(n2)) {
                        return true;
                    }
                    if ((stereoMolecule3.getAtomQueryFeatures(j) & 0x2000L) != 0L) {
                        return true;
                    }
                    return stereoMolecule3.getAtomESRType(j) != stereoMolecule.getAtomESRType(n);
                }
            }
        }
        return false;
    }
}

