/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.reaction;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Classification;
import com.actelion.research.chem.reaction.ClassificationData;
import com.actelion.research.chem.reaction.DatabaseReaction;
import com.actelion.research.chem.reaction.Reaction;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class ReactionClassifier {
    private static final boolean DEBUG = true;
    private static final int MAXFATMS = 64;
    private static final int MAXATMCNO = 190;
    private static final int MAXCONNS = 6;
    private static final int MAXATOMS = 256;
    private static final int MAXMPPNGNO = 512;
    private static final int MAXINDICES = 8;
    private static final int MAXFLASH = 10;
    private static final int MAXUNITS = 16;
    private static final int S_CONST = 0;
    private static final int HD_D_CONST = 1;
    private static final int D_D_CONST = 2;
    private static final int HD_REAR = 3;
    private static final int D_REAR = 4;
    private static final int S_FRAG = 5;
    private static final int C1_REFU = 6;
    private static final int LONG_REFU = 7;
    private static final int HETERO_REFU = 8;
    private static final int HD_D_FRAG = 9;
    private static final int D_D_FRAG = 10;
    private static final int E_RING_C = 11;
    private static final int E_RING_O = 12;
    private static final int BONDBITS = 5;
    private static final int HRXNBITS = 25;
    private static final int DRXNBITS = 11;
    private static final int CRXNBITS = 4;
    private static final int REARBITS = 13;
    private static final int PROPBITS = 11;
    public static final int cErrorNoError = 0;
    public static final int cErrorNoChangeNorEFG = 1;
    public static final int cErrorEductMapNoOverused = 2;
    public static final int cErrorProdMapNoOverused1 = 3;
    public static final int cErrorProdMapNoOverused2 = 4;
    public static final int cErrorMapNoNotInProduct = 5;
    public static final int cErrorMapNoNotInEduct = 6;
    public static final int cErrorDupProdMapNoDifEd = 7;
    public static final int cErrorProdRemapFailed = 9;
    public static final int cErrorEduFragPartMapped = 10;
    public static final int cErrorFragmentAtomLimit = 11;
    public static final int cErrorProdFragPartMapped = 12;
    public static final int cErrorUnexpected = 13;
    public static final int cErrorUnMappedCInConOrFr = 14;
    public static final int cErrorCCBondCleavageLimit = 15;
    public static final int cErrorCCBondCreationLimit = 16;
    public static final int cErrorComplexReaction = 17;
    public static final int cErrorNoChangingAtoms = 18;
    public static final int cErrorForkedOrLongStrand = 19;
    public static final int cError2AlphasInSameStrand = 20;
    public static final int cErrorHRClassifyError = 21;
    public static final int cErrorCRClassifyError = 22;
    public static final int cErrorDRClassifyError = 23;
    public static final int cErrorRAClassifyError = 24;
    public static final int cErrorREClassifyError = 25;
    public static final int cErrorIncoOrLeavMissing = 26;
    public static final int cErrorUnitReactionLimit = 27;
    public static final int cErrorNoDatabaseReaction = 28;
    public static final int cIndexNone = 0;
    public static final int cIndexOnePermToFile = 1;
    public static final int cIndexFullPermutation = 2;
    private static final int cAtomPiChange = 256;
    private static final int cAtomZChange = 512;
    private static final int cAtomSigmaChange = 1024;
    private static final int cAtomChanges = 4096;
    private static final int cAtomNoCounterAtom = 8192;
    private static final int cAtomDBondToHetero = 16384;
    private static final int cAtomNotClassifiedYet = 32768;
    private static final int CARBON = 1;
    private static int data;
    private static int mask;
    private static int indexnum;
    private static int indexpoin;
    private static int availbits;
    private ClassificationData mClassificationData = ClassificationData.getInstance();
    private BufferedWriter gErrout;
    private Reaction mRxn;
    private Classification mResult;
    private int mIndexToCreate;
    private int mUnitRxn;
    private int[][] mAtomType;
    private int[][] mSigma;
    private int[][] mPi;
    private int[][] mH;
    private int[][] mZ;
    private int[][] mAtomFlags;
    private int[][] mCorProd;
    private int[][] mCorAtom;
    private int[][][] mConnMpNo;
    private int[][][] mConnCMNo;
    private int[][][] mConnType;

    public int classify(Reaction reaction) {
        return this.classify(0, reaction);
    }

    public int classify(int n, Reaction reaction) {
        int n2;
        this.mIndexToCreate = n;
        this.mRxn = reaction;
        if (n != 0 && !(reaction instanceof DatabaseReaction)) {
            return 28;
        }
        for (n2 = 0; n2 < this.mRxn.getMolecules(); ++n2) {
            this.mRxn.getMolecule(n2).ensureHelperArrays(15);
        }
        n2 = this.ensureCleanMapping();
        if (n2 != 0) {
            return n2;
        }
        this.mResult = new Classification();
        try {
            this.gErrout = new BufferedWriter(new FileWriter("errout.txt"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n2 = this.classrxn();
        try {
            this.gErrout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 != 0) {
            this.mResult = null;
            return n2;
        }
        if (this.mUnitRxn == 0 && this.mResult.mEnduringFGs == 0) {
            this.mResult = null;
            return 1;
        }
        return n2;
    }

    public Classification getClassificationResult() {
        return this.mResult;
    }

    private int ensureCleanMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        StereoMolecule stereoMolecule;
        int n7;
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        int[] nArray3 = new int[512];
        int[] nArray4 = new int[512];
        int[] nArray5 = new int[512];
        int[] nArray6 = new int[256];
        for (n7 = 0; n7 < this.mRxn.getReactants(); ++n7) {
            stereoMolecule = this.mRxn.getReactant(n7);
            n6 = 0;
            for (n5 = 1; n5 < 512; ++n5) {
                nArray[n5] = 0;
            }
            for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
                n4 = stereoMolecule.getAtomMapNo(n5);
                if (n4 == 0) continue;
                int n8 = n4;
                nArray[n8] = nArray[n8] + 1;
                if (nArray[n4] == 2) {
                    n6 = 1;
                    continue;
                }
                if (nArray[n4] <= 2) continue;
                return 2;
            }
            if (n6 == 0) continue;
            for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
                nArray6[n5] = 0;
                n4 = stereoMolecule.getAtomMapNo(n5);
                if (n4 == 0 || nArray[n4] != 2) continue;
                nArray6[n5] = 1;
            }
            for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
                if (nArray6[n5] == 0) continue;
                this.unmapFragment(stereoMolecule, n5, nArray6);
            }
        }
        for (n7 = 1; n7 < 512; ++n7) {
            nArray2[n7] = 0;
            nArray[n7] = 0;
        }
        for (n7 = 0; n7 < this.mRxn.getReactants(); ++n7) {
            stereoMolecule = this.mRxn.getReactant(n7);
            for (n6 = 0; n6 < stereoMolecule.getAtoms(); ++n6) {
                n5 = stereoMolecule.getAtomMapNo(n6);
                if (n5 == 0) continue;
                if (nArray[n5] != 0) {
                    if (nArray3[n5] != n7) {
                        stereoMolecule.setAtomMapNo(n6, 0, false);
                        continue;
                    }
                    return 2;
                }
                int n9 = n5;
                nArray[n9] = nArray[n9] + 1;
                nArray3[n5] = n7;
                nArray4[n5] = n6;
            }
        }
        n7 = -1;
        for (n3 = 0; n3 < this.mRxn.getProducts(); ++n3) {
            StereoMolecule stereoMolecule2 = this.mRxn.getProduct(n3);
            for (n5 = 0; n5 < stereoMolecule2.getAtoms(); ++n5) {
                n4 = stereoMolecule2.getAtomMapNo(n5);
                if (n4 == 0) continue;
                if (nArray2[n4] != 0) {
                    if (nArray5[n4] != n3) {
                        stereoMolecule2.setAtomMapNo(n5, 0, false);
                        continue;
                    }
                    if (nArray2[n4] > 1) {
                        return 3;
                    }
                    if (n7 != -1 && n7 != n3) {
                        return 4;
                    }
                    n7 = n3;
                }
                int n10 = n4;
                nArray2[n10] = nArray2[n10] + 1;
                nArray5[n4] = n3;
            }
        }
        if (n7 == -1) {
            return 0;
        }
        n3 = 0;
        for (n2 = 1; n2 < 512; ++n2) {
            if (nArray[n2] > 0 && nArray2[n2] > 0) {
                n3 = n2;
                continue;
            }
            if (nArray[n2] != 0) {
                return 5;
            }
            if (nArray2[n2] == 0) continue;
            return 6;
        }
        n2 = -1;
        for (n5 = 1; n5 <= n3; ++n5) {
            if (nArray2[n5] <= 1) continue;
            if (n2 != -1 && n2 != nArray3[n5]) {
                return 7;
            }
            n2 = nArray3[n5];
        }
        StereoMolecule stereoMolecule3 = new StereoMolecule(this.mRxn.getReactant(n2));
        stereoMolecule3.ensureHelperArrays(15);
        this.mRxn.addReactant(stereoMolecule3, n2);
        StereoMolecule stereoMolecule4 = this.mRxn.getProduct(n7);
        for (n = 0; n < stereoMolecule4.getAtoms(); ++n) {
            nArray6[n] = 0;
            int n11 = stereoMolecule4.getAtomMapNo(n);
            if (n11 == 0 || nArray2[n11] != 2) continue;
            nArray6[n] = 1;
        }
        for (n = 0; n < stereoMolecule4.getAtoms(); ++n) {
            if (nArray6[n] == 0 || !this.tryRemapFragment(this.mRxn.getReactant(n2), stereoMolecule3, this.mRxn.getProduct(n7), n, n3, nArray4, nArray6)) continue;
            return 0;
        }
        return 9;
    }

    private void unmapFragment(StereoMolecule stereoMolecule, int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            if (n2 == n || nArray[n2] == 0 || stereoMolecule.getAtomMapNo(n) != stereoMolecule.getAtomMapNo(n2)) continue;
            nArray[n2] = 0;
            break;
        }
        nArray[n] = 0;
        stereoMolecule.setAtomMapNo(n, 0, false);
        for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n); ++n2) {
            int n3 = stereoMolecule.getConnAtom(n, n2);
            if (nArray[n3] == 0) continue;
            this.unmapFragment(stereoMolecule, n3, nArray);
        }
    }

    private boolean tryRemapFragment(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, StereoMolecule stereoMolecule3, int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        int n5 = n;
        nArray2[n5] = nArray2[n5] | 2;
        this.checkAdjacent(stereoMolecule, stereoMolecule3, n, nArray, nArray2);
        int n6 = 0;
        for (n4 = 0; n4 < stereoMolecule3.getAtoms(); ++n4) {
            if ((nArray2[n4] & 2) == 0) continue;
            ++n6;
        }
        if (n2 + n6 > 512) {
            return false;
        }
        boolean bl = true;
        for (n4 = 0; n4 < stereoMolecule3.getAtoms(); ++n4) {
            if ((nArray2[n4] & 2) == 0) continue;
            n3 = nArray[stereoMolecule3.getAtomMapNo(n4)];
            if ((nArray2[n3] & 4) != 0) {
                bl = false;
                break;
            }
            int n7 = n3;
            nArray2[n7] = nArray2[n7] | 4;
        }
        if (bl) {
            for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
                if (stereoMolecule.getAtomMapNo(n4) == 0 || (nArray2[n4] & 4) != 0) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            for (n4 = 0; n4 < stereoMolecule3.getAtoms(); ++n4) {
                if ((nArray2[n4] & 2) == 0) continue;
                n3 = nArray[stereoMolecule3.getAtomMapNo(n4)];
                stereoMolecule3.setAtomMapNo(n4, ++n2, false);
                stereoMolecule.setAtomMapNo(n3, n2, false);
                if ((nArray2[n4] & 1) != 0) continue;
                stereoMolecule2.setAtomMapNo(n3, 0, false);
            }
        }
        n4 = 0;
        while (n4 < 256) {
            int n8 = n4++;
            nArray2[n8] = nArray2[n8] & 0xF9;
        }
        return bl;
    }

    private void checkAdjacent(StereoMolecule stereoMolecule, StereoMolecule stereoMolecule2, int n, int[] nArray, int[] nArray2) {
        int n2 = nArray[stereoMolecule2.getAtomMapNo(n)];
        for (int i = 0; i < stereoMolecule2.getConnAtoms(n); ++i) {
            int n3;
            int n4 = stereoMolecule2.getConnAtom(n, i);
            int n5 = stereoMolecule2.getAtomMapNo(n4);
            if (n5 == 0 || (nArray2[n4] & 2) != 0 || n5 == stereoMolecule2.getAtomMapNo(n)) continue;
            boolean bl = false;
            for (n3 = 0; n3 < stereoMolecule2.getConnAtoms(n) && n3 != i; ++n3) {
                int n6 = stereoMolecule2.getConnAtom(n, n3);
                if (n5 != stereoMolecule2.getAtomMapNo(n6)) continue;
                bl = true;
            }
            if (bl) continue;
            boolean bl2 = false;
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n2); ++n3) {
                if (n5 != stereoMolecule.getAtomMapNo(stereoMolecule.getConnAtom(n2, n3))) continue;
                bl2 = true;
            }
            if (!bl2) continue;
            int n7 = n4;
            nArray2[n7] = nArray2[n7] | 2;
            this.checkAdjacent(stereoMolecule, stereoMolecule2, n4, nArray, nArray2);
        }
    }

    private int classrxn() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[]{0, 3, 0, 3, 3, 3, 1, 130, 2, 6, 0, 3, 3, 3, 3, 146, 66, 46, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 178, 74, 78, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 106, 110, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 3, 3, 238, 1, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray2 = new int[10];
        int[] nArray3 = new int[10];
        int[] nArray4 = new int[10];
        int[] nArray5 = new int[10];
        int[] nArray6 = new int[64];
        for (n9 = 0; n9 < 16; ++n9) {
            this.mResult.mStereoInfo[n9] = 0;
            for (int i = 0; i < 10; ++i) {
                this.mResult.mFlashMol[n9][i] = -1;
                this.mResult.mFlashAtom[n9][i] = -1;
            }
        }
        this.mUnitRxn = 0;
        this.mSigma = new int[this.mRxn.getMolecules()][];
        this.mPi = new int[this.mRxn.getMolecules()][];
        this.mH = new int[this.mRxn.getMolecules()][];
        this.mZ = new int[this.mRxn.getMolecules()][];
        this.mAtomType = new int[this.mRxn.getMolecules()][];
        this.mAtomFlags = new int[this.mRxn.getMolecules()][];
        this.mCorProd = new int[this.mRxn.getMolecules()][];
        this.mCorAtom = new int[this.mRxn.getMolecules()][];
        this.mConnMpNo = new int[this.mRxn.getMolecules()][][];
        this.mConnCMNo = new int[this.mRxn.getMolecules()][][];
        this.mConnType = new int[this.mRxn.getMolecules()][][];
        for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            this.mSigma[n9] = new int[stereoMolecule.getAtoms()];
            this.mPi[n9] = new int[stereoMolecule.getAtoms()];
            this.mH[n9] = new int[stereoMolecule.getAtoms()];
            this.mZ[n9] = new int[stereoMolecule.getAtoms()];
            this.mAtomType[n9] = new int[stereoMolecule.getAtoms()];
            this.mAtomFlags[n9] = new int[stereoMolecule.getAtoms()];
            this.mCorProd[n9] = new int[stereoMolecule.getAtoms()];
            this.mCorAtom[n9] = new int[stereoMolecule.getAtoms()];
            this.mConnMpNo[n9] = new int[stereoMolecule.getAtoms()][6];
            this.mConnCMNo[n9] = new int[stereoMolecule.getAtoms()][6];
            this.mConnType[n9] = new int[stereoMolecule.getAtoms()][6];
        }
        for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            for (n8 = 0; n8 < stereoMolecule.getAtoms(); ++n8) {
                int n10 = stereoMolecule.getAtomicNo(n8);
                if (n10 >= 1 && n10 <= 190) {
                    this.mAtomType[n9][n8] = nArray[n10];
                    continue;
                }
                if (this.gErrout == null) continue;
                try {
                    this.gErrout.write("Rxn: " + this.mRxn.getName() + ", unknown atomic #: " + n10);
                    this.gErrout.newLine();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            for (n8 = 0; n8 < stereoMolecule.getBonds(); ++n8) {
                for (int i = 0; i < 2; ++i) {
                    int n11 = stereoMolecule.getBondAtom(i, n8);
                    n7 = stereoMolecule.getBondAtom(1 - i, n8);
                    n6 = this.mAtomType[n9][n7];
                    block24: for (int j = 0; j < stereoMolecule.getBondOrder(n8); ++j) {
                        for (i = 0; i < 6; ++i) {
                            if (n6 <= this.mConnType[n9][n11][i]) continue;
                            if (this.mConnType[n9][n11][i] != 0) {
                                for (n5 = 5; n5 > i; --n5) {
                                    this.mConnType[n9][n11][n5] = this.mConnType[n9][n11][n5 - 1];
                                }
                            }
                            this.mConnType[n9][n11][i] = n6;
                            continue block24;
                        }
                    }
                }
            }
            if (this.gErrout == null) continue;
            for (n8 = 0; n8 < stereoMolecule.getAtoms(); ++n8) {
                try {
                    this.gErrout.write("Atom:" + n8 + "; mConnAtom:");
                    for (int i = 0; i < stereoMolecule.getConnAtoms(n8); ++i) {
                        this.gErrout.write(" " + stereoMolecule.getConnAtom(n8, i));
                    }
                    this.gErrout.newLine();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        for (n9 = 0; n9 < this.mRxn.getReactants(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getReactant(n9);
            int[] nArray7 = new int[256];
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                int n12 = stereoMolecule.getAtomMapNo(i);
                if (n12 == 0) {
                    if (this.mAtomType[n9][i] == 1 && nArray7[i] == 0) {
                        n7 = this.findFrag(n9, i, nArray6, nArray7);
                        if (n7 != 0) {
                            return n7;
                        }
                        for (n6 = 1; n6 <= nArray6[0]; ++n6) {
                            if (stereoMolecule.getAtomMapNo(nArray6[n6]) == 0) continue;
                            return 10;
                        }
                    }
                    this.mCorProd[n9][i] = 0;
                    this.mCorAtom[n9][i] = 255;
                    continue;
                }
                n7 = 0;
                for (n6 = this.mRxn.getReactants(); n6 < this.mRxn.getMolecules(); ++n6) {
                    StereoMolecule stereoMolecule2 = this.mRxn.getMolecule(n6);
                    for (n5 = 0; n5 < stereoMolecule2.getAtoms(); ++n5) {
                        if (n12 != stereoMolecule2.getAtomMapNo(n5)) continue;
                        this.mCorProd[n9][i] = n6;
                        this.mCorAtom[n9][i] = n5;
                        this.mH[n6][n5] = 1;
                        n7 = 1;
                        break;
                    }
                    if (n7 != 0) break;
                }
                if (n7 != 0) continue;
                return 5;
            }
        }
        for (n9 = this.mRxn.getReactants(); n9 < this.mRxn.getMolecules(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            int[] nArray8 = new int[256];
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                int n13;
                if (stereoMolecule.getAtomMapNo(i) == 0) {
                    if (this.mAtomType[n9][i] != 1) {
                        int[] nArray9 = this.mAtomFlags[n9];
                        int n14 = i;
                        nArray9[n14] = nArray9[n14] | 0x3000;
                        continue;
                    }
                    if (nArray8[i] != 0) continue;
                    n13 = this.findFrag(n9, i, nArray6, nArray8);
                    if (n13 != 0) {
                        return n13;
                    }
                    for (n7 = 1; n7 <= nArray6[0]; ++n7) {
                        int[] nArray10 = this.mAtomFlags[n9];
                        int n15 = nArray6[n7];
                        nArray10[n15] = nArray10[n15] | 0x3000;
                        if (stereoMolecule.getAtomMapNo(nArray6[n7]) == 0) continue;
                        return 12;
                    }
                    continue;
                }
                if (this.mH[n9][i] == 1) continue;
                n13 = 0;
                for (n7 = this.mRxn.getReactants(); n7 < this.mRxn.getMolecules(); ++n7) {
                    StereoMolecule stereoMolecule3 = this.mRxn.getMolecule(n7);
                    for (int j = 0; j < stereoMolecule3.getAtoms(); ++j) {
                        if (n7 == n9 && j == i || stereoMolecule3.getAtomMapNo(j) != stereoMolecule.getAtomMapNo(i)) continue;
                        n13 = 1;
                        for (n5 = 0; n5 < 6; ++n5) {
                            if (this.mConnType[n9][i][n5] == this.mConnType[n7][j][n5]) continue;
                            n13 = 0;
                        }
                        if (n13 != 0) break;
                    }
                    if (n13 != 0) break;
                }
                if (n13 != 0) continue;
                return 6;
            }
        }
        for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
            int n16;
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            for (n16 = 0; n16 < stereoMolecule.getBonds(); ++n16) {
                block42: for (int i = 0; i < 2; ++i) {
                    int n17;
                    int n18;
                    int n19 = stereoMolecule.getBondAtom(i, n16);
                    n7 = stereoMolecule.getBondAtom(1 - i, n16);
                    block43: for (n18 = 0; n18 < stereoMolecule.getBondOrder(n16); ++n18) {
                        for (n17 = 0; n17 < 6; ++n17) {
                            if (stereoMolecule.getAtomMapNo(n7) <= this.mConnMpNo[n9][n19][n17]) continue;
                            if (this.mConnMpNo[n9][n19][n17] != 0) {
                                for (n5 = 5; n5 > n17; --n5) {
                                    this.mConnMpNo[n9][n19][n5] = this.mConnMpNo[n9][n19][n5 - 1];
                                }
                            }
                            this.mConnMpNo[n9][n19][n17] = stereoMolecule.getAtomMapNo(n7);
                            continue block43;
                        }
                    }
                    if (this.mAtomType[n9][n7] == 1) {
                        for (n18 = 0; n18 < 6; ++n18) {
                            if (stereoMolecule.getAtomMapNo(n7) <= this.mConnCMNo[n9][n19][n18]) continue;
                            if (this.mConnCMNo[n9][n19][n18] != 0) {
                                for (n17 = 5; n17 > n18; --n17) {
                                    this.mConnCMNo[n9][n19][n17] = this.mConnCMNo[n9][n19][n17 - 1];
                                }
                            }
                            this.mConnCMNo[n9][n19][n18] = stereoMolecule.getAtomMapNo(n7);
                            break;
                        }
                    }
                    switch (3 & this.mAtomType[n9][n7]) {
                        case 1: {
                            int[] nArray11 = this.mSigma[n9];
                            int n20 = n19;
                            nArray11[n20] = nArray11[n20] + 1;
                            int[] nArray12 = this.mPi[n9];
                            int n21 = n19;
                            nArray12[n21] = nArray12[n21] + (stereoMolecule.getBondOrder(n16) - 1);
                            continue block42;
                        }
                        case 2: {
                            int[] nArray13 = this.mZ[n9];
                            int n22 = n19;
                            nArray13[n22] = nArray13[n22] + stereoMolecule.getBondOrder(n16);
                        }
                    }
                }
            }
            for (n16 = 0; n16 < stereoMolecule.getAtoms(); ++n16) {
                if (this.mAtomType[n9][n16] != 1) continue;
                if (stereoMolecule.getAtomCharge(n16) == 1) {
                    int[] nArray14 = this.mZ[n9];
                    int n23 = n16;
                    nArray14[n23] = nArray14[n23] + 1;
                }
                this.mH[n9][n16] = 4 - this.mSigma[n9][n16] - this.mPi[n9][n16] - this.mZ[n9][n16];
                if (this.mH[n9][n16] >= 0) continue;
                return 13;
            }
        }
        for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            block50: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                    int n24;
                    if (stereoMolecule.getConnBondOrder(i, j) == 1 || (this.mAtomType[n9][n24 = stereoMolecule.getConnAtom(i, j)] & 3) != 2) continue;
                    int[] nArray15 = this.mAtomFlags[n9];
                    int n25 = i;
                    nArray15[n25] = nArray15[n25] | 0x4000;
                    continue block50;
                }
            }
        }
        for (n9 = 0; n9 < this.mRxn.getReactants(); ++n9) {
            int n26;
            int n27;
            int n28;
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
            int n29 = 0;
            for (n28 = 0; n28 < stereoMolecule.getAtoms(); ++n28) {
                if (this.mCorAtom[n9][n28] == 255) {
                    int[] nArray16 = this.mAtomFlags[n9];
                    int n30 = n28;
                    nArray16[n30] = nArray16[n30] | 0x3000;
                    continue;
                }
                n27 = this.mCorProd[n9][n28];
                n7 = this.mCorAtom[n9][n28];
                if (this.gErrout != null) {
                    try {
                        int n31;
                        this.gErrout.write("EduAtom: " + n28 + " conntype:");
                        for (n31 = 0; n31 < 4; ++n31) {
                            this.gErrout.write(this.mConnType[n9][n28][n31]);
                        }
                        this.gErrout.newLine();
                        this.gErrout.write("ProAtom: " + n28 + " conntype:");
                        for (n31 = 0; n31 < 4; ++n31) {
                            this.gErrout.write(this.mConnType[n27][n7][n31]);
                        }
                        this.gErrout.newLine();
                        this.gErrout.write("EduAtom: " + n28 + " connmpno:");
                        for (n31 = 0; n31 < 4; ++n31) {
                            this.gErrout.write(this.mConnMpNo[n9][n28][n31]);
                        }
                        this.gErrout.newLine();
                        this.gErrout.write("ProAtom: " + n28 + " connmpno:");
                        for (n31 = 0; n31 < 4; ++n31) {
                            this.gErrout.write(this.mConnMpNo[n27][n7][n31]);
                        }
                        this.gErrout.newLine();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                boolean bl = false;
                for (n26 = 0; n26 < 6; ++n26) {
                    if (this.mConnType[n9][n28][n26] == this.mConnType[n27][n7][n26]) continue;
                    bl = true;
                }
                for (n26 = 0; n26 < 6; ++n26) {
                    if (this.mConnMpNo[n9][n28][n26] == this.mConnMpNo[n27][n7][n26]) continue;
                    bl = true;
                }
                if (!bl || !bl && this.mZ[n9][n28] == this.mZ[n27][n7]) continue;
                n26 = 36864 + (this.mPi[n9][n28] != this.mPi[n27][n7] ? 256 : 0) + (this.mZ[n9][n28] != this.mZ[n27][n7] ? 512 : 0) + (this.mSigma[n9][n28] != this.mSigma[n27][n7] ? 1024 : 0);
                int[] nArray17 = this.mAtomFlags[n9];
                int n32 = n28;
                nArray17[n32] = nArray17[n32] | n26;
                int[] nArray18 = this.mAtomFlags[n27];
                int n33 = n7;
                nArray18[n33] = nArray18[n33] | n26;
                ++n29;
            }
            if (n29 <= 5) continue;
            for (n28 = 0; n28 < stereoMolecule.getAtoms(); ++n28) {
                if (!stereoMolecule.isAromaticAtom(n28) || (this.mAtomFlags[n9][n28] & 0x1000) == 0 || (this.mAtomFlags[n9][n28] & 0x2400) != 0) continue;
                n27 = this.mCorProd[n9][n28];
                n7 = this.mCorAtom[n9][n28];
                StereoMolecule stereoMolecule4 = this.mRxn.getMolecule(n27);
                if (!stereoMolecule4.isAromaticAtom(n7)) continue;
                n26 = 0;
                for (n5 = 0; n5 < 6; ++n5) {
                    if (this.mConnCMNo[n9][n28][n5] == this.mConnCMNo[n27][n7][n5]) continue;
                    n26 = 1;
                }
                if (n26 != 0 || this.mPi[n9][n28] + this.mZ[n9][n28] != this.mPi[n27][n7] + this.mZ[n27][n7]) continue;
                n26 = 0;
                for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n28); ++n5) {
                    n4 = stereoMolecule.getConnAtom(n28, n5);
                    n3 = this.mCorAtom[n9][n4];
                    if (n3 == 255 || stereoMolecule.isAromaticAtom(n4) && this.mRxn.getMolecule(this.mCorProd[n9][n4]).isAromaticAtom(n3)) continue;
                    for (n2 = 0; n2 < stereoMolecule4.getConnAtoms(n7); ++n2) {
                        if (n3 != stereoMolecule4.getConnAtom(n7, n2) || stereoMolecule.getBondOrder(stereoMolecule.getConnBond(n28, n5)) == stereoMolecule4.getBondOrder(stereoMolecule4.getConnBond(n7, n2))) continue;
                        n26 = 1;
                        break;
                    }
                    if (n26 != 0) break;
                }
                if (n26 != 0) continue;
                n5 = 38656;
                int[] nArray19 = this.mAtomFlags[n9];
                int n34 = n28;
                nArray19[n34] = nArray19[n34] & ~n5;
                int[] nArray20 = this.mAtomFlags[n27];
                int n35 = n7;
                nArray20[n35] = nArray20[n35] & ~n5;
            }
        }
        if (this.gErrout != null) {
            for (n9 = 0; n9 < this.mRxn.getMolecules(); ++n9) {
                try {
                    this.gErrout.newLine();
                    this.gErrout.write("***** mol: " + n9 + " *****");
                    this.gErrout.newLine();
                    this.gErrout.write("!!!! atm  a# pro  m# cha sig  pi   h   z cAt cPr typ !!!!");
                    this.gErrout.newLine();
                    StereoMolecule stereoMolecule = this.mRxn.getMolecule(n9);
                    for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                        this.gErrout.write(String.format("\t%4hd%4hd%4hd%4hd%4hd%4hd%4hd%4hd%4hd%4hd%4hd%4hd", i, stereoMolecule.getAtomicNo(i), stereoMolecule.getAtomCharge(i), stereoMolecule.getAtomMapNo(i), this.mAtomFlags[n9][i], this.mSigma[n9][i], this.mPi[n9][i], this.mH[n9][i], this.mZ[n9][i], this.mCorAtom[n9][i], this.mCorProd[n9][i], this.mAtomType[n9][i]));
                        this.gErrout.newLine();
                    }
                    this.gErrout.write("!!!! atm  a# +/-  m# cha sig  pi   h   z cAt cPr typ !!!!");
                    this.gErrout.newLine();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        n9 = 0;
        int n36 = 0;
        for (int i = 0; i < this.mRxn.getReactants(); ++i) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(i);
            for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                if ((this.mAtomFlags[i][j] & 0x1000) == 0 || (this.mAtomFlags[i][j] & 0x2000) != 0 || this.mAtomType[i][j] != 1) continue;
                n7 = this.mCorProd[i][j];
                int n37 = this.mCorAtom[i][j];
                int n38 = 0;
                for (n5 = 0; n5 < 6; ++n5) {
                    if (this.mConnCMNo[n7][n37][n5] == 0) continue;
                    ++n38;
                }
                for (n5 = 0; n5 < 6; ++n5) {
                    if (this.mConnCMNo[i][j][n5] == 0) continue;
                    --n38;
                }
                if (n38 != this.mSigma[n7][n37] - this.mSigma[i][j]) {
                    return 14;
                }
                for (n5 = 0; n5 < 6; ++n5) {
                    if (this.mConnCMNo[i][j][n5] == 0) continue;
                    n4 = 0;
                    for (n3 = 0; n3 < 6; ++n3) {
                        if (this.mConnCMNo[i][j][n5] != this.mConnCMNo[n7][n37][n3]) continue;
                        n4 = 1;
                        break;
                    }
                    if (n4 != 0) continue;
                    n3 = -1;
                    for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                        if (stereoMolecule.getAtomMapNo(n2) != this.mConnCMNo[i][j][n5]) continue;
                        n3 = n2;
                        break;
                    }
                    if (n3 <= j) continue;
                    if (n36 == 4) {
                        return 15;
                    }
                    nArray4[n36] = i;
                    nArray5[n36] = j;
                    nArray4[++n36] = i;
                    nArray5[n36] = n3;
                    ++n36;
                }
                for (n5 = 0; n5 < 6; ++n5) {
                    if (this.mConnCMNo[n7][n37][n5] == 0) continue;
                    n4 = 0;
                    for (n3 = 0; n3 < 6; ++n3) {
                        if (this.mConnCMNo[n7][n37][n5] != this.mConnCMNo[i][j][n3]) continue;
                        n4 = 1;
                        break;
                    }
                    if (n4 != 0) continue;
                    n3 = -1;
                    n2 = -1;
                    block75: for (int k = i; k < this.mRxn.getMolecules(); ++k) {
                        if (k >= this.mRxn.getReactants()) continue;
                        StereoMolecule stereoMolecule5 = this.mRxn.getMolecule(k);
                        for (int i2 = 0; i2 < stereoMolecule5.getAtoms(); ++i2) {
                            if (stereoMolecule5.getAtomMapNo(i2) != this.mConnCMNo[n7][n37][n5]) continue;
                            n3 = k;
                            n2 = i2;
                            continue block75;
                        }
                    }
                    if (n3 <= i && (n3 != i || n2 <= j)) continue;
                    if (n9 == 4) {
                        return 16;
                    }
                    nArray2[n9] = i;
                    nArray3[n9] = j;
                    nArray2[++n9] = n3;
                    nArray3[n9] = n2;
                    ++n9;
                }
            }
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write("Form:" + n9 + ", Clv:" + n36 + "; ccBFmols:" + nArray2[0] + "," + nArray2[1] + "; ccBFatms:" + nArray3[0] + "," + nArray3[0]);
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (n9 == 2 && n36 == 0) {
            int n39 = this.snglCnst(nArray2, nArray3);
            if (n39 != 0) {
                return n39;
            }
        } else if (n9 == 4 && n36 == 0) {
            int n40 = this.dblCnst(nArray2, nArray3);
            if (n40 != 0) {
                return n40;
            }
        } else if (n9 == 0 && n36 == 2) {
            int n41 = this.snglFrgm(nArray4, nArray5);
            if (n41 != 0) {
                return n41;
            }
        } else if (n9 == 0 && n36 == 4) {
            int n42 = this.dblFrgm(nArray4, nArray5);
            if (n42 != 0) {
                return n42;
            }
        } else if (n9 == 2 && n36 == 2) {
            int n43 = this.rearrang(nArray2, nArray3, nArray4, nArray5);
            if (n43 != 0) {
                return n43;
            }
        } else if (n9 != 0 || n36 != 0) {
            if (this.gErrout != null) {
                try {
                    this.gErrout.write("Form:" + n9 + ", Clv:" + n36);
                    this.gErrout.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mResult.mClassName = "not classified";
            return 17;
        }
        if ((n = this.refuncs()) != 0) {
            return n;
        }
        if (this.mUnitRxn == 0 && this.mIndexToCreate != 2) {
            return 18;
        }
        this.mResult.mUnitRxns = this.mUnitRxn;
        this.findClassNam();
        this.markReactionCenters();
        return 0;
    }

    private int snglCnst(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        int[][] nArray4 = new int[2][8];
        for (int i = 0; i < 2; ++i) {
            nArray4[i][0] = nArray[i];
            nArray4[i][1] = nArray2[i];
            nArray3[i] = this.findStrand(nArray4[i]);
            if (this.gErrout != null) {
                try {
                    this.gErrout.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (nArray3[i] >= 1) continue;
            return 19;
        }
        return this.oneConst(nArray4[0], nArray4[1], nArray3[0], nArray3[1]);
    }

    private int oneConst(int[] nArray, int[] nArray2, int n, int n2) {
        int[] nArray3 = new int[3];
        if (nArray[0] == nArray2[0] && nArray[1] == nArray2[n2]) {
            return this.ringClosure(nArray, nArray2, n, n2);
        }
        int n3 = this.bndSpcDat(nArray, nArray2, 2, nArray3, 0);
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.getDelta(nArray, n, 7);
        n3 = this.clssfyHR(nArray3, 1, n4, nArray, n, true, 6);
        if (n3 != 0) {
            return n3;
        }
        n4 = this.getDelta(nArray2, n2, 7);
        n3 = this.clssfyHR(nArray3, 2, n4, nArray2, n2, true, 7);
        if (n3 != 0) {
            return n3;
        }
        this.mResult.mMainClass[this.mUnitRxn] = 0;
        if (this.mIndexToCreate != 0) {
            DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
            this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
            this.putindexbits(32, 5, nArray3[0]);
            this.putindexbits(32, 25, nArray3[1]);
            this.putindexbits(108, 25, nArray3[2]);
            if (this.mIndexToCreate == 2) {
                this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 25, nArray3[2]);
                this.putindexbits(108, 25, nArray3[1]);
            }
        }
        ++this.mUnitRxn;
        return 0;
    }

    private int ringClosure(int[] nArray, int[] nArray2, int n, int n2) {
        int[] nArray3 = new int[4];
        int n3 = this.bndSpcDat(nArray, nArray2, 2, nArray3, 0);
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.getDelta(nArray, n, 7);
        int n5 = this.getDelta(nArray2, n2, 7);
        if (n5 > n4) {
            n4 = n5;
        }
        if ((n3 = this.clssfyCR(nArray3, 1, n4, nArray, n, true)) != 0) {
            return n3;
        }
        nArray3[2] = this.properties(nArray[0], nArray[1]);
        nArray3[3] = this.properties(nArray2[0], nArray2[1]);
        this.mResult.mFlashMol[this.mUnitRxn][6] = nArray[0];
        this.mResult.mFlashAtom[this.mUnitRxn][6] = nArray[1];
        this.mResult.mFlashMol[this.mUnitRxn][7] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][7] = nArray2[1];
        this.mResult.mMainClass[this.mUnitRxn] = 11;
        if (this.mIndexToCreate != 0) {
            DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
            this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
            this.putindexbits(32, 5, nArray3[0]);
            this.putindexbits(32, 4, nArray3[1]);
            this.putindexbits(32, 11, nArray3[2]);
            this.putindexbits(108, 11, nArray3[3]);
            if (this.mIndexToCreate == 2) {
                this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 4, nArray3[1]);
                this.putindexbits(32, 11, nArray3[3]);
                this.putindexbits(108, 11, nArray3[2]);
            }
        }
        ++this.mUnitRxn;
        return 0;
    }

    private int getDelta(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray[0];
        for (int i = 1; i <= n2; ++i) {
            n4 <<= 4;
            n3 <<= 4;
            if (i > n) continue;
            int n6 = this.mZ[n5][nArray[i]];
            int n7 = this.mZ[this.mCorProd[n5][nArray[i]]][this.mCorAtom[n5][nArray[i]]];
            if (n6 == 4 || n7 == 4) {
                --n6;
                --n7;
            }
            n4 += (n6 << 2) + this.mPi[n5][nArray[i]];
            n3 += (n7 << 2) + this.mPi[this.mCorProd[n5][nArray[i]]][this.mCorAtom[n5][nArray[i]]];
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write(String.format("eduLst:%8x, proLst:%8x, deltaLst:%8x\n", n4, n3, n4 - n3));
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n4 - n3;
    }

    private int dblCnst(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[6];
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[2];
        int[][] nArray6 = new int[4][8];
        for (n = 0; n < 4; ++n) {
            nArray6[n][0] = nArray[n];
            nArray6[n][1] = nArray2[n];
            nArray4[n] = this.findStrand(nArray6[n]);
            if (this.gErrout != null) {
                try {
                    this.gErrout.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (nArray4[n] >= 1) continue;
            return 19;
        }
        for (n = 0; n < 2; ++n) {
            nArray5[n] = (nArray6[n][0] == nArray6[2][0] && nArray6[n][1] == nArray6[2][nArray4[2]] ? 2 : 0) + (nArray6[n][0] == nArray6[3][0] && nArray6[n][1] == nArray6[3][nArray4[3]] ? 3 : 0);
        }
        if (nArray5[0] == 0 && nArray5[1] == 0) {
            n = this.oneConst(nArray6[0], nArray6[1], nArray4[0], nArray4[1]);
            if (n != 0) {
                return n;
            }
            return this.oneConst(nArray6[2], nArray6[3], nArray4[2], nArray4[3]);
        }
        if (nArray5[0] == 0 || nArray5[1] == 0) {
            int n2;
            int n3;
            int n4;
            if (nArray5[0] == 0) {
                n4 = 0;
                n3 = nArray5[1] == 2 ? 3 : 2;
                n2 = 1;
            } else {
                n4 = 1;
                n3 = nArray5[0] == 2 ? 3 : 2;
                n2 = 0;
            }
            if (nArray6[n4][0] == nArray6[n2][0] && nArray6[n4][1] == nArray6[n2][nArray4[n2]]) {
                return 20;
            }
            if (nArray6[n3][0] == nArray6[5 - n3][0] && nArray6[n3][1] == nArray6[5 - n3][nArray4[5 - n3]]) {
                return 20;
            }
            n = this.bndSpcDat(nArray6[n4], nArray6[n2], 0, nArray3, 0);
            if (n != 0) {
                return n;
            }
            n = this.bndSpcDat(nArray6[n3], nArray6[5 - n3], 2, nArray3, 1);
            if (n != 0) {
                return n;
            }
            int n5 = this.getDelta(nArray6[n2], nArray4[n2], nArray4[n2]);
            int n6 = this.getDelta(nArray6[5 - n3], nArray4[5 - n3], nArray4[5 - n3]);
            if (n6 > n5) {
                n5 = n6;
                n2 = 5 - n3;
            }
            if ((n = this.clssfyDR(nArray3, 2, n5, true, nArray6[n2], nArray4[n2], 4)) != 0) {
                return n;
            }
            n5 = this.getDelta(nArray6[n4], nArray4[n4], 7);
            n = this.clssfyHR(nArray3, 4, n5, nArray6[n4], nArray4[n4], true, 6);
            if (n != 0) {
                return n;
            }
            n5 = this.getDelta(nArray6[n3], nArray4[n3], 7);
            n = this.clssfyHR(nArray3, 5, n5, nArray6[n3], nArray4[n3], true, 7);
            if (n != 0) {
                return n;
            }
            this.mResult.mMainClass[this.mUnitRxn] = 1;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 5, nArray3[1]);
                this.putindexbits(32, 11, nArray3[2]);
                this.putindexbits(32, 25, nArray3[4]);
                this.putindexbits(108, 25, nArray3[5]);
                if (this.mIndexToCreate == 2) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[3]);
                    this.putindexbits(32, 25, nArray3[5]);
                    this.putindexbits(108, 25, nArray3[4]);
                }
            }
            ++this.mUnitRxn;
            for (int i = 1; i <= nArray4[n2]; ++i) {
                int[] nArray7 = this.mAtomFlags[nArray6[n2][0]];
                int n7 = nArray6[n2][i];
                nArray7[n7] = nArray7[n7] & 0xFFFF7FFF;
            }
        } else {
            if (nArray6[0][0] == nArray6[1][0] && nArray6[0][1] == nArray6[1][nArray4[1]]) {
                return 20;
            }
            if (nArray6[2][0] == nArray6[3][0] && nArray6[2][1] == nArray6[3][nArray4[3]]) {
                return 20;
            }
            n = this.bndSpcDat(nArray6[0], nArray6[1], 0, nArray3, 0);
            if (n != 0) {
                return n;
            }
            n = this.bndSpcDat(nArray6[2], nArray6[3], 2, nArray3, 1);
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < 2; ++i) {
                int n8;
                int n9 = this.getDelta(nArray6[i], nArray4[i], nArray4[i]);
                int n10 = this.getDelta(nArray6[nArray5[i]], nArray4[nArray5[i]], nArray4[nArray5[i]]);
                if (n10 > n9) {
                    n9 = n10;
                    n8 = nArray5[i];
                } else {
                    n8 = i;
                }
                n = this.clssfyDR(nArray3, 2 + 2 * i, n9, true, nArray6[n8], nArray4[n8], i * 2 + 4);
                if (n != 0) {
                    return n;
                }
                for (int j = 1; j <= nArray4[i]; ++j) {
                    int[] nArray8 = this.mAtomFlags[nArray6[i][0]];
                    int n11 = nArray6[i][j];
                    nArray8[n11] = nArray8[n11] & 0xFFFF7FFF;
                }
            }
            this.mResult.mMainClass[this.mUnitRxn] = 2;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 5, nArray3[1]);
                this.putindexbits(32, 11, nArray3[2]);
                this.putindexbits(108, 11, nArray3[4]);
                if (this.mIndexToCreate == 2) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 11, nArray3[4]);
                    this.putindexbits(108, 11, nArray3[2]);
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[3]);
                    this.putindexbits(108, 11, nArray3[5]);
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[5]);
                    this.putindexbits(108, 11, nArray3[3]);
                }
            }
            ++this.mUnitRxn;
        }
        return 0;
    }

    private int snglFrgm(int[] nArray, int[] nArray2) {
        int[][] nArray3 = new int[2][8];
        int[] nArray4 = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray3[i][0] = nArray[i];
            nArray3[i][1] = nArray2[i];
            nArray4[i] = this.findStrand(nArray3[i]);
            if (this.gErrout != null) {
                try {
                    this.gErrout.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (nArray4[i] >= 1) continue;
            return 19;
        }
        return this.oneFrgm(nArray3[0], nArray3[1], nArray4[0], nArray4[1]);
    }

    private int oneFrgm(int[] nArray, int[] nArray2, int n, int n2) {
        int[] nArray3 = new int[3];
        if (nArray[0] == nArray2[0] && nArray[1] == nArray2[n2]) {
            return this.ringOpening(nArray, nArray2, n, n2);
        }
        int n3 = this.bndSpcDat(nArray, nArray2, 2, nArray3, 0);
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.getDelta(nArray, n, 7);
        n3 = this.clssfyHR(nArray3, 1, -n4, nArray, n, false, 6);
        if (n3 != 0) {
            return n3;
        }
        n4 = this.getDelta(nArray2, n2, 7);
        n3 = this.clssfyHR(nArray3, 2, -n4, nArray2, n2, false, 7);
        if (n3 != 0) {
            return n3;
        }
        this.mResult.mMainClass[this.mUnitRxn] = 5;
        if (this.mIndexToCreate != 0) {
            DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
            this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
            this.putindexbits(32, 5, nArray3[0]);
            this.putindexbits(32, 25, nArray3[1]);
            this.putindexbits(108, 25, nArray3[2]);
            if (this.mIndexToCreate == 2) {
                this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 25, nArray3[2]);
                this.putindexbits(108, 25, nArray3[1]);
            }
        }
        ++this.mUnitRxn;
        return 0;
    }

    private int ringOpening(int[] nArray, int[] nArray2, int n, int n2) {
        int[] nArray3 = new int[4];
        int n3 = this.bndSpcDat(nArray, nArray2, 2, nArray3, 0);
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.getDelta(nArray, n, 7);
        int n5 = this.getDelta(nArray2, n2, 7);
        if (n5 < n4) {
            n4 = n5;
        }
        if ((n3 = this.clssfyCR(nArray3, 1, -n4, nArray, n, false)) != 0) {
            return n3;
        }
        nArray3[2] = this.properties(nArray[0], nArray[1]);
        nArray3[3] = this.properties(nArray2[0], nArray2[1]);
        this.mResult.mFlashMol[this.mUnitRxn][6] = nArray[0];
        this.mResult.mFlashAtom[this.mUnitRxn][6] = nArray[1];
        this.mResult.mFlashMol[this.mUnitRxn][7] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][7] = nArray2[1];
        this.mResult.mMainClass[this.mUnitRxn] = 12;
        if (this.mIndexToCreate != 0) {
            DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
            this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
            this.putindexbits(32, 5, nArray3[0]);
            this.putindexbits(32, 4, nArray3[1]);
            this.putindexbits(32, 11, nArray3[2]);
            this.putindexbits(108, 11, nArray3[3]);
            if (this.mIndexToCreate == 2) {
                this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 4, nArray3[1]);
                this.putindexbits(32, 11, nArray3[3]);
                this.putindexbits(108, 11, nArray3[2]);
            }
        }
        ++this.mUnitRxn;
        return 0;
    }

    private int dblFrgm(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[6];
        int[] nArray4 = new int[4];
        int[] nArray5 = new int[2];
        int[][] nArray6 = new int[4][8];
        for (n = 0; n < 4; ++n) {
            nArray6[n][0] = nArray[n];
            nArray6[n][1] = nArray2[n];
            nArray4[n] = this.findStrand(nArray6[n]);
            if (this.gErrout != null) {
                try {
                    this.gErrout.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (nArray4[n] >= 1) continue;
            return 19;
        }
        for (n = 0; n < 2; ++n) {
            nArray5[n] = (nArray6[n][0] == nArray6[2][0] && nArray6[n][1] == nArray6[2][nArray4[2]] ? 2 : 0) + (nArray6[n][0] == nArray6[3][0] && nArray6[n][1] == nArray6[3][nArray4[3]] ? 3 : 0);
        }
        if (nArray5[0] == 0 && nArray5[1] == 0) {
            n = this.oneFrgm(nArray6[0], nArray6[1], nArray4[0], nArray4[1]);
            if (n != 0) {
                return n;
            }
            return this.oneFrgm(nArray6[2], nArray6[3], nArray4[2], nArray4[3]);
        }
        if (nArray5[0] == 0 || nArray5[1] == 0) {
            int n2;
            int n3;
            int n4;
            if (nArray5[0] == 0) {
                n4 = 0;
                n3 = nArray5[1] == 2 ? 3 : 2;
                n2 = 1;
            } else {
                n4 = 1;
                n3 = nArray5[0] == 2 ? 3 : 2;
                n2 = 0;
            }
            if (nArray6[n4][0] == nArray6[n2][0] && nArray6[n4][1] == nArray6[n2][nArray4[n2]]) {
                return 20;
            }
            if (nArray6[n3][0] == nArray6[5 - n3][0] && nArray6[n3][1] == nArray6[5 - n3][nArray4[5 - n3]]) {
                return 20;
            }
            n = this.bndSpcDat(nArray6[n4], nArray6[n2], 0, nArray3, 0);
            if (n != 0) {
                return n;
            }
            n = this.bndSpcDat(nArray6[n3], nArray6[5 - n3], 2, nArray3, 1);
            if (n != 0) {
                return n;
            }
            int n5 = this.getDelta(nArray6[n2], nArray4[n2], nArray4[n2]);
            int n6 = this.getDelta(nArray6[5 - n3], nArray4[5 - n3], nArray4[5 - n3]);
            if (n6 < n5) {
                n5 = n6;
                n2 = 5 - n3;
            }
            if ((n = this.clssfyDR(nArray3, 2, -n5, false, nArray6[n2], nArray4[n2], 4)) != 0) {
                return n;
            }
            n5 = this.getDelta(nArray6[n4], nArray4[n4], 7);
            n = this.clssfyHR(nArray3, 4, -n5, nArray6[n4], nArray4[n4], false, 6);
            if (n != 0) {
                return n;
            }
            n5 = this.getDelta(nArray6[n3], nArray4[n3], 7);
            n = this.clssfyHR(nArray3, 5, -n5, nArray6[n3], nArray4[n3], false, 7);
            if (n != 0) {
                return n;
            }
            this.mResult.mMainClass[this.mUnitRxn] = 9;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 5, nArray3[1]);
                this.putindexbits(32, 11, nArray3[2]);
                this.putindexbits(32, 25, nArray3[4]);
                this.putindexbits(108, 25, nArray3[5]);
                if (this.mIndexToCreate == 2) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[3]);
                    this.putindexbits(32, 25, nArray3[5]);
                    this.putindexbits(108, 25, nArray3[4]);
                }
            }
            ++this.mUnitRxn;
            for (int i = 1; i <= nArray4[n2]; ++i) {
                int[] nArray7 = this.mAtomFlags[nArray6[n2][0]];
                int n7 = nArray6[n2][i];
                nArray7[n7] = nArray7[n7] & 0xFFFF7FFF;
            }
        } else {
            if (nArray6[0][0] == nArray6[1][0] && nArray6[0][1] == nArray6[1][nArray4[1]]) {
                return 20;
            }
            if (nArray6[2][0] == nArray6[3][0] && nArray6[2][1] == nArray6[3][nArray4[3]]) {
                return 20;
            }
            n = this.bndSpcDat(nArray6[0], nArray6[1], 0, nArray3, 0);
            if (n != 0) {
                return n;
            }
            n = this.bndSpcDat(nArray6[2], nArray6[3], 2, nArray3, 1);
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < 2; ++i) {
                int n8;
                int n9 = this.getDelta(nArray6[i], nArray4[i], nArray4[i]);
                int n10 = this.getDelta(nArray6[nArray5[i]], nArray4[nArray5[i]], nArray4[nArray5[i]]);
                if (n10 < n9) {
                    n9 = n10;
                    n8 = nArray5[i];
                } else {
                    n8 = i;
                }
                n = this.clssfyDR(nArray3, 2 + 2 * i, -n9, false, nArray6[n8], nArray4[n8], i * 2 + 4);
                if (n != 0) {
                    return n;
                }
                for (int j = 1; j <= nArray4[i]; ++j) {
                    int[] nArray8 = this.mAtomFlags[nArray6[i][0]];
                    int n11 = nArray6[i][j];
                    nArray8[n11] = nArray8[n11] & 0xFFFF7FFF;
                }
            }
            this.mResult.mMainClass[this.mUnitRxn] = 10;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray3[0]);
                this.putindexbits(32, 5, nArray3[1]);
                this.putindexbits(32, 11, nArray3[2]);
                this.putindexbits(108, 11, nArray3[4]);
                if (this.mIndexToCreate == 2) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 11, nArray3[4]);
                    this.putindexbits(108, 11, nArray3[2]);
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[3]);
                    this.putindexbits(108, 11, nArray3[5]);
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray3[1]);
                    this.putindexbits(32, 5, nArray3[0]);
                    this.putindexbits(32, 11, nArray3[5]);
                    this.putindexbits(108, 11, nArray3[3]);
                }
            }
            ++this.mUnitRxn;
        }
        return 0;
    }

    private int rearrang(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        int n2;
        int n3;
        int[] nArray5 = new int[4];
        int[] nArray6 = new int[5];
        int[] nArray7 = new int[2];
        int[][] nArray8 = new int[4][8];
        for (n3 = 0; n3 < 2; ++n3) {
            nArray8[n3][0] = nArray[n3];
            nArray8[n3][1] = nArray2[n3];
            nArray5[n3] = this.findStrand(nArray8[n3]);
            if (nArray5[n3] < 1) {
                return 19;
            }
            n2 = nArray8[n3][nArray5[n3]];
            for (n = 0; n < 2; ++n) {
                if (n2 != nArray4[n] || nArray[n3] != nArray3[n]) continue;
                nArray7[n3] = n + 2;
            }
        }
        for (n3 = 0; n3 < 2; ++n3) {
            nArray8[n3 + 2][0] = nArray3[n3];
            nArray8[n3 + 2][1] = nArray4[n3];
            nArray5[n3 + 2] = this.findStrand(nArray8[n3 + 2]);
            if (nArray5[n3 + 2] >= 1) continue;
            return 19;
        }
        if (nArray7[0] == 0 && nArray7[1] == 0) {
            n3 = this.oneConst(nArray8[0], nArray8[1], nArray5[0], nArray5[1]);
            if (n3 != 0) {
                return n3;
            }
            return this.oneFrgm(nArray8[2], nArray8[3], nArray5[2], nArray5[3]);
        }
        if (nArray7[0] == 0 || nArray7[1] == 0) {
            if (nArray7[0] == 0) {
                n3 = 0;
                n2 = nArray7[1] == 2 ? 3 : 2;
                n = 1;
            } else {
                n3 = 1;
                n2 = nArray7[0] == 2 ? 3 : 2;
                n = 0;
            }
            this.mResult.mRearStrandLen[0] = nArray5[n];
            int n4 = this.bndSpcDat(nArray8[n3], nArray8[n], 0, nArray6, 0);
            if (n4 != 0) {
                return n4;
            }
            n4 = this.bndSpcDat(nArray8[n2], nArray8[5 - n2], 2, nArray6, 1);
            if (n4 != 0) {
                return n4;
            }
            int n5 = this.getDelta(nArray8[n], nArray5[n], 7);
            n4 = this.clssfyRA(nArray6, 2, n5, nArray8[n], nArray5[n], 4);
            if (n4 != 0) {
                return n4;
            }
            n5 = this.getDelta(nArray8[n3], nArray5[n3], 7);
            n4 = this.clssfyHR(nArray6, 3, n5, nArray8[n3], nArray5[n3], true, 6);
            if (n4 != 0) {
                return n4;
            }
            n5 = this.getDelta(nArray8[n2], nArray5[n2], 7);
            n4 = this.clssfyHR(nArray6, 4, -n5, nArray8[n2], nArray5[n2], false, 7);
            if (n4 != 0) {
                return n4;
            }
            this.mResult.mMainClass[this.mUnitRxn] = 3;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray6[0]);
                this.putindexbits(32, 5, nArray6[1]);
                this.putindexbits(32, 13, nArray6[2]);
                this.putindexbits(32, 25, nArray6[3]);
                this.putindexbits(108, 25, nArray6[4]);
            }
            ++this.mUnitRxn;
            for (int i = 1; i <= nArray5[n]; ++i) {
                int[] nArray9 = this.mAtomFlags[nArray8[n][0]];
                int n6 = nArray8[n][i];
                nArray9[n6] = nArray9[n6] & 0xFFFF7FFF;
            }
        } else {
            for (n3 = 0; n3 < 2; ++n3) {
                this.mResult.mRearStrandLen[n3] = nArray5[n3];
                n2 = this.bndSpcDat(nArray8[n3 * 2], nArray8[n3 * 2 + 1], n3 * 2, nArray6, n3);
                if (n2 != 0) {
                    return n2;
                }
                n = this.getDelta(nArray8[n3], nArray5[n3], 7);
                n2 = this.clssfyRA(nArray6, 2 + n3, n, nArray8[n3], nArray5[n3], n3 * 2 + 4);
                if (n2 != 0) {
                    return n2;
                }
                for (int i = 1; i <= nArray5[n3]; ++i) {
                    int[] nArray10 = this.mAtomFlags[nArray8[n3][0]];
                    int n7 = nArray8[n3][i];
                    nArray10[n7] = nArray10[n7] & 0xFFFF7FFF;
                }
            }
            this.mResult.mMainClass[this.mUnitRxn] = 4;
            if (this.mIndexToCreate != 0) {
                DatabaseReaction databaseReaction = (DatabaseReaction)this.mRxn;
                this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                this.putindexbits(32, 5, nArray6[0]);
                this.putindexbits(32, 5, nArray6[1]);
                this.putindexbits(32, 13, nArray6[2]);
                this.putindexbits(108, 13, nArray6[3]);
                if (this.mIndexToCreate == 2) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 5, nArray6[0]);
                    this.putindexbits(32, 5, nArray6[1]);
                    this.putindexbits(32, 13, nArray6[3]);
                    this.putindexbits(108, 13, nArray6[2]);
                }
            }
            ++this.mUnitRxn;
        }
        return 0;
    }

    private int clssfyHR(int[] nArray, int n, int n2, int[] nArray2, int n3, boolean bl, int n4) {
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[4];
        this.mResult.mFlashMol[this.mUnitRxn][n4] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][n4] = nArray2[1];
        for (int i = 0; i < this.mClassificationData.getHEntries(); ++i) {
            int n5;
            StereoMolecule stereoMolecule;
            int n6;
            boolean bl2;
            int n7;
            int n8;
            int n9;
            if (n2 != this.mClassificationData.getHRxnDelta(i)) continue;
            String string = this.mResult.mUnitName[this.mUnitRxn];
            string = bl ? (string == null ? this.mClassificationData.getHConstructionName(i) : string + " " + this.mClassificationData.getHConstructionName(i)) : (string == null ? this.mClassificationData.getHFragmentationName(i) : string + " " + this.mClassificationData.getHFragmentationName(i));
            nArray[n] = i << 11;
            for (n9 = 1; n9 <= n3; ++n9) {
                int[] nArray5 = this.mAtomFlags[nArray2[0]];
                int n10 = nArray2[n9];
                nArray5[n10] = nArray5[n10] & 0xFFFF7FFF;
            }
            n9 = nArray2[0];
            int n11 = nArray2[1];
            int n12 = n;
            nArray[n12] = nArray[n12] | this.properties(n9, n11);
            int n13 = this.mCorProd[n9][n11];
            int n14 = this.mCorAtom[n9][n11];
            int n15 = nArray2[this.mClassificationData.getHRxnGroupDef(i) & 0xF];
            int n16 = this.mCorProd[n9][n15];
            int n17 = this.mCorAtom[n9][n15];
            int n18 = n;
            nArray[n18] = nArray[n18] << 8;
            int n19 = -1;
            int n20 = -1;
            int n21 = -1;
            int n22 = 0;
            int[] nArray6 = new int[1];
            if (this.mSigma[n9][n11] < this.mSigma[n13][n14] ^ (this.mClassificationData.getHRxnGroupDef(i) & 0x10) == 16) {
                n22 = this.leaving(n9, n15, n16, n17, nArray3, nArray4, nArray6);
                n19 = n9;
                n21 = n15;
                n20 = 2;
                for (n8 = 0; n8 < n22; ++n8) {
                    int[] nArray7 = this.mAtomFlags[n9];
                    int n23 = nArray4[n8];
                    nArray7[n23] = nArray7[n23] & 0xFFFF7FFF;
                    n7 = this.mRxn.getMolecule(n9).getAtomMapNo(nArray4[n8]);
                    if (n7 == 0) continue;
                    bl2 = false;
                    block5: for (n6 = this.mRxn.getReactants(); !bl2 && n6 < this.mRxn.getMolecules(); ++n6) {
                        stereoMolecule = this.mRxn.getMolecule(n6);
                        for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
                            if (stereoMolecule.getAtomMapNo(n5) != n7) continue;
                            int[] nArray8 = this.mAtomFlags[n6];
                            int n24 = n5;
                            nArray8[n24] = nArray8[n24] & 0xFFFF7FFF;
                            bl2 = true;
                            continue block5;
                        }
                    }
                }
            } else {
                n22 = this.leaving(n16, n17, n9, n15, nArray3, nArray4, nArray6);
                n19 = n16;
                n21 = n17;
                n20 = 2;
                for (n8 = 0; n8 < n22; ++n8) {
                    int[] nArray9 = this.mAtomFlags[n16];
                    int n25 = nArray4[n8];
                    nArray9[n25] = nArray9[n25] & 0xFFFF7FFF;
                    n7 = this.mRxn.getMolecule(n16).getAtomMapNo(nArray4[n8]);
                    if (n7 == 0) continue;
                    bl2 = false;
                    block8: for (n6 = 0; !bl2 && n6 < this.mRxn.getReactants(); ++n6) {
                        stereoMolecule = this.mRxn.getMolecule(n6);
                        for (n5 = 0; n5 < stereoMolecule.getAtoms(); ++n5) {
                            if (stereoMolecule.getAtomMapNo(n5) != n7) continue;
                            int[] nArray10 = this.mAtomFlags[n6];
                            int n26 = n5;
                            nArray10[n26] = nArray10[n26] & 0xFFFF7FFF;
                            bl2 = true;
                            continue block8;
                        }
                    }
                }
            }
            if (n22 != 0) {
                n20 = nArray3[0];
                n21 = nArray4[0];
                for (n8 = 1; n8 < n22; ++n8) {
                    if (nArray3[n8] <= n20) continue;
                    n20 = nArray3[n8];
                    n21 = nArray4[n8];
                }
            }
            int n27 = n;
            nArray[n27] = nArray[n27] | n20;
            this.mResult.mChngGrps[this.mUnitRxn][n4 - 6] = n20;
            this.mResult.mFlashMol[this.mUnitRxn][n4 + 2] = n19;
            this.mResult.mFlashAtom[this.mUnitRxn][n4 + 2] = n21;
            return 0;
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write(String.format("HR-deltaZP: %x", n2));
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 21;
    }

    private int clssfyCR(int[] nArray, int n, int n2, int[] nArray2, int n3, boolean bl) {
        for (int i = 0; i < this.mClassificationData.getCEntries(); ++i) {
            if (n2 != this.mClassificationData.getCRxnDelta(i)) continue;
            this.mResult.mUnitName[this.mUnitRxn] = bl ? this.mClassificationData.getCRingClosureName(i) : this.mClassificationData.getCRingOpeningName(i);
            nArray[n] = i;
            for (int j = 1; j <= n3; ++j) {
                int[] nArray3 = this.mAtomFlags[nArray2[0]];
                int n4 = nArray2[j];
                nArray3[n4] = nArray3[n4] & 0xFFFF7FFF;
            }
            return 0;
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write("CR-deltaZP: " + n2);
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 22;
    }

    private int properties(int n, int n2) {
        int n3 = this.mSigma[n][n2] << 8;
        n3 |= this.mZ[n][n2] << 5;
        n3 |= this.mPi[n][n2] << 3;
        if (this.mRxn.getMolecule(n).isAromaticAtom(n2)) {
            n3 = (int)((long)n3 | 4L);
        }
        if (this.mRxn.getMolecule(n).isStabilizedAtom(n2)) {
            n3 = (int)((long)n3 | 2L);
        }
        if (this.mRxn.getMolecule(n).isAllylicAtom(n2)) {
            n3 = (int)((long)n3 | 1L);
        }
        return n3;
    }

    private int clssfyDR(int[] nArray, int n, int n2, boolean bl, int[] nArray2, int n3, int n4) {
        this.mResult.mFlashMol[this.mUnitRxn][n4] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][n4] = nArray2[1];
        this.mResult.mFlashMol[this.mUnitRxn][n4 + 1] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][n4 + 1] = nArray2[n3];
        for (int i = 0; i < this.mClassificationData.getDEntries(); ++i) {
            if (n2 != this.mClassificationData.getDRxnDelta(i)) continue;
            if (bl) {
                if (this.mResult.mUnitName[this.mUnitRxn] == null) {
                    this.mResult.mUnitName[this.mUnitRxn] = this.mClassificationData.getDConstructionName(i);
                } else {
                    int n5 = this.mUnitRxn;
                    this.mResult.mUnitName[n5] = this.mResult.mUnitName[n5] + " " + this.mClassificationData.getDConstructionName(i);
                }
            } else if (this.mResult.mUnitName[this.mUnitRxn] == null) {
                this.mResult.mUnitName[this.mUnitRxn] = this.mClassificationData.getDFragmentationName(i);
            } else {
                int n6 = this.mUnitRxn;
                this.mResult.mUnitName[n6] = this.mResult.mUnitName[n6] + " " + this.mClassificationData.getDFragmentationName(i);
            }
            int n7 = nArray2[0];
            int n8 = nArray2[1];
            int n9 = nArray2[n3];
            nArray[n] = i;
            int n10 = this.mSigma[n7][n8];
            int n11 = this.mSigma[n7][n9];
            if (!bl) {
                --n10;
                --n11;
            }
            int n12 = n;
            nArray[n12] = nArray[n12] << 2;
            int n13 = n;
            nArray[n13] = nArray[n13] | n10;
            int n14 = n;
            nArray[n14] = nArray[n14] << 2;
            int n15 = n;
            nArray[n15] = nArray[n15] | n11;
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(n7);
            int n16 = 0;
            int n17 = 0;
            for (int j = 1; j <= n3; ++j) {
                for (int k = 0; k < stereoMolecule.getConnAtoms(nArray2[j]); ++k) {
                    int n18 = stereoMolecule.getConnAtom(nArray2[j], k);
                    if ((this.mAtomType[n7][n18] & 3) == 2) {
                        n16 = 2;
                    }
                    for (int i2 = 0; i2 < stereoMolecule.getConnAtoms(n18); ++i2) {
                        if ((this.mAtomType[n7][stereoMolecule.getConnAtom(n18, i2)] & 3) != 2 || stereoMolecule.getConnBondOrder(n18, i2) <= 1) continue;
                        n17 = 1;
                    }
                }
            }
            int n19 = n;
            nArray[n19] = nArray[n19] << 2;
            int n20 = n;
            nArray[n20] = nArray[n20] | n16 + n17;
            nArray[n + 1] = 0xFFFFFFC3 & nArray[n] | 16 * n11 + 4 * n10;
            return 0;
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write(String.format("DR-deltaZP: %x", n2));
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 23;
    }

    private int clssfyRA(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4) {
        this.mResult.mFlashMol[this.mUnitRxn][n4] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][n4] = nArray2[1];
        this.mResult.mFlashMol[this.mUnitRxn][n4 + 1] = nArray2[0];
        this.mResult.mFlashAtom[this.mUnitRxn][n4 + 1] = nArray2[n3];
        for (int i = 0; i < this.mClassificationData.getEEntries(); ++i) {
            if (n2 != this.mClassificationData.getERxnDelta(i)) continue;
            if (this.mResult.mUnitName[this.mUnitRxn] == null) {
                this.mResult.mUnitName[this.mUnitRxn] = this.mClassificationData.getERearrangementName(i);
            } else {
                int n5 = this.mUnitRxn;
                this.mResult.mUnitName[n5] = this.mResult.mUnitName[n5] + " " + this.mClassificationData.getERearrangementName(i);
            }
            int n6 = nArray2[0];
            int n7 = nArray2[1];
            int n8 = nArray2[n3];
            nArray[n] = i;
            int n9 = n;
            nArray[n9] = nArray[n9] << 2;
            int n10 = n;
            nArray[n10] = nArray[n10] | this.mSigma[n6][n7];
            int n11 = n;
            nArray[n11] = nArray[n11] << 3;
            int n12 = n;
            nArray[n12] = nArray[n12] | this.mSigma[n6][n8];
            int n13 = n;
            nArray[n13] = nArray[n13] << 2;
            int n14 = n;
            nArray[n14] = nArray[n14] | this.mZ[n6][n7];
            int n15 = n;
            nArray[n15] = nArray[n15] << 2;
            int n16 = n;
            nArray[n16] = nArray[n16] | this.mZ[n6][n8];
            return 0;
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write(String.format("RA-deltaZP: %x", n2));
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 24;
    }

    private int clssfyRE(int n) {
        int n2 = 127;
        int n3 = 64;
        int n4 = this.mClassificationData.getREntries();
        for (int i = 0; i < 8; ++i) {
            if (n2 >= n4 || n > this.mClassificationData.getRRxnDelta(n2)) {
                n2 -= n3;
                n3 >>= 1;
                continue;
            }
            if (n < this.mClassificationData.getRRxnDelta(n2)) {
                n2 += n3;
                n3 >>= 1;
                continue;
            }
            this.mResult.mUnitName[this.mUnitRxn] = this.mClassificationData.getRRefuncName(n2);
            this.mResult.mClassResult[this.mUnitRxn] = n2;
            return 0;
        }
        if (this.gErrout != null) {
            try {
                this.gErrout.write(String.format("RE-deltaZP: %x", n));
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 25;
    }

    private int bndSpcDat(int[] nArray, int[] nArray2, int n, int[] nArray3, int n2) {
        int n3;
        nArray3[n2] = 0;
        int n4 = nArray[0];
        int n5 = nArray2[0];
        int n6 = nArray[1];
        int n7 = nArray2[1];
        this.mResult.mFlashAtom[this.mUnitRxn][n] = n4;
        this.mResult.mFlashAtom[this.mUnitRxn][n] = n6;
        this.mResult.mFlashAtom[this.mUnitRxn][n + 1] = n5;
        this.mResult.mFlashAtom[this.mUnitRxn][n + 1] = n7;
        if (n4 != n5) {
            return 0;
        }
        if (this.conLngth(n4, n6, n7, false) != 0) {
            nArray3[n2] = 16;
        }
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n4);
        for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n6); ++n3) {
            int n8 = stereoMolecule.getConnBond(n6, n3);
            if (stereoMolecule.getBondAtom(0, n8) != n7 && stereoMolecule.getBondAtom(1, n8) != n7) continue;
            nArray3[n2] = 16;
            break;
        }
        if (nArray3[n2] == 0) {
            return 0;
        }
        n3 = this.conLngth(n4, n6, n7, true);
        if (n3 > 0 && n3 > 15) {
            n3 = 15;
        }
        int n9 = n2;
        nArray3[n9] = nArray3[n9] | n3;
        return 0;
    }

    private int refuncs() {
        block86: {
            DatabaseReaction databaseReaction;
            int n;
            int n2;
            int[][] nArray;
            int[][][] nArray2;
            block87: {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int[][] nArray3 = new int[8][6];
                int[][] nArray4 = new int[8][6];
                int[] nArray5 = new int[8];
                int[] nArray6 = new int[8];
                int[][] nArray7 = new int[8][6];
                int[][] nArray8 = new int[8][6];
                int[][] nArray9 = new int[8][1];
                int[][] nArray10 = new int[2][8];
                nArray2 = new int[16][8][4];
                nArray = new int[16][2];
                int[] nArray11 = new int[2];
                int[] nArray12 = new int[1];
                for (n13 = 0; n13 < this.mRxn.getReactants(); ++n13) {
                    for (n2 = 0; n2 < this.mRxn.getMolecule(n13).getAtoms(); ++n2) {
                        if ((this.mAtomFlags[n13][n2] & 0x1000) != 0 || this.mRxn.getMolecule(n13).getAtomMapNo(n2) == 0 || this.mZ[n13][n2] != this.mZ[n12 = this.mCorProd[n13][n2]][n11 = this.mCorAtom[n13][n2]]) continue;
                        if (this.leaving(n13, n2, n12, n11, nArray3[0], nArray7[0], nArray12) != 0) {
                            int[] nArray13 = this.mAtomFlags[n13];
                            int n14 = n2;
                            nArray13[n14] = nArray13[n14] | 0x9000;
                            int[] nArray14 = this.mAtomFlags[n12];
                            int n15 = n11;
                            nArray14[n15] = nArray14[n15] | 0x9000;
                            continue;
                        }
                        if (this.leaving(n12, n11, n13, n2, nArray4[0], nArray8[0], nArray12) == 0) continue;
                        int[] nArray15 = this.mAtomFlags[n13];
                        int n16 = n2;
                        nArray15[n16] = nArray15[n16] | 0x9000;
                        int[] nArray16 = this.mAtomFlags[n12];
                        int n17 = n11;
                        nArray16[n17] = nArray16[n17] | 0x9000;
                    }
                }
                n13 = 0;
                n2 = this.mUnitRxn;
                for (n12 = 0; n12 < this.mRxn.getReactants(); ++n12) {
                    int n18 = n12;
                    nArray10[1][0] = n18;
                    nArray10[0][0] = n18;
                    for (n11 = 0; n11 < this.mRxn.getMolecule(n12).getAtoms(); ++n11) {
                        if (this.mAtomType[n12][n11] != 1 || (this.mAtomFlags[n12][n11] & 0x8000) == 0) continue;
                        nArray10[0][1] = n11;
                        n10 = this.findStrand(nArray10[0]);
                        if (n10 == 0) continue;
                        if (n10 == -1) {
                            return 19;
                        }
                        nArray11[0] = this.getDelta(nArray10[0], n10, n10);
                        for (n = 1; n <= n10; ++n) {
                            nArray10[1][n] = nArray10[0][n10 - n + 1];
                        }
                        nArray11[1] = this.getDelta(nArray10[1], n10, n10);
                        n = nArray11[1] > nArray11[0] ? 1 : 0;
                        n9 = this.clssfyRE(nArray11[n]);
                        if (n9 != 0) {
                            return n9;
                        }
                        for (n8 = 1; n8 <= n10; ++n8) {
                            int[] nArray17 = this.mAtomFlags[n12];
                            int n19 = nArray10[0][n8];
                            nArray17[n19] = nArray17[n19] & 0xFFFF7FFF;
                        }
                        ++n13;
                        this.mResult.mMainClass[this.mUnitRxn] = n10 == 1 ? 6 : 7;
                        for (n8 = 1; n8 <= n10; ++n8) {
                            for (n7 = 0; n7 < 4; ++n7) {
                                nArray4[n8][n7] = 0;
                                nArray3[n8][n7] = 0;
                            }
                        }
                        for (n8 = 1; n8 <= n10; ++n8) {
                            int n20;
                            int n21;
                            int n22;
                            n7 = nArray10[n][n8];
                            n6 = this.mCorProd[n12][n7];
                            n5 = this.mCorAtom[n12][n7];
                            nArray6[n8] = this.leaving(n6, n5, n12, n7, nArray4[n8], nArray8[n8], nArray9[n8]);
                            for (n4 = 0; n4 < nArray6[n8]; ++n4) {
                                int[] nArray18 = this.mAtomFlags[n6];
                                int n23 = nArray8[n8][n4];
                                nArray18[n23] = nArray18[n23] & 0xFFFF7FFF;
                                n3 = this.mRxn.getMolecule(n6).getAtomMapNo(nArray8[n8][n4]);
                                if (n3 == 0) continue;
                                n22 = 0;
                                block12: for (n21 = 0; n22 == 0 && n21 < this.mRxn.getReactants(); ++n21) {
                                    StereoMolecule stereoMolecule = this.mRxn.getMolecule(n21);
                                    for (n20 = 0; n20 < stereoMolecule.getAtoms(); ++n20) {
                                        if (stereoMolecule.getAtomMapNo(n20) != n3) continue;
                                        int[] nArray19 = this.mAtomFlags[n21];
                                        int n24 = n20;
                                        nArray19[n24] = nArray19[n24] & 0xFFFF7FFF;
                                        n22 = 1;
                                        continue block12;
                                    }
                                }
                            }
                            n4 = 0;
                            for (n3 = 0; n3 < this.mClassificationData.getRRxnFGroups(this.mResult.mClassResult[this.mUnitRxn]); ++n3) {
                                if ((this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n3) & 0x40) == 0 || (this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n3) & 0xF) != n8) continue;
                                ++n4;
                            }
                            n3 = nArray6[n8] - n4;
                            if (n3 < 0) {
                                if (nArray11[n] == 0) {
                                    n3 = 0;
                                } else {
                                    return 26;
                                }
                            }
                            while (n3 != 0) {
                                n22 = 0;
                                block16: for (n21 = 0; n22 == 0 && n21 < nArray6[n8]; ++n21) {
                                    for (int i = n21 + 1; i < nArray6[n8]; ++i) {
                                        if (nArray4[n8][n21] != nArray4[n8][i]) continue;
                                        for (n20 = i + 1; n20 < nArray6[n8]; ++n20) {
                                            nArray4[n8][n20 - 1] = nArray4[n8][n20];
                                            nArray8[n8][n20 - 1] = nArray8[n8][n20];
                                        }
                                        int n25 = n8;
                                        nArray6[n25] = nArray6[n25] - 1;
                                        --n3;
                                        n22 = 1;
                                        continue block16;
                                    }
                                }
                                if (n22 != 0) continue;
                                n3 = 0;
                                nArray6[n8] = n4;
                            }
                            nArray5[n8] = this.leaving(n12, n7, n6, n5, nArray3[n8], nArray7[n8], nArray9[n8]);
                            for (n22 = 0; n22 < nArray5[n8]; ++n22) {
                                int[] nArray20 = this.mAtomFlags[n12];
                                int n26 = nArray7[n8][n22];
                                nArray20[n26] = nArray20[n26] & 0xFFFF7FFF;
                                n21 = this.mRxn.getMolecule(n12).getAtomMapNo(nArray7[n8][n22]);
                                if (n21 == 0) continue;
                                boolean bl = false;
                                block20: for (n20 = this.mRxn.getReactants(); !bl && n20 < this.mRxn.getMolecules(); ++n20) {
                                    StereoMolecule stereoMolecule = this.mRxn.getMolecule(n20);
                                    for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                                        if (stereoMolecule.getAtomMapNo(i) != n21) continue;
                                        int[] nArray21 = this.mAtomFlags[n20];
                                        int n27 = i;
                                        nArray21[n27] = nArray21[n27] & 0xFFFF7FFF;
                                        bl = true;
                                        continue block20;
                                    }
                                }
                            }
                            n4 = 0;
                            for (n22 = 0; n22 < this.mClassificationData.getRRxnFGroups(this.mResult.mClassResult[this.mUnitRxn]); ++n22) {
                                if ((this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n22) & 0x40) != 0 || (this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n22) & 0xF) != n8) continue;
                                ++n4;
                            }
                            n3 = nArray5[n8] - n4;
                            if (n3 < 0) {
                                if (nArray11[n] == 0) {
                                    n3 = 0;
                                } else {
                                    return 26;
                                }
                            }
                            while (n3 != 0) {
                                n22 = 0;
                                block24: for (n21 = 0; n22 == 0 && n21 < nArray5[n8]; ++n21) {
                                    for (int i = n21 + 1; i < nArray5[n8]; ++i) {
                                        if (nArray3[n8][n21] != nArray3[n8][i]) continue;
                                        for (n20 = i + 1; n20 < nArray5[n8]; ++n20) {
                                            nArray3[n8][n20 - 1] = nArray3[n8][n20];
                                            nArray7[n8][n20 - 1] = nArray7[n8][n20];
                                        }
                                        int n28 = n8;
                                        nArray5[n28] = nArray5[n28] - 1;
                                        --n3;
                                        n22 = 1;
                                        continue block24;
                                    }
                                }
                                if (n22 != 0) continue;
                                n3 = 0;
                                nArray5[n8] = n4;
                            }
                        }
                        if (this.gErrout != null) {
                            try {
                                this.gErrout.write("leaving/incoming info of one refu strand; UnitRxn:" + this.mUnitRxn);
                                this.gErrout.newLine();
                                for (n8 = 1; n8 <= n10; ++n8) {
                                    n7 = nArray10[n][n8];
                                    this.gErrout.write("atm: " + n7 + "; leaving:");
                                    for (n6 = 0; n6 < nArray5[n8]; ++n6) {
                                        this.gErrout.write(" " + nArray3[n8][n6]);
                                    }
                                    this.gErrout.write(" incoming: ");
                                    for (n6 = 0; n6 < nArray6[n8]; ++n6) {
                                        this.gErrout.write(" " + nArray4[n8][n6]);
                                    }
                                    this.gErrout.newLine();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        n8 = 0;
                        if (nArray11[0] == 0) {
                            n8 = nArray9[1][0];
                            this.mResult.mStereoInfo[this.mUnitRxn] = nArray9[1][0];
                        }
                        if (this.mIndexToCreate == 0) {
                            ++this.mUnitRxn;
                            continue;
                        }
                        if (n10 == 1) {
                            nArray[this.mUnitRxn][0] = this.mResult.mClassResult[this.mUnitRxn] << 11;
                            int[] nArray22 = nArray[this.mUnitRxn];
                            nArray22[0] = nArray22[0] | this.properties(n12, nArray10[n][1]);
                            int[] nArray23 = nArray[this.mUnitRxn];
                            nArray23[0] = nArray23[0] << 2;
                            int[] nArray24 = nArray[this.mUnitRxn];
                            nArray24[0] = nArray24[0] | n8;
                        } else {
                            nArray[this.mUnitRxn][0] = this.mResult.mClassResult[this.mUnitRxn] << 11;
                            n7 = this.properties(n12, nArray10[n][1]);
                            int[] nArray25 = nArray[this.mUnitRxn];
                            nArray25[0] = nArray25[0] | n7;
                            int[] nArray26 = nArray[this.mUnitRxn];
                            nArray26[0] = nArray26[0] << 11;
                            n6 = this.properties(n12, nArray10[1 - n][1]);
                            int[] nArray27 = nArray[this.mUnitRxn];
                            nArray27[0] = nArray27[0] | n6;
                            if (this.mClassificationData.getRRxnSymmetric(this.mResult.mClassResult[this.mUnitRxn])) {
                                nArray[this.mUnitRxn][1] = this.mResult.mClassResult[this.mUnitRxn] << 11;
                                int[] nArray28 = nArray[this.mUnitRxn];
                                nArray28[1] = nArray28[1] | n6;
                                int[] nArray29 = nArray[this.mUnitRxn];
                                nArray29[1] = nArray29[1] << 11;
                                int[] nArray30 = nArray[this.mUnitRxn];
                                nArray30[1] = nArray30[1] | n7;
                            }
                            this.mResult.mFlashMol[this.mUnitRxn][1] = nArray10[1 - n][0];
                            this.mResult.mFlashAtom[this.mUnitRxn][1] = nArray10[1 - n][1];
                        }
                        this.mResult.mFlashMol[this.mUnitRxn][0] = nArray10[n][0];
                        this.mResult.mFlashAtom[this.mUnitRxn][0] = nArray10[n][1];
                        for (n7 = 0; n7 < this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]); ++n7) {
                            for (n6 = 0; n6 < 4; ++n6) {
                                nArray2[this.mUnitRxn][n7][n6] = 0;
                            }
                            for (n6 = 0; n6 < this.mClassificationData.getRRxnFGroups(this.mResult.mClassResult[this.mUnitRxn]); ++n6) {
                                n5 = this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], n7, n6) & 0xF;
                                n4 = (this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], n7, n6) & 0x30) >> 4;
                                nArray2[this.mUnitRxn][n7][n6] = (this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], n7, n6) & 0x40) != 0 ? nArray4[n5][n4] : nArray3[n5][n4];
                            }
                        }
                        n7 = 0;
                        for (n6 = n2; n6 < this.mUnitRxn; ++n6) {
                            if (this.mClassificationData.getRRxnSymmetric(this.mResult.mClassResult[this.mUnitRxn])) {
                                if (nArray[this.mUnitRxn][0] != nArray[n6][0] && nArray[this.mUnitRxn][0] != nArray[n6][1]) continue;
                                if (nArray[this.mUnitRxn][0] == nArray[n6][0]) {
                                    for (n5 = 0; n5 < this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]) >> 1; ++n5) {
                                        if (nArray2[this.mUnitRxn][n5][0] != nArray2[n6][0][0] || nArray2[this.mUnitRxn][n5][1] != nArray2[n6][0][1] || nArray2[this.mUnitRxn][n5][2] != nArray2[n6][0][2] || nArray2[this.mUnitRxn][n5][3] != nArray2[n6][0][3]) continue;
                                        n7 = 1;
                                        break;
                                    }
                                }
                                if (nArray[this.mUnitRxn][0] == nArray[n6][1]) {
                                    for (n5 = this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]) >> 1; n5 < this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]); ++n5) {
                                        if (nArray2[this.mUnitRxn][n5][0] != nArray2[n6][0][0] || nArray2[this.mUnitRxn][n5][1] != nArray2[n6][0][1] || nArray2[this.mUnitRxn][n5][2] != nArray2[n6][0][2] || nArray2[this.mUnitRxn][n5][3] != nArray2[n6][0][3]) continue;
                                        n7 = 1;
                                        break;
                                    }
                                }
                            } else {
                                if (nArray[this.mUnitRxn][0] != nArray[n6][0]) continue;
                                for (n5 = 0; n5 < this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]); ++n5) {
                                    if (nArray2[this.mUnitRxn][n5][0] != nArray2[n6][0][0] || nArray2[this.mUnitRxn][n5][1] != nArray2[n6][0][1] || nArray2[this.mUnitRxn][n5][2] != nArray2[n6][0][2] || nArray2[this.mUnitRxn][n5][3] != nArray2[n6][0][3]) continue;
                                    n7 = 1;
                                    break;
                                }
                            }
                            if (n7 != 0) break;
                        }
                        if (n7 != 0) {
                            this.mResult.mUnitName[this.mUnitRxn] = null;
                            continue;
                        }
                        for (n6 = 0; n6 < 4; ++n6) {
                            this.mResult.mChngGrps[this.mUnitRxn][n6] = nArray2[this.mUnitRxn][0][n6];
                        }
                        for (n6 = 0; n6 < this.mClassificationData.getRRxnFGroups(this.mResult.mClassResult[this.mUnitRxn]); ++n6) {
                            n5 = this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n6) & 0xF;
                            n4 = (this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n6) & 0x30) >> 4;
                            if ((this.mClassificationData.getRRxnDef(this.mResult.mClassResult[this.mUnitRxn], 0, n6) & 0x40) != 0) {
                                this.mResult.mFlashMol[this.mUnitRxn][n6 + 2] = this.mCorProd[n12][nArray10[n][1]];
                                this.mResult.mFlashAtom[this.mUnitRxn][n6 + 2] = nArray8[n5][n4];
                                continue;
                            }
                            this.mResult.mFlashMol[this.mUnitRxn][n6 + 2] = n12;
                            this.mResult.mFlashAtom[this.mUnitRxn][n6 + 2] = nArray7[n5][n4];
                        }
                        ++this.mUnitRxn;
                        if (this.mUnitRxn != 16) continue;
                        return 27;
                    }
                    if (this.mUnitRxn != 16) continue;
                    return 27;
                }
                if (n13 != 0 && this.mIndexToCreate != 0) {
                    DatabaseReaction databaseReaction2 = (DatabaseReaction)this.mRxn;
                    if (this.mIndexToCreate == 1) {
                        n11 = this.mUnitRxn;
                        this.mUnitRxn = n2;
                        while (this.mUnitRxn < n11) {
                            n10 = this.mResult.mMainClass[this.mUnitRxn] == 6 ? 21 : 30;
                            this.putindexbits(110, 32, (databaseReaction2.getReactionYield() << 24) + databaseReaction2.getReactionRegNo());
                            this.putindexbits(32, n10, nArray[this.mUnitRxn][0]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][0]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][1]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][2]);
                            this.putindexbits(108, 8, nArray2[this.mUnitRxn][0][3]);
                            ++this.mUnitRxn;
                        }
                    } else if (this.mIndexToCreate == 2) {
                        n11 = this.mUnitRxn;
                        this.mUnitRxn = n2;
                        while (this.mUnitRxn < n11) {
                            n10 = this.mResult.mMainClass[this.mUnitRxn] == 6 ? 21 : 30;
                            this.putindexbits(110, 32, databaseReaction2.getReactionRegNo());
                            this.putindexbits(32, n10, nArray[this.mUnitRxn][0]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][0]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][1]);
                            this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][2]);
                            this.putindexbits(108, 8, nArray2[this.mUnitRxn][0][3]);
                            for (n = 1; n < this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]); ++n) {
                                if (this.mClassificationData.getRRxnSymmetric(this.mResult.mClassResult[this.mUnitRxn]) && n >= this.mClassificationData.getRRxnMasks(this.mResult.mClassResult[this.mUnitRxn]) / 2) {
                                    this.putindexbits(99, 32, databaseReaction2.getReactionRegNo());
                                    this.putindexbits(32, n10, nArray[this.mUnitRxn][1]);
                                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][0]);
                                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][1]);
                                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][2]);
                                    this.putindexbits(108, 8, nArray2[this.mUnitRxn][n][3]);
                                    continue;
                                }
                                this.putindexbits(99, 32, databaseReaction2.getReactionRegNo());
                                this.putindexbits(32, n10, nArray[this.mUnitRxn][0]);
                                this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][0]);
                                this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][1]);
                                this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][2]);
                                this.putindexbits(108, 8, nArray2[this.mUnitRxn][n][3]);
                            }
                            ++this.mUnitRxn;
                        }
                    }
                }
                int n29 = 0;
                n2 = this.mUnitRxn;
                for (n11 = 0; n11 < this.mRxn.getReactants(); ++n11) {
                    StereoMolecule stereoMolecule = this.mRxn.getMolecule(n11);
                    for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                        if (this.mAtomType[n11][n] == 1 || (this.mAtomFlags[n11][n] & 0x8000) == 0 || stereoMolecule.getAtomMapNo(n) == 0) continue;
                        n9 = this.mCorProd[n11][n];
                        n8 = this.mCorAtom[n11][n];
                        n7 = this.mZ[n11][n] - this.mZ[n9][n8];
                        this.mResult.mUnitName[this.mUnitRxn] = n7 < 0 ? "X" + -n7 + Molecule.cAtomLabel[stereoMolecule.getAtomicNo(n)] : (n7 > 0 ? "R" + n7 + Molecule.cAtomLabel[stereoMolecule.getAtomicNo(n)] : "S," + Molecule.cAtomLabel[stereoMolecule.getAtomicNo(n)]);
                        int[] nArray31 = this.mAtomFlags[n11];
                        int n30 = n;
                        nArray31[n30] = nArray31[n30] & 0xFFFF7FFF;
                        this.mResult.mMainClass[this.mUnitRxn] = 8;
                        ++n29;
                        if (this.mIndexToCreate == 0) {
                            ++this.mUnitRxn;
                            continue;
                        }
                        nArray4[0][1] = 0;
                        nArray4[0][0] = 0;
                        nArray6[0] = this.leaving(this.mCorProd[n11][n], this.mCorAtom[n11][n], n11, n, nArray4[0], nArray8[0], nArray12);
                        while (nArray6[0] > 2) {
                            n6 = 0;
                            block45: for (n5 = 0; n6 == 0 && n5 < nArray6[0]; ++n5) {
                                for (n4 = n5 + 1; n4 < nArray6[0]; ++n4) {
                                    if (nArray4[0][n5] != nArray4[0][n4]) continue;
                                    for (n3 = n4 + 1; n3 < nArray6[0]; ++n3) {
                                        nArray4[0][n3 - 1] = nArray4[0][n3];
                                        nArray8[0][n3 - 1] = nArray8[0][n3];
                                        nArray6[0] = nArray6[0] - 1;
                                    }
                                    n6 = 1;
                                    continue block45;
                                }
                            }
                            if (n6 != 0) continue;
                            nArray6[0] = 2;
                        }
                        nArray3[0][1] = 0;
                        nArray3[0][0] = 0;
                        nArray5[0] = this.leaving(n11, n, this.mCorProd[n11][n], this.mCorAtom[n11][n], nArray3[0], nArray7[0], nArray12);
                        while (nArray5[0] > 2) {
                            n6 = 0;
                            block49: for (n5 = 0; n6 == 0 && n5 < nArray5[0]; ++n5) {
                                for (n4 = n5 + 1; n4 < nArray5[0]; ++n4) {
                                    if (nArray3[0][n5] != nArray3[0][n4]) continue;
                                    for (n3 = n4 + 1; n3 < nArray5[0]; ++n3) {
                                        nArray3[0][n3 - 1] = nArray3[0][n3];
                                        nArray7[0][n3 - 1] = nArray7[0][n3];
                                        nArray5[0] = nArray5[0] - 1;
                                    }
                                    n6 = 1;
                                    continue block49;
                                }
                            }
                            if (n6 != 0) continue;
                            nArray5[0] = 2;
                        }
                        nArray[this.mUnitRxn][0] = n7 + 8 << 8;
                        int[] nArray32 = nArray[this.mUnitRxn];
                        nArray32[0] = nArray32[0] | stereoMolecule.getAtomicNo(n);
                        int[] nArray33 = nArray[this.mUnitRxn];
                        nArray33[0] = nArray33[0] << 11;
                        int[] nArray34 = nArray[this.mUnitRxn];
                        nArray34[0] = nArray34[0] | this.properties(n11, n);
                        nArray2[this.mUnitRxn][0][0] = nArray4[0][0];
                        nArray2[this.mUnitRxn][0][1] = nArray4[0][1];
                        nArray2[this.mUnitRxn][0][2] = nArray3[0][0];
                        nArray2[this.mUnitRxn][0][3] = nArray3[0][1];
                        nArray2[this.mUnitRxn][1][0] = nArray4[0][0];
                        nArray2[this.mUnitRxn][1][1] = nArray4[0][1];
                        nArray2[this.mUnitRxn][1][2] = nArray3[0][1];
                        nArray2[this.mUnitRxn][1][3] = nArray3[0][0];
                        nArray2[this.mUnitRxn][2][0] = nArray4[0][1];
                        nArray2[this.mUnitRxn][2][1] = nArray4[0][0];
                        nArray2[this.mUnitRxn][2][2] = nArray3[0][0];
                        nArray2[this.mUnitRxn][2][3] = nArray3[0][1];
                        nArray2[this.mUnitRxn][3][0] = nArray4[0][1];
                        nArray2[this.mUnitRxn][3][1] = nArray4[0][0];
                        nArray2[this.mUnitRxn][3][2] = nArray3[0][1];
                        nArray2[this.mUnitRxn][3][3] = nArray3[0][0];
                        this.mResult.mChngGrps[this.mUnitRxn][0] = nArray4[0][0];
                        this.mResult.mChngGrps[this.mUnitRxn][1] = nArray4[0][1];
                        this.mResult.mChngGrps[this.mUnitRxn][2] = nArray3[0][0];
                        this.mResult.mChngGrps[this.mUnitRxn][3] = nArray3[0][1];
                        this.mResult.mFlashMol[this.mUnitRxn][1] = n11;
                        this.mResult.mFlashAtom[this.mUnitRxn][1] = n;
                        this.mResult.mFlashMol[this.mUnitRxn][2] = this.mCorProd[n11][n];
                        this.mResult.mFlashAtom[this.mUnitRxn][2] = nArray8[0][0];
                        this.mResult.mFlashMol[this.mUnitRxn][3] = this.mCorProd[n11][n];
                        this.mResult.mFlashAtom[this.mUnitRxn][3] = nArray8[0][1];
                        this.mResult.mFlashMol[this.mUnitRxn][4] = n11;
                        this.mResult.mFlashAtom[this.mUnitRxn][4] = nArray7[0][0];
                        this.mResult.mFlashMol[this.mUnitRxn][5] = n11;
                        this.mResult.mFlashAtom[this.mUnitRxn][5] = nArray7[0][1];
                        n6 = 0;
                        block52: for (n5 = n2; n5 < this.mUnitRxn; ++n5) {
                            if (nArray[n5][0] != nArray[this.mUnitRxn][0]) continue;
                            for (n4 = 0; n4 < 4; ++n4) {
                                if (nArray2[this.mUnitRxn][0][0] != nArray2[n5][n4][0] || nArray2[this.mUnitRxn][0][1] != nArray2[n5][n4][1] || nArray2[this.mUnitRxn][0][2] != nArray2[n5][n4][2] || nArray2[this.mUnitRxn][0][3] != nArray2[n5][n4][3]) continue;
                                n6 = 1;
                                continue block52;
                            }
                        }
                        if (n6 != 0) {
                            this.mResult.mUnitName[this.mUnitRxn] = null;
                            continue;
                        }
                        ++this.mUnitRxn;
                        if (this.mUnitRxn != 16) continue;
                        return 27;
                    }
                    if (this.mUnitRxn != 16) continue;
                    return 27;
                }
                if (n29 == 0 || this.mIndexToCreate == 0) break block86;
                databaseReaction = (DatabaseReaction)this.mRxn;
                if (this.mIndexToCreate != 1) break block87;
                int n31 = this.mUnitRxn;
                this.mUnitRxn = n2;
                while (this.mUnitRxn < n31) {
                    this.putindexbits(110, 32, (databaseReaction.getReactionYield() << 24) + databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 23, nArray[this.mUnitRxn][0]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][0]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][1]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][2]);
                    this.putindexbits(108, 8, nArray2[this.mUnitRxn][0][3]);
                    ++this.mUnitRxn;
                }
                break block86;
            }
            if (this.mIndexToCreate != 2) break block86;
            int n32 = this.mUnitRxn;
            this.mUnitRxn = n2;
            while (this.mUnitRxn < n32) {
                this.putindexbits(110, 32, databaseReaction.getReactionRegNo());
                this.putindexbits(32, 23, nArray[this.mUnitRxn][0]);
                this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][0]);
                this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][1]);
                this.putindexbits(32, 8, nArray2[this.mUnitRxn][0][2]);
                this.putindexbits(108, 8, nArray2[this.mUnitRxn][0][3]);
                for (n = 1; n < 4; ++n) {
                    this.putindexbits(99, 32, databaseReaction.getReactionRegNo());
                    this.putindexbits(32, 23, nArray[this.mUnitRxn][0]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][0]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][1]);
                    this.putindexbits(32, 8, nArray2[this.mUnitRxn][n][2]);
                    this.putindexbits(108, 8, nArray2[this.mUnitRxn][n][3]);
                }
                ++this.mUnitRxn;
            }
        }
        return 0;
    }

    private void findClassNam() {
        if (this.mUnitRxn == 0) {
            this.mResult.mClassName = "no changing atoms";
            return;
        }
        int n = this.mResult.mMainClass[0];
        for (int i = 1; i < this.mUnitRxn; ++i) {
            if (n == this.mResult.mMainClass[i]) continue;
            n = 127;
            break;
        }
        switch (n) {
            case 0: {
                this.mResult.mClassName = "single construction";
                break;
            }
            case 11: {
                this.mResult.mClassName = "electrocyclic ring closure";
                break;
            }
            case 1: {
                this.mResult.mClassName = "asymmetric double construction";
                break;
            }
            case 2: {
                this.mResult.mClassName = "symmetric double construction";
                break;
            }
            case 5: {
                this.mResult.mClassName = "fragmentation";
                break;
            }
            case 12: {
                this.mResult.mClassName = "electrocyclic ring opening";
                break;
            }
            case 9: {
                this.mResult.mClassName = "asymmetric double fragmentation";
                break;
            }
            case 10: {
                this.mResult.mClassName = "symmetric double fragmentation";
                break;
            }
            case 3: {
                this.mResult.mClassName = "asymmetric rearrangement";
                break;
            }
            case 4: {
                this.mResult.mClassName = "symmetric rearrangement";
                break;
            }
            case 6: {
                this.mResult.mClassName = "refunctionalisation";
                break;
            }
            case 7: {
                this.mResult.mClassName = "refunctionalisation";
                break;
            }
            case 8: {
                this.mResult.mClassName = "refunctionalisation";
                break;
            }
            default: {
                this.mResult.mClassName = "miscellaneous classes";
            }
        }
    }

    private void putindexbits(int n, int n2, int n3) {
        if (this.mIndexToCreate == 0) {
            return;
        }
        if (n == 110) {
            indexnum = 0;
            indexpoin = 0;
            data = 0;
            availbits = 32;
        }
        if (n == 99) {
            ++indexnum;
            indexpoin = 0;
            data = 0;
            availbits = 32;
        }
        if (this.mIndexToCreate == 1 && indexnum > 0) {
            return;
        }
        if (n2 != 0) {
            mask = 1 << n2 - 1;
        }
        for (int i = 0; i < n2; ++i) {
            if (availbits == 0) {
                if (this.mIndexToCreate == 2) {
                    this.mResult.mIndex[this.mUnitRxn][ReactionClassifier.indexnum][ReactionClassifier.indexpoin++] = data;
                }
                data = 0;
                availbits = 32;
            }
            data <<= 1;
            if ((mask & n3) != 0) {
                data |= 1;
            }
            mask >>= 1;
            --availbits;
        }
        if (n == 108) {
            data <<= availbits;
            if (this.mIndexToCreate == 2) {
                this.mResult.mIndex[this.mUnitRxn][ReactionClassifier.indexnum][ReactionClassifier.indexpoin] = data;
            }
        }
    }

    private int conLngth(int n, int n2, int n3, boolean bl) {
        int n4;
        int[][] nArray = new int[2][256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            nArray[0][n4] = 0;
            nArray[1][n4] = 0;
            nArray2[n4] = 0;
        }
        nArray[0][n2] = 2;
        nArray2[n2] = n3;
        n4 = -1;
        if (bl) {
            n4 = this.mCorProd[n][n2];
            nArray3[n2] = this.mCorAtom[n][n2];
        }
        int n5 = 0;
        for (int i = 2; i < 30; ++i) {
            for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                if (nArray[n5][j] != i) continue;
                for (int k = 0; k < stereoMolecule.getConnAtoms(j); ++k) {
                    int n6 = stereoMolecule.getConnAtom(j, k);
                    if (n6 == n2 || n6 == nArray2[j]) continue;
                    if (bl) {
                        boolean bl2 = false;
                        StereoMolecule stereoMolecule2 = this.mRxn.getMolecule(n4);
                        for (int i2 = 0; i2 < stereoMolecule2.getConnAtoms(nArray3[j]); ++i2) {
                            int n7 = stereoMolecule2.getConnAtom(nArray3[j], i2);
                            if (stereoMolecule.getAtomMapNo(n6) != 0) {
                                if (stereoMolecule.getAtomMapNo(n6) != stereoMolecule2.getAtomMapNo(n7)) continue;
                                nArray3[n6] = n7;
                                bl2 = true;
                                break;
                            }
                            if (stereoMolecule.getAtomicNo(n6) != stereoMolecule2.getAtomicNo(n7) || stereoMolecule2.getAtomMapNo(n7) != 0) continue;
                            nArray3[n6] = n7;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                    }
                    if (n6 == n3) {
                        return i;
                    }
                    nArray[1 - n5][n6] = i + 1;
                    nArray2[n6] = j;
                }
            }
            n5 = 1 - n5;
        }
        return 0;
    }

    private int findFrag(int n, int n2, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int n3 = 1;
        int n4 = 2;
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        nArray3[0] = 256;
        nArray3[1] = n2;
        nArray4[1] = 0;
        nArray[1] = n2;
        nArray2[n2] = 1;
        if (this.gErrout != null) {
            try {
                this.gErrout.newLine();
                this.gErrout.write("findfrag->");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        while (true) {
            int n5;
            boolean bl = false;
            int n6 = -1;
            do {
                boolean bl2 = bl = nArray4[n3] == stereoMolecule.getConnAtoms(nArray3[n3]);
                if (bl) break;
                int n7 = n3;
                n5 = nArray4[n7];
                nArray4[n7] = n5 + 1;
            } while ((n6 = stereoMolecule.getConnAtom(nArray3[n3], n5)) == nArray3[n3 - 1] || nArray2[n6] != 0 || this.mAtomType[n][n6] != 1);
            if (!bl) {
                if (n4 > 64) {
                    return 11;
                }
                nArray[n4] = n6;
                nArray2[n6] = n4++;
                nArray3[++n3] = n6;
                nArray4[n3] = 0;
                if (this.gErrout == null) continue;
                try {
                    this.gErrout.write(" " + n6);
                }
                catch (IOException iOException) {}
                continue;
            }
            if (--n3 == 0) break;
        }
        nArray[0] = n4 - 1;
        if (this.gErrout != null) {
            try {
                this.gErrout.newLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int findStrand(int[] nArray) {
        int n = 1;
        int n2 = nArray[0];
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n2);
        if (this.gErrout != null) {
            try {
                this.gErrout.write("strandmol:" + stereoMolecule + "; Atms:" + nArray[1] + ",");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = 1; i <= 7; ++i) {
            int n3 = nArray[i];
            boolean bl = false;
            for (int j = 0; j < stereoMolecule.getConnAtoms(n3); ++j) {
                int n4;
                int n5;
                int n6 = stereoMolecule.getConnAtom(n3, j);
                if (this.mAtomType[n2][n6] != 1 || (this.mAtomFlags[n2][n6] & 0x1000) == 0) continue;
                int n7 = stereoMolecule.getConnBond(n3, j);
                int n8 = this.mCorProd[n2][n3];
                int n9 = this.mCorAtom[n2][n3];
                StereoMolecule stereoMolecule2 = this.mRxn.getMolecule(n8);
                int n10 = -1;
                int n11 = -1;
                for (n5 = 0; n5 < stereoMolecule2.getConnAtoms(n9); ++n5) {
                    n10 = stereoMolecule2.getConnAtom(n9, n5);
                    if (stereoMolecule2.getAtomMapNo(n10) != stereoMolecule.getAtomMapNo(n6)) continue;
                    n11 = stereoMolecule2.getConnBond(n9, n5);
                    break;
                }
                if (n11 == -1 || stereoMolecule.getBondOrder(n7) == stereoMolecule2.getBondOrder(n11)) continue;
                if (stereoMolecule.isDelocalizedBond(n7) && stereoMolecule2.isDelocalizedBond(n11)) {
                    int n12;
                    StereoMolecule stereoMolecule3;
                    int n13;
                    int n14;
                    int n15;
                    n5 = 0;
                    for (n4 = 0; n4 < stereoMolecule.getConnAtoms(n3); ++n4) {
                        n15 = stereoMolecule.getConnAtom(n3, n4);
                        n14 = this.mCorProd[n2][n15];
                        n13 = this.mCorAtom[n2][n15];
                        stereoMolecule3 = this.mRxn.getMolecule(n14);
                        if (n13 == 255) continue;
                        for (n12 = 0; n12 < stereoMolecule2.getConnAtoms(n9) && stereoMolecule2.getConnAtom(n9, n12) != n13; ++n12) {
                        }
                        if (n12 == stereoMolecule2.getConnAtoms(n9) || stereoMolecule.getConnBondOrder(n3, n4) != 2 && stereoMolecule2.getConnBondOrder(n9, n12) != 2 || stereoMolecule.isAromaticAtom(n15) && stereoMolecule3.isAromaticAtom(n13)) continue;
                        n5 = 1;
                    }
                    for (n4 = 0; n4 < stereoMolecule.getConnAtoms(n6); ++n4) {
                        n15 = stereoMolecule.getConnAtom(n6, n4);
                        n14 = this.mCorProd[n2][n15];
                        n13 = this.mCorAtom[n2][n15];
                        stereoMolecule3 = this.mRxn.getMolecule(n14);
                        if (n13 == 255) continue;
                        for (n12 = 0; n12 < stereoMolecule2.getConnAtoms(n10) && stereoMolecule2.getConnAtom(n10, n12) != n13; ++n12) {
                        }
                        if (n12 == stereoMolecule2.getConnAtoms(n10) || stereoMolecule.getConnBondOrder(n6, n4) != 2 && stereoMolecule2.getConnBondOrder(n10, n12) != 2 || stereoMolecule.isAromaticAtom(n15) && stereoMolecule3.isAromaticAtom(n13)) continue;
                        n5 = 1;
                    }
                    if (n5 == 0) continue;
                }
                n5 = 0;
                for (n4 = 1; n4 < i; ++n4) {
                    if (n6 != nArray[n4]) continue;
                    n5 = 1;
                    break;
                }
                if (n5 != 0) continue;
                if (bl) {
                    return 0;
                }
                if (n == 7) {
                    return -1;
                }
                bl = true;
                nArray[i + 1] = n6;
                if (this.gErrout != null) {
                    try {
                        this.gErrout.write("," + nArray[i + 1]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            if (bl) continue;
            return n;
        }
        return 0;
    }

    private int leaving(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        int n5;
        int n6;
        int n7;
        int n8;
        boolean[] blArray = new boolean[8];
        boolean[] blArray2 = new boolean[8];
        int[] nArray4 = new int[8];
        int[][] nArray5 = new int[8][2];
        int[][] nArray6 = new int[8][2];
        int[] nArray7 = new int[8];
        int[] nArray8 = new int[8];
        int[] nArray9 = new int[8];
        int[] nArray10 = new int[8];
        int[] nArray11 = new int[8];
        int[] nArray12 = new int[8];
        int n9 = this.getFGrpTypes(n, n2, nArray9, nArray7, nArray11, nArray5);
        int n10 = this.getFGrpTypes(n3, n4, nArray10, nArray8, nArray12, nArray6);
        nArray3[0] = 0;
        int n11 = 0;
        for (int i = 0; i < n9; ++i) {
            int n12;
            for (n12 = 0; n12 < n10; ++n12) {
                if (blArray2[n12] || nArray11[i] != nArray12[n12] || (nArray5[i][0] == 0 ? nArray9[i] != nArray10[n12] : nArray5[i][0] != nArray6[n12][0] || nArray5[i][1] != nArray6[n12][1])) continue;
                blArray2[n12] = true;
                blArray[i] = true;
                nArray4[i] = n12;
                break;
            }
            if (n12 != n10) continue;
            nArray2[n11] = nArray7[i];
            nArray[n11++] = nArray9[i];
            if (n11 != 4) continue;
            return 4;
        }
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        StereoMolecule stereoMolecule2 = this.mRxn.getMolecule(n3);
        if ((stereoMolecule.isAtomStereoCenter(n2) || stereoMolecule2.isAtomStereoCenter(n4)) && stereoMolecule.getConnAtoms(n2) == stereoMolecule2.getConnAtoms(n4)) {
            nArray3[0] = this.askInversion(n, n2, n3, n4);
            if (nArray3[0] != 3 && n11 == 0) {
                n8 = 0;
                for (n7 = 0; n7 < 8; ++n7) {
                    if (!blArray2[n7]) continue;
                    n8 = 1;
                }
                if (n8 != 0) {
                    for (n7 = 0; n7 < n9; ++n7) {
                        if (!blArray[n7]) continue;
                        int[] nArray13 = this.mAtomFlags[n];
                        int n13 = nArray7[n7];
                        nArray13[n13] = nArray13[n13] | 0x1000;
                        int[] nArray14 = this.mAtomFlags[n];
                        int n14 = nArray8[nArray4[n7]];
                        nArray14[n14] = nArray14[n14] | 0x1000;
                        nArray2[n11] = nArray7[n7];
                        nArray[n11++] = nArray9[n7];
                    }
                }
            }
        }
        n8 = stereoMolecule.getAtomCharge(n2);
        n7 = stereoMolecule2.getAtomCharge(n4);
        if (n8 < 0) {
            n8 = 0;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 > 0 && n8 > n7) {
            for (n6 = 0; n6 < n8 - n7; ++n6) {
                nArray2[n11] = n2;
                nArray[n11++] = 208;
                if (n11 != 4) continue;
                return 4;
            }
        }
        n6 = n7 - n8;
        for (n5 = 0; n5 < stereoMolecule2.getConnAtoms(n4); ++n5) {
            n6 += stereoMolecule2.getConnBondOrder(n4, n5);
        }
        for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n2); ++n5) {
            n6 -= stereoMolecule.getConnBondOrder(n2, n5);
        }
        for (n5 = 0; n5 < n6; ++n5) {
            nArray2[n11] = n2;
            nArray[n11++] = 2;
            if (n11 != 4) continue;
            return 4;
        }
        return n11;
    }

    private int askInversion(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int[] nArray = new int[]{2, 2, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        int[] nArray2 = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        int[] nArray3 = new int[6];
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        StereoMolecule stereoMolecule2 = this.mRxn.getMolecule(n3);
        if (stereoMolecule.getConnAtoms(n2) != stereoMolecule2.getConnAtoms(n4)) {
            return 0;
        }
        if (stereoMolecule.getConnAtoms(n2) < 3 || stereoMolecule.getConnAtoms(n2) > 4) {
            return 0;
        }
        if (!stereoMolecule2.isAtomStereoCenter(n4)) {
            return 0;
        }
        if (!stereoMolecule.isAtomStereoCenter(n2)) {
            return 1;
        }
        for (n8 = 0; n8 < 6; ++n8) {
            nArray3[n8] = 255;
        }
        n8 = 255;
        for (n7 = 0; n7 < stereoMolecule.getConnAtoms(n2); ++n7) {
            if (nArray3[n7] != 255) continue;
            if (stereoMolecule.getAtomMapNo(stereoMolecule.getConnAtom(n2, n7)) != 0) {
                for (n6 = 0; n6 < stereoMolecule2.getConnAtoms(n4); ++n6) {
                    if (stereoMolecule.getAtomMapNo(stereoMolecule.getConnAtom(n2, n7)) != stereoMolecule2.getAtomMapNo(stereoMolecule2.getConnAtom(n4, n6))) continue;
                    nArray3[n7] = stereoMolecule2.getConnAtom(n4, n6);
                    break;
                }
                if (nArray3[n7] != 255) continue;
                if (n8 != 255) {
                    return 0;
                }
                n8 = n7;
                continue;
            }
            if (n8 != 255) {
                return 0;
            }
            n8 = n7;
        }
        if (n8 != 255) {
            for (n7 = 0; n7 < stereoMolecule2.getConnAtoms(n4); ++n7) {
                n6 = 0;
                for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n2); ++n5) {
                    if (nArray3[n5] != stereoMolecule2.getConnAtom(n4, n7)) continue;
                    n6 = 1;
                    break;
                }
                if (n6 != 0) continue;
                nArray3[n8] = stereoMolecule2.getConnAtom(n4, n7);
                break;
            }
        }
        n7 = 0;
        for (n6 = 0; n6 < stereoMolecule.getConnAtoms(n2); ++n6) {
            n7 <<= 2;
            n5 = 0;
            for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
                if (nArray3[i] >= nArray3[n6]) continue;
                ++n5;
            }
            n7 |= n5;
        }
        int n9 = n6 = stereoMolecule.getConnAtoms(n2) == 3 ? nArray[n7] : nArray2[n7];
        if (n6 == 2) {
            return 0;
        }
        if (stereoMolecule.getAtomParity(n2) == stereoMolecule2.getAtomParity(n4)) {
            return 3 - n6;
        }
        return 2 + n6;
    }

    private int getFGrpTypes(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) {
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        int n3 = 0;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
            int n4;
            int n5 = stereoMolecule.getConnAtom(n2, i);
            if (this.mAtomType[n][n5] == 1 || n3 + (n4 = stereoMolecule.getConnBondOrder(n2, i)) > 8) continue;
            nArray2[n3] = n5;
            nArray3[n3] = stereoMolecule.getAtomMapNo(n5);
            nArray[n3] = this.gettyp(n, n5, n2, n4, nArray4[n3]);
            ++n3;
            for (int j = 1; j < n4; ++j) {
                nArray[n3] = nArray[n3 - 1];
                nArray2[n3] = nArray2[n3 - 1];
                nArray3[n3] = nArray3[n3 - 1];
                nArray4[n3][0] = nArray4[n3 - 1][0];
                nArray4[n3][1] = nArray4[n3 - 1][1];
                ++n3;
            }
        }
        return n3;
    }

    private int gettyp(int n, int n2, int n3, int n4, int[] nArray) {
        int[] nArray2 = new int[]{0, 2, 0, 40, 48, 56, 0, 0, 0, 216, 0, 36, 42, 50, 58, 0, 0, 220, 0, 37, 44, 64, 68, 70, 80, 84, 85, 86, 87, 72, 76, 52, 59, 232, 0, 222, 0, 38, 45, 65, 69, 71, 82, 0, 89, 90, 91, 73, 77, 54, 60, 62, 0, 223, 0, 39, 46, 66, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 69, 71, 83, 92, 93, 94, 95, 74, 78, 55, 61, 63, 0, 0, 0, 0, 47, 67, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 6, 222, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        nArray[0] = 0;
        nArray[1] = 0;
        StereoMolecule stereoMolecule = this.mRxn.getMolecule(n);
        if (stereoMolecule.getAtomicNo(n2) == 7) {
            if (stereoMolecule.getAtomMapNo(n2) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n2);
                nArray[1] = n4;
            }
            if (n4 == 3) {
                return 184;
            }
            if (n4 == 2) {
                if (stereoMolecule.getAtomCharge(n2) == 1) {
                    switch (this.mZ[n][n2]) {
                        case 0: {
                            return 176;
                        }
                        case 1: {
                            return 178;
                        }
                    }
                    return 179;
                }
                switch (this.mZ[n][n2]) {
                    case 0: {
                        return 180;
                    }
                }
                return 182;
            }
            if (stereoMolecule.getAtomCharge(n2) == 1) {
                if (this.mZ[n][n2] == 1) {
                    return 172;
                }
                if (this.mZ[n][n2] > 1) {
                    return 174;
                }
                switch (this.mPi[n][n2]) {
                    case 0: {
                        return 168;
                    }
                    case 1: {
                        return 170;
                    }
                }
                return 171;
            }
            if (this.mZ[n][n2] == 0) {
                if (this.mPi[n][n2] == 0) {
                    switch (this.mSigma[n][n2]) {
                        case 1: {
                            return 160;
                        }
                        case 2: {
                            return 161;
                        }
                    }
                    return 162;
                }
                return 163;
            }
            if (this.mZ[n][n2] == 1) {
                return 164;
            }
            return 166;
        }
        if (stereoMolecule.getAtomicNo(n2) == 8) {
            int n5;
            if (n4 == 2) {
                return 156;
            }
            int n6 = -1;
            for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n2); ++n5) {
                if (stereoMolecule.getConnAtom(n2, n5) == n3) continue;
                n6 = stereoMolecule.getConnAtom(n2, n5);
            }
            if (n6 == -1) {
                return 152;
            }
            if (stereoMolecule.getAtomMapNo(n6) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n6);
                nArray[1] = 8;
            }
            if (this.mAtomType[n][n6] == 1) {
                if (this.mPi[n][n6] == 0) {
                    switch (this.mZ[n][n6]) {
                        case 1: {
                            for (n5 = 0; n5 < stereoMolecule.getConnAtoms(n6); ++n5) {
                                if (this.mPi[n][stereoMolecule.getConnAtom(n6, n5)] == 0) continue;
                                return 132;
                            }
                            switch (this.mSigma[n][n6]) {
                                case 0: {
                                    return 128;
                                }
                                case 1: {
                                    return 129;
                                }
                                case 2: {
                                    return 130;
                                }
                                case 3: {
                                    return 131;
                                }
                            }
                        }
                        case 2: {
                            switch (this.mSigma[n][n6]) {
                                case 0: {
                                    return 136;
                                }
                                case 1: {
                                    return 137;
                                }
                                case 2: {
                                    return 138;
                                }
                            }
                        }
                        case 3: {
                            switch (this.mSigma[n][n6]) {
                                case 0: {
                                    return 140;
                                }
                                case 1: {
                                    return 141;
                                }
                            }
                        }
                        case 4: {
                            return 142;
                        }
                    }
                    return 0;
                }
                if (stereoMolecule.isAromaticAtom(n6)) {
                    return 134;
                }
                return 135;
            }
            switch (stereoMolecule.getAtomicNo(n6)) {
                case 7: {
                    return 145;
                }
                case 8: {
                    return 144;
                }
                case 14: {
                    return 154;
                }
                case 15: {
                    return 147;
                }
                case 16: {
                    return 146;
                }
            }
            return 148;
        }
        if (stereoMolecule.getAtomicNo(n2) == 15) {
            if (stereoMolecule.getAtomMapNo(n2) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n2);
                nArray[1] = 15;
            }
            if (this.mZ[n][n2] == 0) {
                if (stereoMolecule.getAtomCharge(n2) != 0) {
                    return 226;
                }
                return 224;
            }
            if (this.mZ[n][n2] <= 2) {
                return 228;
            }
            return 230;
        }
        if (stereoMolecule.getAtomicNo(n2) == 16) {
            if (stereoMolecule.getAtomMapNo(n2) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n2);
                nArray[1] = 16;
            }
            if (n4 == 2) {
                return 249;
            }
            switch (this.mZ[n][n2]) {
                case 0: {
                    return 248;
                }
                case 1: {
                    return 242;
                }
                case 2: {
                    return 244;
                }
                case 4: {
                    return 246;
                }
            }
            return 240;
        }
        if (stereoMolecule.getAtomicNo(n2) == 34) {
            if (stereoMolecule.getAtomMapNo(n2) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n2);
                nArray[1] = 34;
            }
            switch (this.mZ[n][n2]) {
                case 0: {
                    return 250;
                }
                case 1: {
                    return 243;
                }
                case 2: {
                    return 245;
                }
                case 4: {
                    return 247;
                }
            }
            return 241;
        }
        if (stereoMolecule.getAtomicNo(n2) == 52) {
            if (stereoMolecule.getAtomMapNo(n2) != 0) {
                nArray[0] = stereoMolecule.getAtomMapNo(n2);
                nArray[1] = 52;
            }
            if (this.mZ[n][n2] == 0) {
                return 252;
            }
            return 254;
        }
        return nArray2[stereoMolecule.getAtomicNo(n2)];
    }

    private void markReactionCenters() {
        for (int i = 0; i < this.mRxn.getMolecules(); ++i) {
            StereoMolecule stereoMolecule = this.mRxn.getMolecule(i);
            for (int j = 0; j < stereoMolecule.getAtoms(); ++j) {
                stereoMolecule.setAtomMarker(j, (this.mAtomFlags[i][j] & 0x1000) != 0);
            }
        }
    }
}

