/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.fractaldimension;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.ExtendedMoleculeFunctions;
import com.actelion.research.chem.properties.fractaldimension.InputObjectFracDimCalc;
import com.actelion.research.util.Formatter;
import java.util.ArrayList;
import java.util.List;

public class ResultFracDimCalc
extends InputObjectFracDimCalc {
    public static final String TAG_SMILES = "SMILES";
    public static final String TAG_ID = "MoleculeId";
    public static final String TAG_SUM_UNIQUE_FRAGMENTS_CALC = "SumUniqueFragmentsCalculated";
    public static final String TAG_ATOM_COUNT = "AtomCountNonH";
    public static final String TAG_BOND_COUNT = "BondCountNonH";
    public static final String TAG_BONDS_AT_MAX_FRAGS_CALC = "BondNumberAtMaxNumFragCalculated";
    public static final String TAG_MAX_NUM_UNIQUE_FRAGMENTS_CALC = "MaxNumUniqueFragmentsCalculated";
    public static final String TAG_FRACTAL_DIM = "FractalDimension";
    public static final String TAG_MESSAGE = "Message";
    public static final String[] ARR_TAGS = new String[]{"SMILES", "MoleculeId", "SumUniqueFragmentsCalculated", "BondNumberAtMaxNumFragCalculated", "AtomCountNonH", "BondCountNonH", "MaxNumUniqueFragmentsCalculated", "FractalDimension", "Message"};
    public static final String SEP = "\t";
    int idMolecule = -1;
    double fractalDimension = Double.NaN;
    int atomCount;
    int bondCount;
    int bondsAtMaxFrag;
    int maxNumUniqueFrags;
    int sumUniqueFrags;
    String message;

    public ResultFracDimCalc(InputObjectFracDimCalc inputObjectFracDimCalc) {
        super(inputObjectFracDimCalc);
        this.atomCount = ExtendedMoleculeFunctions.getNumNonHydrogenAtoms((ExtendedMolecule)inputObjectFracDimCalc.getData());
        this.bondCount = ExtendedMoleculeFunctions.getNumBondsNoHydrogen((ExtendedMolecule)inputObjectFracDimCalc.getData());
        this.bondsAtMaxFrag = -1;
        this.maxNumUniqueFrags = -1;
        this.sumUniqueFrags = -1;
        this.message = "";
    }

    public double getFractalDimension() {
        return this.fractalDimension;
    }

    public int getBondsAtMaxFrag() {
        return this.bondsAtMaxFrag;
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getMaxNumUniqueFrags() {
        return this.maxNumUniqueFrags;
    }

    public int getSumUniqueFrags() {
        return this.sumUniqueFrags;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSmiles());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getId());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getSumUniqueFrags());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getAtomCount());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getBondCount());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getBondsAtMaxFrag());
        stringBuilder.append(SEP);
        stringBuilder.append(this.getMaxNumUniqueFrags());
        stringBuilder.append(SEP);
        stringBuilder.append(Formatter.format3(this.getFractalDimension()));
        stringBuilder.append(SEP);
        stringBuilder.append(this.getMessage());
        return stringBuilder.toString();
    }

    public static String toStringHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TAG_SMILES);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_ID);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_SUM_UNIQUE_FRAGMENTS_CALC);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_ATOM_COUNT);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_BOND_COUNT);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_BONDS_AT_MAX_FRAGS_CALC);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_MAX_NUM_UNIQUE_FRAGMENTS_CALC);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_FRACTAL_DIM);
        stringBuilder.append(SEP);
        stringBuilder.append(TAG_MESSAGE);
        return stringBuilder.toString();
    }

    public static List<String> getHeaderTags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(TAG_SMILES);
        arrayList.add(TAG_ID);
        arrayList.add(TAG_SUM_UNIQUE_FRAGMENTS_CALC);
        arrayList.add(TAG_ATOM_COUNT);
        arrayList.add(TAG_BOND_COUNT);
        arrayList.add(TAG_BONDS_AT_MAX_FRAGS_CALC);
        arrayList.add(TAG_MAX_NUM_UNIQUE_FRAGMENTS_CALC);
        arrayList.add(TAG_FRACTAL_DIM);
        arrayList.add(TAG_MESSAGE);
        return arrayList;
    }
}

