/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.fractaldimension;

import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.fractaldimension.FractalDimensionMolecule;
import com.actelion.research.chem.properties.fractaldimension.InputObjectFracDimCalc;
import com.actelion.research.chem.properties.fractaldimension.ResultFracDimCalc;
import com.actelion.research.util.CommandLineParser;
import com.actelion.research.util.IO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class FractalDimensionMoleculeMain {
    public static final String PREFIX_OUTPUT = "fractalDimensionMoleculeResult";
    public static final int TOTAL_CAPACITY = (int)(30.0 * Math.pow(10.0, 6.0));
    private static final String USAGE = "FractalDimensionMoleculeMain.\nModest von Korff, Thomas Sander.\n2018.\nCalculates the fractal dimension for molecules. The application is memory demanding. 1 GB RAM should be assigned. Input is a file with a list of SMILES strings. Output is a tab separated file with a header line. One line is produced for each SMILES string in the result file. \n-h this help text.\n-i String path to SMILES input file. Text file with with SMILES, separated by newline.\n-w String path to output directory.\n[-c] integer maximum capacity times 1000 for fragments, default is " + TOTAL_CAPACITY + " .\n[-D] boolean elusive output.\n\n";

    public static void main(String[] stringArray) throws Throwable {
        Object object;
        Object object2;
        String string;
        int n;
        CommandLineParser commandLineParser = new CommandLineParser();
        commandLineParser.parse(stringArray);
        if (commandLineParser.getNumArguments() == 0 || commandLineParser.help()) {
            System.out.println(USAGE);
            System.exit(0);
        }
        commandLineParser.checkCommandWithValue("-i");
        File file = new File(commandLineParser.get("-i"));
        if (!file.isFile()) {
            System.err.println("Not a file " + file.getAbsolutePath() + ".");
            System.out.println(USAGE);
            System.exit(0);
        }
        commandLineParser.checkCommandWithValue("-w");
        File file2 = new File(commandLineParser.get("-w"));
        if (!file2.isDirectory()) {
            System.err.println("Not a directory '" + file2.getAbsolutePath() + "'.");
            System.out.println(USAGE);
            System.exit(0);
        }
        File file3 = new File(file2, "fractalDimensionMoleculeResult.txt");
        file3.createNewFile();
        if (!file3.canWrite()) {
            throw new IOException("No permission to write output file " + file3.getAbsolutePath() + ".");
        }
        List<String> list = IO.readLines2List(file);
        ArrayList<InputObjectFracDimCalc> arrayList = new ArrayList<InputObjectFracDimCalc>();
        SmilesParser smilesParser = new SmilesParser();
        System.out.println("Parsing SMILES");
        for (n = 0; n < list.size(); ++n) {
            string = list.get(n);
            try {
                object2 = new StereoMolecule();
                smilesParser.parse((StereoMolecule)object2, string);
                ((StereoMolecule)object2).ensureHelperArrays(7);
                object = new InputObjectFracDimCalc((StereoMolecule)object2, n, string);
                arrayList.add((InputObjectFracDimCalc)object);
                continue;
            }
            catch (Exception exception) {
                System.err.println("SMILES parsing error in line " + n + " for " + string);
                exception.printStackTrace();
            }
        }
        System.out.println("Parsed " + list.size() + " SMILES. Succeeded for " + arrayList.size() + ".");
        n = TOTAL_CAPACITY;
        if (commandLineParser.contains("-c")) {
            string = commandLineParser.get("-c");
            if (string == null) {
                System.err.println("No capacity value given for -c.");
            } else {
                n = Integer.parseInt(string) * 1000;
            }
        }
        System.out.println("Total capacity " + n);
        boolean bl = false;
        if (commandLineParser.contains("-D")) {
            bl = true;
            System.out.println("Elusive output.");
        }
        object2 = new FractalDimensionMolecule(n, bl);
        object = new BufferedWriter(new FileWriter(file3));
        ((Writer)object).write(ResultFracDimCalc.toStringHeader());
        for (InputObjectFracDimCalc inputObjectFracDimCalc : arrayList) {
            ResultFracDimCalc resultFracDimCalc = ((FractalDimensionMolecule)object2).process(inputObjectFracDimCalc);
            ((Writer)object).write("\n");
            ((Writer)object).write(resultFracDimCalc.toString());
            ((BufferedWriter)object).flush();
        }
        ((BufferedWriter)object).close();
        ((FractalDimensionMolecule)object2).finalizeThreads();
        System.out.println("Wrote output into " + file3.getAbsolutePath() + ".");
        System.out.println("Finished");
    }
}

