/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.fractaldimension;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.ExhaustiveFragmentsStatistics;
import com.actelion.research.chem.properties.complexity.ModelExhaustiveStatistics;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.chem.properties.fractaldimension.InputObjectFracDimCalc;
import com.actelion.research.chem.properties.fractaldimension.ResultFracDimCalc;
import com.actelion.research.util.PointUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FractalDimensionMolecule {
    public static final String MSG_ZERO = "Zero by definition. Max bond count at one bond.";
    private static final int MAX_THREADS_BOND_VECTOR_TO_IDCODE = 3;
    private ExhaustiveFragmentsStatistics exhaustiveFragmentsStatistics;

    public FractalDimensionMolecule(int n, boolean bl) {
        ExhaustiveFragmentsStatistics.setELUSIVE(bl);
        int n2 = Runtime.getRuntime().availableProcessors() - 1;
        n2 = Math.min(3, n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.exhaustiveFragmentsStatistics = new ExhaustiveFragmentsStatistics(128, n2, n);
    }

    public ResultFracDimCalc process(InputObjectFracDimCalc inputObjectFracDimCalc) {
        ResultFracDimCalc resultFracDimCalc = new ResultFracDimCalc(inputObjectFracDimCalc);
        StereoMolecule stereoMolecule = (StereoMolecule)inputObjectFracDimCalc.getData();
        int n = ((StereoMolecule)inputObjectFracDimCalc.getData()).getBonds();
        if (n < 3) {
            resultFracDimCalc.message = "Num bonds in molecule below limit of 3.";
            return resultFracDimCalc;
        }
        if (n > this.exhaustiveFragmentsStatistics.getMaximumNumberBondsInMolecule()) {
            resultFracDimCalc.message = "Num bonds in molecule above limit of " + this.exhaustiveFragmentsStatistics.getMaximumNumberBondsInMolecule() + ".";
            return resultFracDimCalc;
        }
        System.out.println("Process molecule " + inputObjectFracDimCalc.getId() + " with " + n + " bonds.");
        ResultFragmentsStatistic resultFragmentsStatistic = this.exhaustiveFragmentsStatistics.create(stereoMolecule, n - 1);
        List<ModelExhaustiveStatistics> list = resultFragmentsStatistic.getExhaustiveStatistics();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (ModelExhaustiveStatistics modelExhaustiveStatistics : list) {
            arrayList.add(new Point(modelExhaustiveStatistics.getNumBondsInFragment(), modelExhaustiveStatistics.getUnique()));
        }
        Collections.sort(arrayList, PointUtils.getComparatorX());
        Point point = FractalDimensionMolecule.getMaxNumUniqueFrags(arrayList);
        int n2 = point.x;
        int n3 = point.y;
        if (n2 == 1) {
            resultFracDimCalc.fractalDimension = 0.0;
            resultFracDimCalc.message = MSG_ZERO;
        } else {
            resultFracDimCalc.fractalDimension = Math.log10(n3) / Math.log10(n2);
            resultFracDimCalc.bondsAtMaxFrag = n2;
            resultFracDimCalc.maxNumUniqueFrags = n3;
            resultFracDimCalc.sumUniqueFrags = FractalDimensionMolecule.getSumUniqueFrags(arrayList);
        }
        return resultFracDimCalc;
    }

    public void finalizeThreads() throws Throwable {
        if (this.exhaustiveFragmentsStatistics != null) {
            this.exhaustiveFragmentsStatistics.finalize();
        }
    }

    public static int getSumUniqueFrags(List<Point> list) {
        int n = 0;
        int n2 = FractalDimensionMolecule.getIndexMaxNumUniqueFrags(list);
        int n3 = n2 + 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = list.get((int)i).y;
            n += n4;
        }
        return n;
    }

    public static Point getMaxNumUniqueFrags(List<Point> list) {
        int n = FractalDimensionMolecule.getIndexMaxNumUniqueFrags(list);
        return list.get(n);
    }

    public static int getIndexMaxNumUniqueFrags(List<Point> list) {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Point point = list.get(i);
            int n3 = point.y;
            if (n3 <= n2) continue;
            n2 = n3;
            n = i;
        }
        return n;
    }
}

