/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.ModelExhaustiveStatistics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultFragmentsStatistic {
    public static final String TAG_ResultFragmentsStatistic = "ResultFragmentsStatistic";
    private static final String TAG_ATTR_NAME = "Name";
    private static final String TAG_ATTR_IDCODE = "IdCode";
    private static final String TAG_ATTR_COORD = "Coordinates";
    private static final String TAG_LIST_ModelExhaustiveStatistics = "ListModelExhaustiveStatistics";
    private String name;
    private StereoMolecule mol;
    private List<ModelExhaustiveStatistics> liModelExhaustiveStatistics;

    public ResultFragmentsStatistic(StereoMolecule stereoMolecule, List<ModelExhaustiveStatistics> list) {
        this.mol = stereoMolecule;
        this.liModelExhaustiveStatistics = list;
    }

    public int getAtoms() {
        return this.mol.getAtoms();
    }

    public int getBonds() {
        return this.mol.getBonds();
    }

    public List<ModelExhaustiveStatistics> getExhaustiveStatistics() {
        return this.liModelExhaustiveStatistics;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append("Name " + this.name);
            stringBuilder.append("\n");
        }
        stringBuilder.append("Atoms " + this.getAtoms() + ", bonds " + this.getBonds() + ".");
        stringBuilder.append("\n");
        stringBuilder.append(ModelExhaustiveStatistics.toString(this));
        return stringBuilder.toString();
    }

    public Element getXMLElement(Document document) throws ParserConfigurationException, DOMException, IOException {
        Element element = document.createElement(TAG_ResultFragmentsStatistic);
        element.setAttribute(TAG_ATTR_NAME, this.name);
        Canonizer canonizer = new Canonizer(this.mol);
        element.setAttribute(TAG_ATTR_IDCODE, canonizer.getIDCode());
        element.setAttribute(TAG_ATTR_COORD, canonizer.getEncodedCoordinates());
        Element element2 = document.createElement(TAG_LIST_ModelExhaustiveStatistics);
        for (ModelExhaustiveStatistics modelExhaustiveStatistics : this.liModelExhaustiveStatistics) {
            Element element3 = modelExhaustiveStatistics.getXMLElement(document);
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        return element;
    }

    public StereoMolecule getMol() {
        return this.mol;
    }

    public static ResultFragmentsStatistic readXMLElement(Element element) throws ParserConfigurationException, DOMException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string = element.getAttribute(TAG_ATTR_NAME);
        String string2 = element.getAttribute(TAG_ATTR_IDCODE);
        String string3 = element.getAttribute(TAG_ATTR_COORD);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        Node node = null;
        for (int i = 0; i < n; ++i) {
            object3 = nodeList.item(i);
            String string4 = object3.getNodeName();
            if (!TAG_LIST_ModelExhaustiveStatistics.equals(string4)) continue;
            node = (Element)object3;
            break;
        }
        NodeList nodeList2 = node.getChildNodes();
        object3 = new ArrayList();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object2 = nodeList2.item(i);
            object = object2.getNodeName();
            if (!"ModelExhaustiveStatistics".equals(object)) continue;
            Element element2 = (Element)object2;
            ModelExhaustiveStatistics modelExhaustiveStatistics = ModelExhaustiveStatistics.readXMLElement(element2);
            object3.add(modelExhaustiveStatistics);
        }
        IDCodeParser iDCodeParser = new IDCodeParser(false);
        object2 = iDCodeParser.getCompactMolecule(string2, string3);
        object = new ResultFragmentsStatistic((StereoMolecule)object2, (List<ModelExhaustiveStatistics>)object3);
        ((ResultFragmentsStatistic)object).setName(string);
        return object;
    }
}

