/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.calc.CorrelationCalculator;
import com.actelion.research.calc.Logarithm;
import com.actelion.research.calc.regression.linear.simple.LinearRegression;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.ModelExhaustiveStatistics;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.chem.properties.complexity.ResultObjective;
import com.actelion.research.chem.properties.complexity.SymmetryCalculator;
import com.actelion.research.util.datamodel.DoubleArray;
import java.util.List;

public class ObjectiveExhaustiveStatistics {
    public static boolean VERBOSE = false;
    public static boolean SCALE = false;
    public static final int NUM_BONDS_START_REGRESSION_SMALL_MOLECULE = 1;
    public static final int DELTA_BONDS = 1;
    public static final double BASE_LOG = Math.E;
    public static final double ALMOST_ZERO = 1.0E-6;

    public ResultObjective calculateScore(ResultFragmentsStatistic resultFragmentsStatistic) {
        ResultObjective resultObjective = new ResultObjective();
        List<ModelExhaustiveStatistics> list = resultFragmentsStatistic.getExhaustiveStatistics();
        int n = (int)((double)resultFragmentsStatistic.getBonds() / 4.0);
        int n2 = n - 1;
        int n3 = n + 1;
        LinearRegression linearRegression = ObjectiveExhaustiveStatistics.getLinearRegressionUnique(list, n2, n3);
        double d = linearRegression.getSlope();
        DoubleArray doubleArray = linearRegression.getValuesAsArrayX();
        DoubleArray doubleArray2 = linearRegression.getValuesAsArrayY();
        double d2 = new CorrelationCalculator().calculateCorrelation(doubleArray, doubleArray2, 0);
        double d3 = d2 * d2;
        resultObjective.setSlopeR2(d3);
        resultObjective.setSlope(d);
        resultObjective.setNumRegressionPoints(linearRegression.getValues().size());
        double d4 = SymmetryCalculator.getRatioSymmetricAtoms(resultFragmentsStatistic.getMol());
        double d5 = d * (1.0 - d4);
        resultObjective.setScore(d5);
        return resultObjective;
    }

    private static LinearRegression getLinearRegressionUnique(List<ModelExhaustiveStatistics> list, int n, int n2) {
        LinearRegression linearRegression = new LinearRegression();
        for (int i = 0; i < list.size(); ++i) {
            ModelExhaustiveStatistics modelExhaustiveStatistics = list.get(i);
            if (modelExhaustiveStatistics.getNumBondsInFragment() < n) continue;
            if (modelExhaustiveStatistics.getNumBondsInFragment() > n2) break;
            double d = Logarithm.get(modelExhaustiveStatistics.getUnique(), Math.E);
            linearRegression.addPoint(modelExhaustiveStatistics.getNumBondsInFragment(), d);
        }
        linearRegression.calculate();
        return linearRegression;
    }

    public static int getNeededNumberOfBondsInFragment(StereoMolecule stereoMolecule) {
        int n = stereoMolecule.getBonds();
        int n2 = n / 4 + 1;
        return n2;
    }
}

