/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.properties.complexity;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.ExhaustiveFragmentGeneratorBonds;
import com.actelion.research.chem.mcs.RunBondVector2IdCode;
import com.actelion.research.chem.properties.complexity.ContainerFragBondsSolutions;
import com.actelion.research.chem.properties.complexity.FragmentDefinedByBondsIdCode;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.chem.properties.complexity.ModelExhaustiveStatistics;
import com.actelion.research.chem.properties.complexity.MultipleNonOverlapSolution;
import com.actelion.research.chem.properties.complexity.ResultFragmentsStatistic;
import com.actelion.research.util.Pipeline;
import com.actelion.research.util.datamodel.ByteVec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ExhaustiveFragmentsStatistics {
    private static boolean ELUSIVE = false;
    public static final int TOTAL_CAPACITY = (int)(10.0 * Math.pow(10.0, 6.0));
    public static final int MINLEN_FRAG = 1;
    private static final long SLEEP = 10L;
    private static final int CAPACITY = 200000;
    private static final int LIMIT_BONDS_WHERE_IDCODE_IS_STORED = 20;
    private int minNumBondsFragment;
    private ExhaustiveFragmentGeneratorBonds efg;
    private HashSet<ByteVec> hsIdCode;
    private List<List<ByteVec>> liliIdCode;
    private Pipeline<IBitArray> pipeInputFragIndexListsFromEFG;
    private Pipeline<FragmentDefinedByBondsIdCode> pipeOutputFragmentDefinedByBondsIdCode;
    private List<RunBondVector2IdCode> liRunBondVector2IdCode;
    private AtomicInteger processedFragments;
    private boolean collectFragmentIdCodes;

    public ExhaustiveFragmentsStatistics(int n, int n2, int n3) {
        this.init(n, n2, n3);
    }

    public ExhaustiveFragmentsStatistics(int n, int n2) {
        int n3 = Runtime.getRuntime().availableProcessors() - 1;
        n3 = Math.max(1, n3);
        this.init(n, n3, n2);
    }

    public ExhaustiveFragmentsStatistics(int n) {
        int n2 = Runtime.getRuntime().availableProcessors() - 1;
        n2 = Math.max(1, n2);
        this.init(n, n2, TOTAL_CAPACITY);
    }

    private void init(int n, int n2, int n3) {
        this.efg = new ExhaustiveFragmentGeneratorBonds(n, n3);
        System.out.println("ExhaustiveFragmentsStatistics init(...) totalCapacity " + n3);
        this.minNumBondsFragment = 1;
        this.hsIdCode = new HashSet(200000);
        this.processedFragments = new AtomicInteger();
        this.pipeInputFragIndexListsFromEFG = new Pipeline();
        this.pipeOutputFragmentDefinedByBondsIdCode = new Pipeline();
        this.liRunBondVector2IdCode = new ArrayList<RunBondVector2IdCode>();
        for (int i = 0; i < n2; ++i) {
            RunBondVector2IdCode runBondVector2IdCode = new RunBondVector2IdCode(i, this.pipeInputFragIndexListsFromEFG, this.pipeOutputFragmentDefinedByBondsIdCode);
            this.liRunBondVector2IdCode.add(runBondVector2IdCode);
            new Thread(runBondVector2IdCode).start();
        }
    }

    public ResultFragmentsStatistic create(StereoMolecule stereoMolecule, int n) {
        if (!this.pipeInputFragIndexListsFromEFG.isEmpty()) {
            throw new RuntimeException("Error in algorithm!");
        }
        int n2 = Math.min(this.efg.getMaximumCapacityBondsInFragment(), n);
        ArrayList<ModelExhaustiveStatistics> arrayList = new ArrayList<ModelExhaustiveStatistics>();
        if (this.collectFragmentIdCodes) {
            for (int i = 0; i < n2 + 1; ++i) {
                this.liliIdCode.get(i).clear();
            }
        }
        this.efg.set(stereoMolecule, n2);
        this.efg.generateFragmentsAllBonds();
        for (RunBondVector2IdCode runBondVector2IdCode : this.liRunBondVector2IdCode) {
            runBondVector2IdCode.init(stereoMolecule);
        }
        double d = stereoMolecule.getBonds();
        for (int i = this.minNumBondsFragment; i < n2 + 1; ++i) {
            this.hsIdCode.clear();
            this.pipeInputFragIndexListsFromEFG.reset();
            this.pipeOutputFragmentDefinedByBondsIdCode.reset();
            List<IBitArray> list = this.efg.getFragments(i);
            this.processedFragments.set(0);
            if (!this.pipeInputFragIndexListsFromEFG.isEmpty()) {
                throw new RuntimeException("Error in algorithm!");
            }
            this.pipeInputFragIndexListsFromEFG.addData(list);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    while (!ExhaustiveFragmentsStatistics.this.pipeOutputFragmentDefinedByBondsIdCode.wereAllDataFetched()) {
                        FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode = (FragmentDefinedByBondsIdCode)ExhaustiveFragmentsStatistics.this.pipeOutputFragmentDefinedByBondsIdCode.pollData();
                        if (fragmentDefinedByBondsIdCode == null) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            continue;
                        }
                        ExhaustiveFragmentsStatistics.this.hsIdCode.add(new ByteVec(fragmentDefinedByBondsIdCode.getIdCode()));
                    }
                }
            };
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(runnable);
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (this.pipeOutputFragmentDefinedByBondsIdCode.getAdded() != (long)list.size()) continue;
                this.pipeOutputFragmentDefinedByBondsIdCode.setAllDataIn();
            }
            double d2 = (double)i / d;
            ModelExhaustiveStatistics modelExhaustiveStatistics = new ModelExhaustiveStatistics(i, list.size(), this.hsIdCode.size(), d2);
            arrayList.add(modelExhaustiveStatistics);
            if (!this.collectFragmentIdCodes) continue;
            this.liliIdCode.get(i).addAll(this.hsIdCode);
        }
        ResultFragmentsStatistic resultFragmentsStatistic = new ResultFragmentsStatistic(stereoMolecule, arrayList);
        return resultFragmentsStatistic;
    }

    public boolean isCapacityLimitBreakes() {
        return this.efg.isCapacityLimitBreakes();
    }

    public List<List<ByteVec>> getLiLiIdCode() {
        return this.liliIdCode;
    }

    private boolean areAllReachedEndOfRun() {
        boolean bl = true;
        for (RunBondVector2IdCode runBondVector2IdCode : this.liRunBondVector2IdCode) {
            if (runBondVector2IdCode.isEndOfRunReached()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void finalize() throws Throwable {
        this.pipeInputFragIndexListsFromEFG.setAllDataIn(true);
        while (!this.areAllReachedEndOfRun()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.out.println("ExhaustiveFragmentsStatistics finalize() waiting for end of run.");
        }
        super.finalize();
    }

    public int getMaximumNumberBondsInMolecule() {
        return this.efg.getMaximumNumberBondsInMolecule();
    }

    public void setCollectFragmentIdCodes(boolean bl) {
        this.collectFragmentIdCodes = bl;
        if (bl) {
            int n;
            this.liliIdCode = new ArrayList<List<ByteVec>>();
            int[] nArray = new int[20];
            nArray[0] = ContainerFragBondsSolutions.START_CAPACITY;
            for (n = 1; n < nArray.length; ++n) {
                int n2;
                nArray[n] = n2 = (int)((double)nArray[n - 1] * ContainerFragBondsSolutions.FACTOR_CAPACITY);
            }
            for (n = 0; n < 1; ++n) {
                this.liliIdCode.add(new ArrayList());
            }
            for (n = 0; n < nArray.length; ++n) {
                this.liliIdCode.add(new ArrayList(nArray[n]));
            }
        }
    }

    public static Comparator<MultipleNonOverlapSolution> getComparatorCoverage() {
        return new Comparator<MultipleNonOverlapSolution>(){

            @Override
            public int compare(MultipleNonOverlapSolution multipleNonOverlapSolution, MultipleNonOverlapSolution multipleNonOverlapSolution2) {
                if (multipleNonOverlapSolution.getContainer().getBitsSet() > multipleNonOverlapSolution2.getContainer().getBitsSet()) {
                    return 1;
                }
                if (multipleNonOverlapSolution.getContainer().getBitsSet() < multipleNonOverlapSolution2.getContainer().getBitsSet()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static boolean isELUSIVE() {
        return ELUSIVE;
    }

    public static void setELUSIVE(boolean bl) {
        ELUSIVE = bl;
        ExhaustiveFragmentGeneratorBonds.setELUSIVE(bl);
    }
}

