/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.ParameterizedStringList;
import java.text.DecimalFormat;

public class SolubilityPredictor {
    public static final float cSolubilityUnknown = -999.0f;
    private static final long[] cAtomType = new long[]{524290L, 524292L, 524297L, 524301L, 589826L, 589827L, 589828L, 589829L, 589832L, 589833L, 589837L, 589838L, 688130L, 688131L, 688132L, 688137L, 688141L, 819202L, 819203L, 819204L, 819205L, 819208L, 819209L, 0x110002L, 0x110003L, 0x110004L, 0x110008L, 1212420L, 1343492L, 1343496L, 1638402L, 1638403L, 17367042L, 17367043L, 17367044L, 17367045L, 17367048L, 0x1090009L, 17367053L, 17367054L, 17465346L, 0x40080004L, 1208483842L, 0x48080004L, 1208549378L, 1208549379L, 1208549380L, 1208549384L, 1208549388L, 1409810434L, 1409875970L, 1409875971L, 1409875972L, 1409875976L, 1409974274L, 1409974280L, 1409974284L, 1678311426L, 1678311427L, 1678311428L, 1678311432L, 1678311436L, 1678409730L, 1678409731L, 1678409732L, 1678540802L, 1678540803L, 1678540804L, 1678540808L, 2282291202L, 2282291203L, 2282389506L, 2282389507L, 2282520578L, 2282520579L, 2483617794L, 2483617795L, 2483716098L, 2483716099L, 2752675842L, 3356033026L, 3557359618L, 3557457922L, 3557588994L, 34510798850L, 34510798851L, 34510798852L, 34510798856L, 34712125442L, 34712125443L, 34712125444L, 34712125448L, 34712223746L, 34712223747L, 34712223748L, 34980560898L, 34980560899L, 34980659202L, 35568287746L, 35568287747L, 35568287748L, 35568287752L, 35568386050L, 35568386051L, 35568386052L, 35568517122L, 35568517123L, 35568517124L, 35568517128L, 35568812034L, 35568812035L, 35568910338L, 35568910339L, 35568910350L, 35569336322L, 35585064962L, 35585064963L, 35585064964L, 35585064968L, 35769548802L, 35769614338L, 35769712642L, 35769843714L, 35786391554L, 2475109711874L, 2475109711875L, 2887426572290L, 2887426572291L, 2887627898882L, 2887627898883L, 2887627997186L, 3437182386178L, 3437182386179L, 3437383712770L, 3437383811074L, 3437652148226L, 3437652377602L, 3437652377603L, 4674132967426L, 4674334294018L, 4674334294019L, 4674334392322L, 4674602729474L, 4674602827778L, 4674602958850L, 5086449827842L, 5086449827848L, 5086651154434L, 5086651154435L, 5086651252738L, 5086651252739L, 5086651252743L, 5086651252744L, 5086919589890L, 5086919589896L, 5086919688194L, 5086919819266L, 5636406968322L, 5636407066626L, 5636675502082L, 5636675633154L, 70678116630530L, 70678116630531L, 70678116728834L, 70678116859906L, 70678132883458L, 70678132883459L, 71090433490946L, 71090433490947L, 71090433589250L, 71090433720322L, 71090433720323L, 71090449743874L, 71090449743875L, 71090634817538L, 71090634817539L, 71090634915842L, 71090635046914L, 71090651070466L, 71090651168770L, 71640189304834L, 71640189403138L, 71640189534210L, 71640205557762L, 71640390631426L, 71640390729730L, 71640390860802L, 71640406884354L, 72843853889538L, 72843853889539L, 72844055216130L, 72844055216131L, 72844055314434L, 72844323651586L, 72844323651587L, 72844323749890L, 72844323880962L, 72844323880963L, 72844927631362L, 72844927729666L, 72844927860738L, 72844927860744L, 72845128957954L, 72845128957960L, 72845129056258L, 72845129056263L, 72845129187330L, 72845129580558L, 72877156139010L, 72877357465602L, 72877357465603L, 72877357563906L, 72877357563907L, 72878213627906L, 72878213627907L, 72878213726210L, 72878213726211L, 72878214152194L, 72878214250498L, 72878230405122L, 73256170749954L, 73256372076546L, 73257244491778L, 73257445818370L, 73257445916674L, 5069024690503682L, 5913449620635650L, 5913449620635651L, 5913861937496066L, 5913862138822658L, 5913862138920962L, 7039349527478274L, 7039761844338690L, 7039762045665282L, 7039762045763586L, 7040311600152578L, 7040311801479170L, 7040311801577474L, 7040312069914626L, 7040312070012930L, 7040312070144002L, 10417049248006151L, 10417461564866567L, 10417461766193159L, 10417461766291463L, 10418011522007047L, 10418011522105351L, 10418011790540807L, 10418011790671879L, 10419660588122120L, 10419660789448712L, 10419660789547016L, 10419661057884168L, 10419661057982472L, 11543361673035783L, 149184212766359554L, 149184625083219970L, 149184625284546562L, 149184625284644866L, 149185174839033858L, 149185175309025282L, 149186824307900423L, 149186825381543944L, 149186825381642248L, 149186825381773320L, 149254581510537218L, 149254581711863810L, 149254581711962114L, 149254615870275586L, 149254615870373890L, 149254615870504962L};
    private static final float[] cIncrement = new float[]{-0.19f, 1.27f, -0.701f, 2.691f, -0.227f, 0.03f, 0.106f, -0.476f, -0.447f, -0.191f, -0.333f, 0.086f, 0.247f, -0.062f, 0.016f, 0.387f, 0.235f, -0.432f, -0.903f, 0.39f, 0.581f, 4.524f, -0.635f, -0.28f, 0.77f, -0.05f, 1.087f, 0.192f, 0.196f, -0.52f, 0.542f, 0.363f, 0.792f, 0.592f, 0.964f, 0.354f, -0.685f, -0.315f, -0.413f, -0.595f, 0.22f, -1.432f, -2.254f, 0.44f, -0.27f, -0.133f, -0.269f, 0.267f, 0.572f, -0.568f, 0.174f, -0.185f, -0.235f, -0.17f, -0.181f, -0.342f, -0.348f, -0.437f, -0.804f, -0.412f, -0.215f, -0.625f, -0.831f, 0.497f, -0.431f, -1.331f, 0.507f, -0.632f, -0.599f, -0.156f, -0.353f, -0.164f, -0.441f, -0.497f, -1.06f, 0.115f, -0.225f, -0.154f, -0.031f, -1.574f, -1.093f, -0.738f, -0.45f, -0.556f, -0.181f, 2.384f, 1.75f, -1.666f, -1.066f, 1.327f, 0.803f, -1.505f, -2.537f, -0.17f, 0.149f, 0.521f, 2.905f, -0.252f, 0.86f, 0.361f, 0.403f, 0.005f, 1.146f, 0.936f, -0.3f, 0.209f, -0.583f, -0.024f, -0.01f, 0.611f, 0.486f, 0.862f, -0.035f, -0.596f, 1.161f, 1.647f, 0.844f, 0.125f, 0.142f, -0.171f, 0.442f, 0.088f, 3.066f, 1.652f, -0.203f, -0.018f, 0.023f, 0.073f, 0.254f, 0.554f, 0.595f, -0.406f, -0.637f, -0.174f, -0.101f, -0.543f, -2.406f, -3.292f, -0.053f, -0.193f, 1.85f, -1.261f, -0.656f, -0.73f, -0.938f, 0.128f, 1.154f, 0.242f, -0.529f, -0.278f, -0.802f, 0.912f, -1.381f, 0.463f, 1.074f, -0.628f, -0.962f, -1.832f, -1.499f, -2.116f, -2.207f, -1.317f, 2.501f, -0.849f, -0.602f, -0.622f, 2.122f, -2.226f, 0.913f, -2.259f, -1.25f, 1.394f, -1.402f, 2.073f, -2.957f, 0.291f, -3.476f, -2.727f, -3.132f, -2.12f, -0.725f, -0.297f, 0.083f, 0.347f, -1.425f, -1.66f, -1.282f, -1.265f, 0.719f, 0.138f, 1.302f, 0.859f, 1.359f, 0.659f, -0.94f, 0.9f, 0.319f, -2.571f, 1.109f, 0.972f, 1.653f, 2.602f, 0.729f, 1.066f, 1.067f, -0.311f, 0.031f, -0.203f, -0.681f, -1.258f, 1.07f, -3.096f, -0.228f, 1.933f, 0.119f, 2.108f, 0.113f, 1.628f, 1.308f, 3.336f, 0.754f, -0.465f, -0.397f, 0.077f, -0.479f, -0.153f, 0.141f, 2.135f, 0.234f, 0.461f, 0.67f, -0.361f, -1.039f, -0.483f, 0.137f, -0.768f, -0.511f, 3.424f, -0.855f, -0.585f, -1.567f, 3.343f, 1.84f, 0.389f, 1.122f, 1.63f, 1.335f, 0.366f, -0.557f, 0.432f, 0.204f, 0.882f, 0.466f, -0.458f, 0.404f, 0.657f, 1.115f, 1.976f, 1.786f, -0.036f, -1.05f, 1.045f, 0.044f, 1.033f, -1.08f, 2.539f, 2.235f, 2.29f, 3.121f, 3.932f, 2.75f};

    public float assessSolubility(StereoMolecule stereoMolecule) {
        float f = -0.53f;
        stereoMolecule.normalizeAmbiguousBonds();
        stereoMolecule.ensureHelperArrays(7);
        block2: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            long l = -1L;
            try {
                l = AtomTypeCalculator.getAtomType(stereoMolecule, i, 2144);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int j = 0; j < cIncrement.length; ++j) {
                if (cAtomType[j] != l) continue;
                f += cIncrement[j];
                continue block2;
            }
        }
        return f;
    }

    public ParameterizedStringList getDetail(StereoMolecule stereoMolecule) {
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        parameterizedStringList.add("Solubility values are estimated applying an atom-type based increment system.", 2);
        parameterizedStringList.add("Atom-types are 64-bit numbers describing atoms and their near surrounding.", 2);
        parameterizedStringList.add("Recognized atom types and their contributions are:", 2);
        parameterizedStringList.add("Base value = -0.530", 2);
        int[] nArray = new int[cIncrement.length];
        if (stereoMolecule != null) {
            stereoMolecule.normalizeAmbiguousBonds();
            stereoMolecule.ensureHelperArrays(7);
            block2: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                long l = -1L;
                try {
                    l = AtomTypeCalculator.getAtomType(stereoMolecule, i, 2144);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int j = 0; j < cIncrement.length; ++j) {
                    if (cAtomType[j] != l) continue;
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                    continue block2;
                }
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0.000");
        for (int i = 0; i < cIncrement.length; ++i) {
            if (nArray[i] == 0) continue;
            parameterizedStringList.add("" + nArray[i] + " * " + decimalFormat.format(cIncrement[i]) + "   AtomType: 0x" + Long.toHexString(cAtomType[i]), 2);
        }
        return parameterizedStringList;
    }
}

