/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.prediction;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.IncrementTable;
import com.actelion.research.chem.prediction.ParameterizedStringList;

public class DruglikenessPredictor {
    public static final double cDruglikenessUnknown = -999.0;
    private static boolean sInitialized = false;
    private static IncrementTable sIncrementTable;
    private ParameterizedStringList mDetail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruglikenessPredictor() {
        Class<DruglikenessPredictor> clazz = DruglikenessPredictor.class;
        synchronized (DruglikenessPredictor.class) {
            if (!sInitialized) {
                try {
                    sIncrementTable = new IncrementTable("/resources/druglikenessNoIndex.txt");
                    sInitialized = true;
                }
                catch (Exception exception) {
                    System.out.println("Unable to initialize DruglikenessPredictor");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public double assessDruglikeness(StereoMolecule stereoMolecule, ThreadMaster threadMaster) {
        ParameterizedStringList parameterizedStringList = new ParameterizedStringList();
        if (!sInitialized) {
            parameterizedStringList.add("Druglikeness predictor not properly initialized.", 2);
            return -999.0;
        }
        parameterizedStringList.add("Found sub-structure fragments and their contributions:", 2);
        parameterizedStringList.add("(yellow atoms carry at least one more substituent)", 2);
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        SSSearcher sSSearcher = new SSSearcher(1);
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        for (int i = 0; i < sIncrementTable.getSize(); ++i) {
            if (threadMaster != null && threadMaster.threadMustDie()) {
                return -999.0;
            }
            Thread.yield();
            new IDCodeParser(false).parse(stereoMolecule2, sIncrementTable.getFragment(i));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            double d3 = sIncrementTable.getIncrement(i);
            if (d3 < -1.0) {
                d += d3;
            } else {
                d2 += d3;
                ++n;
            }
            parameterizedStringList.add(sIncrementTable.getFragment(i), 1);
            parameterizedStringList.add(Double.toString(d3), 3);
        }
        if (n == 0) {
            return -1.0;
        }
        double d4 = d + d2 / Math.sqrt(n);
        this.mDetail = parameterizedStringList;
        return d4 += 0.0625 * (double)(n - 40);
    }

    public String getDruglikenessString(StereoMolecule stereoMolecule) {
        if (!sInitialized) {
            return "Druglikeness predictor not properly initialized.";
        }
        double d = 0.0;
        int n = 0;
        SSSearcher sSSearcher = new SSSearcher(1);
        StereoMolecule stereoMolecule2 = new StereoMolecule();
        for (int i = 0; i < sIncrementTable.getSize(); ++i) {
            new IDCodeParser(false).parse(stereoMolecule2, sIncrementTable.getFragment(i));
            sSSearcher.setMol(stereoMolecule2, stereoMolecule);
            if (!sSSearcher.isFragmentInMolecule()) continue;
            d += sIncrementTable.getIncrement(i);
            ++n;
        }
        double d2 = n == 0 ? -1.0 : d / Math.sqrt(n);
        return d2 + "\t" + n + "\t" + stereoMolecule.getAtoms();
    }

    public ParameterizedStringList getDetail() {
        return this.mDetail;
    }
}

