/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.potentialenergy;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class BondConstraint
implements PotentialEnergyTerm {
    private static double FORCE_CONSTANT = 50.0;
    private Conformer conf;
    private int[] bondAtoms;
    private double targetValue;

    public BondConstraint(Conformer conformer, int[] nArray, double d) {
        this.conf = conformer;
        this.bondAtoms = nArray;
        this.targetValue = d;
    }

    @Override
    public double getFGValue(double[] dArray) {
        int n = this.bondAtoms[0];
        int n2 = this.bondAtoms[1];
        Coordinates coordinates = this.conf.getCoordinates(n);
        Coordinates coordinates2 = this.conf.getCoordinates(n2);
        Coordinates coordinates3 = coordinates.subC(coordinates2);
        double d = coordinates3.dist();
        double d2 = FORCE_CONSTANT * (d - this.targetValue);
        Coordinates coordinates4 = coordinates3.scaleC(d2).scaleC(1.0 / Math.max(d, 1.0E-8));
        int n3 = 3 * n;
        dArray[n3] = dArray[n3] + coordinates4.x;
        int n4 = 3 * n + 1;
        dArray[n4] = dArray[n4] + coordinates4.y;
        int n5 = 3 * n + 2;
        dArray[n5] = dArray[n5] + coordinates4.z;
        int n6 = 3 * n2;
        dArray[n6] = dArray[n6] - coordinates4.x;
        int n7 = 3 * n2 + 1;
        dArray[n7] = dArray[n7] - coordinates4.y;
        int n8 = 3 * n2 + 2;
        dArray[n8] = dArray[n8] - coordinates4.z;
        double d3 = d - this.targetValue;
        return 0.5 * FORCE_CONSTANT * d3 * d3;
    }
}

