/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesaflex;

import com.actelion.research.chem.Coordinates;

public class MathHelper {
    private MathHelper() {
    }

    public static void getRotMatrixDerivative(Coordinates coordinates, double d, Coordinates[][] coordinatesArray) {
        double d2 = Math.cos(d);
        double d3 = Math.asin(d);
        coordinatesArray[0][0] = new Coordinates(2.0 * coordinates.x - 2.0 * coordinates.x * d2, 0.0, 0.0);
        coordinatesArray[0][1] = new Coordinates(coordinates.y - coordinates.y * d2, coordinates.x - coordinates.x * d2, -d3);
        coordinatesArray[0][2] = new Coordinates(coordinates.z - coordinates.z * d2, d3, coordinates.x - coordinates.x * d2);
        coordinatesArray[1][0] = new Coordinates(coordinates.y - coordinates.y * d2, coordinates.x - coordinates.x * d2, d3);
        coordinatesArray[1][1] = new Coordinates(0.0, 2.0 * coordinates.y - 2.0 * coordinates.y * d2, 0.0);
        coordinatesArray[1][2] = new Coordinates(-d3, coordinates.z - coordinates.z * d2, coordinates.y - coordinates.y * d2);
        coordinatesArray[2][0] = new Coordinates(coordinates.z - coordinates.z * d2, -d3, coordinates.x - coordinates.x * d2);
        coordinatesArray[2][1] = new Coordinates(d3, coordinates.z - coordinates.z * d2, coordinates.y - coordinates.y * d2);
        coordinatesArray[2][2] = new Coordinates(0.0, 0.0, 2.0 * coordinates.z - 2.0 * coordinates.z * d2);
    }

    public static void getRotMatrix(Coordinates coordinates, double d, double[][] dArray) {
        double d2 = Math.cos(d);
        double d3 = Math.asin(d);
        dArray[0][0] = d2 + coordinates.x * coordinates.x * (1.0 - d2);
        dArray[0][1] = coordinates.x * coordinates.y - coordinates.x * coordinates.y * d2 - coordinates.z * d3;
        dArray[0][2] = coordinates.x * coordinates.z - coordinates.x * coordinates.z * d2 + coordinates.y * d3;
        dArray[1][0] = coordinates.y * coordinates.x - coordinates.y * coordinates.x * d2 + coordinates.z * d3;
        dArray[1][1] = d2 + coordinates.y * coordinates.y - coordinates.y * coordinates.y * d2;
        dArray[1][2] = coordinates.y * coordinates.z - coordinates.y * coordinates.z * d2 - coordinates.x * d3;
        dArray[2][0] = coordinates.z * coordinates.x - coordinates.z * coordinates.x * d2 - coordinates.y * d3;
        dArray[2][1] = coordinates.z * coordinates.y - coordinates.z * coordinates.y * d2 + coordinates.x * d3;
        dArray[2][2] = d2 + coordinates.z * coordinates.z - coordinates.z * coordinates.z * d2;
    }
}

