/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore.pp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;

public class ExitVectorPoint
implements IPharmacophorePoint {
    private int coreAtom;
    private int exitAtom;
    private Coordinates directionality;
    private Coordinates center;
    private int connectionID;

    public ExitVectorPoint(StereoMolecule stereoMolecule, int n, int n2) {
        this.coreAtom = n;
        this.exitAtom = n2;
        this.connectionID = Integer.parseInt(stereoMolecule.getAtomCustomLabel(n2));
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    private ExitVectorPoint(String string, StereoMolecule stereoMolecule) {
        this.decode(string, stereoMolecule);
    }

    public ExitVectorPoint(ExitVectorPoint exitVectorPoint) {
        this.coreAtom = exitVectorPoint.coreAtom;
        this.exitAtom = exitVectorPoint.exitAtom;
        this.directionality = new Coordinates(exitVectorPoint.directionality);
        this.center = new Coordinates(exitVectorPoint.center);
    }

    public static ExitVectorPoint fromString(String string, StereoMolecule stereoMolecule) {
        return new ExitVectorPoint(string, stereoMolecule);
    }

    @Override
    public void updateCoordinates(Coordinates[] coordinatesArray) {
        this.center = new Coordinates(coordinatesArray[this.coreAtom].x, coordinatesArray[this.coreAtom].y, coordinatesArray[this.coreAtom].z);
        this.directionality = coordinatesArray[this.exitAtom].subC(coordinatesArray[this.coreAtom]);
        this.directionality.scale(1.0 / this.directionality.getLength());
    }

    @Override
    public Coordinates getRotatedDirectionality(double[][] dArray, double d) {
        Coordinates coordinates = new Coordinates();
        coordinates.x = this.directionality.x * dArray[0][0] + this.directionality.y * dArray[1][0] + this.directionality.z * dArray[2][0];
        coordinates.y = this.directionality.x * dArray[0][1] + this.directionality.y * dArray[1][1] + this.directionality.z * dArray[2][1];
        coordinates.z = this.directionality.x * dArray[0][2] + this.directionality.y * dArray[1][2] + this.directionality.z * dArray[2][2];
        coordinates.scale(d);
        return coordinates;
    }

    @Override
    public Coordinates getCenter() {
        return this.center;
    }

    @Override
    public Coordinates getDirectionality() {
        return this.directionality;
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("e");
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.coreAtom));
        stringBuilder.append(" ");
        stringBuilder.append(Integer.toString(this.exitAtom));
        return stringBuilder.toString();
    }

    private void decode(String string, StereoMolecule stereoMolecule) {
        String[] stringArray = string.split(" ");
        this.coreAtom = Integer.decode(stringArray[1]);
        this.exitAtom = Integer.decode(stringArray[2]);
        this.connectionID = Integer.parseInt(stereoMolecule.getAtomCustomLabel(this.exitAtom));
        this.updateCoordinates(stereoMolecule.getAtomCoordinates());
    }

    @Override
    public double getSimilarity(IPharmacophorePoint iPharmacophorePoint) {
        if (iPharmacophorePoint instanceof ExitVectorPoint) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public int getCenterID() {
        return this.coreAtom;
    }

    @Override
    public void setCenterID(int n) {
        this.coreAtom = n;
    }

    @Override
    public void setDirectionality(Coordinates coordinates) {
        this.directionality = coordinates;
    }

    @Override
    public void updateAtomIndeces(int[] nArray) {
        this.coreAtom = nArray[this.coreAtom];
        this.exitAtom = nArray[this.exitAtom];
    }

    @Override
    public IPharmacophorePoint copyPharmacophorePoint() {
        return new ExitVectorPoint(this);
    }

    @Override
    public void getDirectionalityDerivativeCartesian(double[] dArray, double[] dArray2, Coordinates coordinates, double d) {
        dArray[3 * this.exitAtom] = d * coordinates.x / 3.0;
        dArray[3 * this.exitAtom + 1] = d * coordinates.y / 3.0;
        dArray[3 * this.exitAtom + 2] = d * coordinates.z / 3.0;
        dArray[3 * this.coreAtom] = d * -coordinates.x / 3.0;
        dArray[3 * this.coreAtom + 1] = d * -coordinates.y / 3.0;
        dArray[3 * this.coreAtom + 2] = d * -coordinates.z / 3.0;
    }

    @Override
    public int getFunctionalityIndex() {
        return IPharmacophorePoint.Functionality.EXIT_VECTOR.getIndex();
    }

    public int getConnectionID() {
        return this.connectionID;
    }
}

