/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.TransformationSequence;
import com.actelion.research.chem.phesa.pharmacophore.PPTriangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PPTriangleMatcher {
    private static final double CUTOFF = 2.0;
    private static final double SCORE_CUTOFF = 0.3;
    private static final double SCORE_CUTOFF_DIREC = 0.6;

    private PPTriangleMatcher() {
    }

    public static List<PheSAAlignmentOptimizer.AlignmentResult> getMatchingTransforms(Map<Integer, ArrayList<PPTriangle>> map, Map<Integer, ArrayList<PPTriangle>> map2, int n, int n2) {
        return PPTriangleMatcher.getMatchingTransforms(map, map2, n, n2, true);
    }

    public static List<PheSAAlignmentOptimizer.AlignmentResult> getMatchingTransforms(Map<Integer, ArrayList<PPTriangle>> map, Map<Integer, ArrayList<PPTriangle>> map2, int n, int n2, boolean bl) {
        double d = 0.3;
        if (!bl) {
            d = 0.6;
        }
        ArrayList<PheSAAlignmentOptimizer.AlignmentResult> arrayList = new ArrayList<PheSAAlignmentOptimizer.AlignmentResult>();
        for (int n3 : map.keySet()) {
            if (!map2.containsKey(n3)) continue;
            List list = map2.get(n3);
            List list2 = map.get(n3);
            for (PPTriangle pPTriangle : list2) {
                for (PPTriangle pPTriangle2 : list) {
                    TransformationSequence transformationSequence;
                    double d2;
                    if (!PPTriangleMatcher.doEdgeLengthsMatch(pPTriangle, pPTriangle2) || !((d2 = pPTriangle.getMatchingTransform(pPTriangle2, transformationSequence = new TransformationSequence(), bl)) > d)) continue;
                    arrayList.add(new PheSAAlignmentOptimizer.AlignmentResult(d2, transformationSequence, n, n2));
                }
            }
        }
        return arrayList;
    }

    private static boolean doEdgeLengthsMatch(PPTriangle pPTriangle, PPTriangle pPTriangle2) {
        double[] dArray;
        double[] dArray2 = pPTriangle.getEdgeLengths();
        return Math.abs(dArray2[0] - (dArray = pPTriangle2.getEdgeLengths())[0]) < 2.0 && Math.abs(dArray2[1] - dArray[1]) < 2.0 && Math.abs(dArray2[2] - dArray[2]) < 2.0;
    }
}

