/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.phesa.pharmacophore.PPTriangle;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.phesa.pharmacophore.pp.PPGaussian;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PPTriangleCreator {
    private static final double SIDE_LENGTH_CUTOFF = 2.5;
    private static final int MAX_TRIANGLES = 1000;

    private PPTriangleCreator() {
    }

    public static Map<Integer, ArrayList<PPTriangle>> create(List<PPGaussian> list, Coordinates coordinates) {
        int n;
        Object object;
        ArrayList<IPharmacophorePoint> arrayList = new ArrayList<IPharmacophorePoint>();
        for (PPGaussian pPGaussian : list) {
            arrayList.add(pPGaussian.getPharmacophorePoint());
        }
        arrayList.sort((iPharmacophorePoint, iPharmacophorePoint2) -> {
            int n = iPharmacophorePoint.getFunctionalityIndex();
            int n2 = iPharmacophorePoint2.getFunctionalityIndex();
            return Integer.compare(n, n2);
        });
        ArrayList arrayList2 = new ArrayList();
        int n2 = arrayList.size();
        double[][] dArray = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            object = (IPharmacophorePoint)arrayList.get(i);
            for (n = i + 1; n < n2; ++n) {
                IPharmacophorePoint iPharmacophorePoint3 = (IPharmacophorePoint)arrayList.get(n);
                dArray[i][n] = object.getCenter().distance(iPharmacophorePoint3.getCenter());
                if (!(dArray[i][n] < 0.01)) continue;
                arrayList2.add(n);
            }
        }
        object = new HashMap();
        n = 0;
        for (int i = 0; i < n2 && n < 1000; ++i) {
            if (arrayList2.contains(i)) continue;
            IPharmacophorePoint iPharmacophorePoint4 = (IPharmacophorePoint)arrayList.get(i);
            for (int j = i + 1; j < n2; ++j) {
                if (arrayList2.contains(j)) continue;
                IPharmacophorePoint iPharmacophorePoint5 = (IPharmacophorePoint)arrayList.get(j);
                for (int k = j + 1; k < n2; ++k) {
                    if (arrayList2.contains(k)) continue;
                    IPharmacophorePoint iPharmacophorePoint6 = (IPharmacophorePoint)arrayList.get(k);
                    double d = dArray[i][j];
                    double d2 = dArray[i][k];
                    double d3 = dArray[j][k];
                    if (d < 2.5 || d2 < 2.5 || d3 < 2.5) continue;
                    PPTriangle pPTriangle = new PPTriangle(iPharmacophorePoint4, iPharmacophorePoint5, iPharmacophorePoint6, d, d2, d3, coordinates);
                    ++n;
                    int n3 = pPTriangle.getHash();
                    if (object.containsKey(n3)) {
                        ((ArrayList)object.get(n3)).add(pPTriangle);
                        continue;
                    }
                    ArrayList<PPTriangle> arrayList3 = new ArrayList<PPTriangle>();
                    arrayList3.add(pPTriangle);
                    object.put(n3, arrayList3);
                }
            }
        }
        return object;
    }
}

