/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.phesa.pharmacophore;

import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.phesa.pharmacophore.pp.ChargePoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ChargedGroupDetector {
    private StereoMolecule mol;
    private List<ArrayList<Integer>> chargedGroups;
    private RingCollection ringCollection;

    public ChargedGroupDetector(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
        this.chargedGroups = new ArrayList<ArrayList<Integer>>();
        this.ringCollection = stereoMolecule.getRingSet();
    }

    public ArrayList<ChargePoint> detect() {
        Object object;
        int n;
        ArrayList<ChargePoint> arrayList = new ArrayList<ChargePoint>();
        for (n = 0; n < this.ringCollection.getSize(); ++n) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n2 = 0;
            object = this.ringCollection.getRingAtoms(n);
            Object object2 = object;
            int n3 = ((int[])object2).length;
            for (int i = 0; i < n3; ++i) {
                Integer n4 = object2[i];
                if (this.alreadyDetected(n4) || this.mol.getAtomicNo(n4) != 7 || !this.mol.isAromaticAtom(n4) || this.mol.getConnAtoms(n4) > 2) continue;
                arrayList2.add(n4);
                n2 += this.mol.getAtomCharge(n4);
            }
            if (arrayList2.size() != 4 || n2 >= 0) continue;
            this.chargedGroups.add(arrayList2);
            object2 = new ChargePoint(this.mol, (Integer)arrayList2.get(0), Arrays.asList((Integer)arrayList2.get(1), (Integer)arrayList2.get(2), (Integer)arrayList2.get(3)), n2);
            arrayList.add((ChargePoint)object2);
        }
        for (n = 0; n < this.mol.getAtoms(); ++n) {
            int n5;
            if (this.alreadyDetected(n)) continue;
            if (this.mol.getAtomicNo(n) == 8) {
                ChargePoint chargePoint;
                if (this.mol.getConnAtoms(n) == 0 || this.alreadyDetected(n5 = this.mol.getConnAtom(n, 0)) || (chargePoint = ChargedGroupDetector.isPartOfChargedAcid(this.mol, n)) == null) continue;
                arrayList.add(chargePoint);
                object = new ArrayList();
                ((ArrayList)object).add(chargePoint.getChargeAtom());
                ((ArrayList)object).addAll(chargePoint.getNeighbours());
                this.chargedGroups.add((ArrayList<Integer>)object);
            } else if (this.mol.getAtomicNo(n) == 7) {
                n5 = -1;
                int n6 = 0;
                object = new ArrayList();
                if (!this.mol.isAromaticAtom(n) && this.mol.getConnAtoms(n) <= 2) {
                    object.add(n);
                    n6 += this.mol.getAtomCharge(n);
                    int n7 = 0;
                    for (int i = 0; i < this.mol.getConnAtoms(n); ++i) {
                        int n8 = this.mol.getConnAtom(n, i);
                        if (this.alreadyDetected(n8) || this.mol.getAtomicNo(n8) != 6) continue;
                        n5 = n8;
                        n6 += this.mol.getAtomCharge(n8);
                        if (this.mol.getBondOrder(this.mol.getBond(n, n8)) == 2) {
                            ++n7;
                        }
                        for (int j = 0; j < this.mol.getConnAtoms(n8); ++j) {
                            int n9 = this.mol.getConnAtom(n8, j);
                            if (this.mol.isAromaticAtom(n9) || n9 == n || this.alreadyDetected(n9) || this.mol.getAtomicNo(n9) != 7 || this.mol.getConnAtoms(n9) > 2) continue;
                            object.add(n9);
                            n6 += this.mol.getAtomCharge(n9);
                            if (this.mol.getBondOrder(this.mol.getBond(n8, n9)) != 2) continue;
                            ++n7;
                        }
                    }
                    if (n7 > 1 && n6 > 0) {
                        ChargePoint chargePoint = new ChargePoint(this.mol, n5, (List<Integer>)object, n6);
                        arrayList.add(chargePoint);
                        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                        arrayList3.add(chargePoint.getChargeAtom());
                        arrayList3.addAll(chargePoint.getNeighbours());
                        this.chargedGroups.add(arrayList3);
                    }
                }
            }
            if (this.alreadyDetected(n) || (n5 = this.mol.getAtomCharge(n)) == 0 || this.hasCounterChargedNeighbour(n)) continue;
            n5 = n5 > 0 ? 1 : -1;
            ChargePoint chargePoint = new ChargePoint(this.mol, n, new ArrayList<Integer>(), n5);
            arrayList.add(chargePoint);
            object = new ArrayList();
            ((ArrayList)object).add(n);
            this.chargedGroups.add((ArrayList<Integer>)object);
        }
        return arrayList;
    }

    public List<ArrayList<Integer>> getChargedGroups() {
        return this.chargedGroups;
    }

    private boolean hasCounterChargedNeighbour(int n) {
        for (int i = 0; i < this.mol.getConnAtoms(n); ++i) {
            if (this.mol.getAtomCharge(n) * this.mol.getAtomCharge(this.mol.getConnAtom(n, i)) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean alreadyDetected(int n) {
        boolean bl = this.chargedGroups.stream().flatMap(Collection::stream).collect(Collectors.toList()).contains(n);
        return bl;
    }

    private static ChargePoint isPartOfChargedAcid(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.getConnAtoms(n) != 1 || stereoMolecule.getConnBondOrder(n, 0) != 1) {
            return null;
        }
        int n2 = stereoMolecule.getConnAtom(n, 0);
        if (stereoMolecule.getAtomicNo(n2) == 6) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            int n3 = 0;
            n3 += stereoMolecule.getAtomCharge(n);
            n3 += stereoMolecule.getAtomCharge(n2);
            int n4 = stereoMolecule.getConnAtoms(n2);
            for (int i = 0; i < n4; ++i) {
                int n5 = stereoMolecule.getConnAtom(n2, i);
                if (n5 == n || stereoMolecule.getAtomicNo(n5) != 8) continue;
                n3 += stereoMolecule.getAtomCharge(n5);
                arrayList.add(n5);
            }
            if (n3 < 0) {
                ChargePoint chargePoint = new ChargePoint(stereoMolecule, n2, arrayList, n3);
                return chargePoint;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 16) {
            int n6 = stereoMolecule.getConnAtoms(n2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            int n7 = 0;
            n7 += stereoMolecule.getAtomCharge(n);
            n7 += stereoMolecule.getAtomCharge(n2);
            for (int i = 0; i < n6; ++i) {
                int n8 = stereoMolecule.getConnAtom(n2, i);
                if (n8 == n || stereoMolecule.getAtomicNo(n8) != 8) continue;
                n7 += stereoMolecule.getAtomCharge(n8);
                arrayList.add(n8);
            }
            if (n7 < 0) {
                ChargePoint chargePoint = new ChargePoint(stereoMolecule, n2, arrayList, n7);
                return chargePoint;
            }
        } else if (stereoMolecule.getAtomicNo(n2) == 15) {
            int n9 = stereoMolecule.getConnAtoms(n2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            int n10 = 0;
            n10 += stereoMolecule.getAtomCharge(n);
            n10 += stereoMolecule.getAtomCharge(n2);
            for (int i = 0; i < n9; ++i) {
                int n11 = stereoMolecule.getConnAtom(n2, i);
                if (n11 == n || stereoMolecule.getAtomicNo(n11) != 8) continue;
                n10 += stereoMolecule.getAtomCharge(n11);
                arrayList.add(n11);
            }
            if (n10 < 0) {
                ChargePoint chargePoint = new ChargePoint(stereoMolecule, n2, arrayList, n10);
                return chargePoint;
            }
        }
        return null;
    }
}

