/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.optimization;

import com.actelion.research.chem.optimization.Evaluable;
import com.actelion.research.chem.optimization.Lnsrch;
import java.util.Arrays;

public class OptimizerLBFGS {
    int maxIterations;
    double minRMS;

    public OptimizerLBFGS(int n, double d) {
        this.maxIterations = n;
        this.minRMS = d;
    }

    public synchronized double[] optimize(Evaluable evaluable) {
        double d;
        int n;
        double[] dArray = evaluable.getState();
        int n2 = n = dArray.length;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double d2 = 1.0;
        int n3 = 0;
        int n4 = 0;
        double[] dArray4 = new double[n];
        double d3 = d = evaluable.getFGValue(dArray4);
        double d4 = d;
        double d5 = 0.0;
        if (n == 0) {
            return evaluable.getState();
        }
        double[] dArray5 = dArray;
        double[] dArray6 = new double[n];
        double[][] dArray7 = new double[n2][n];
        double[][] dArray8 = new double[n2][n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n];
        boolean bl = true;
        int n5 = 0;
        for (int i = 1; i <= this.maxIterations; ++i) {
            int n6;
            double d6;
            double d7;
            if (bl) {
                n5 = 0;
                d = evaluable.getFGValue(dArray4);
                d2 = 1.0;
                d5 = 0.25 * OptimizerLBFGS.getNorm(dArray4);
                bl = false;
            }
            if ((d7 = (d6 = OptimizerLBFGS.getNorm(dArray4)) / Math.sqrt(n)) < this.minRMS || n4 > 2) break;
            n3 = (n3 + 1) % n2;
            Arrays.fill(dArray9, d2);
            System.arraycopy(dArray4, 0, dArray10, 0, n);
            int n7 = n3;
            for (n6 = 0; n6 < n5; ++n6) {
                int n8;
                n7 = n7 == 0 ? n2 - 1 : n7 - 1;
                dArray2[n7] = 0.0;
                for (n8 = 0; n8 < n; ++n8) {
                    int n9 = n7;
                    dArray2[n9] = dArray2[n9] + dArray7[n7][n8] * dArray10[n8];
                }
                int n10 = n7;
                dArray2[n10] = dArray2[n10] * dArray3[n7];
                for (n8 = 0; n8 < n; ++n8) {
                    int n11 = n8;
                    dArray10[n11] = dArray10[n11] - dArray8[n7][n8] * dArray2[n7];
                }
            }
            for (n6 = 0; n6 < n; ++n6) {
                dArray11[n6] = dArray9[n6] * dArray10[n6];
            }
            for (n6 = 0; n6 < n5; ++n6) {
                int n12;
                double d8 = 0.0;
                for (n12 = 0; n12 < n; ++n12) {
                    d8 += dArray8[n7][n12] * dArray11[n12];
                }
                d8 *= dArray3[n7];
                for (n12 = 0; n12 < n; ++n12) {
                    int n13 = n12;
                    dArray11[n13] = dArray11[n13] + dArray7[n7][n12] * (dArray2[n7] - d8);
                }
                n7 = (n7 + 1) % n2;
            }
            for (n6 = 0; n6 < n; ++n6) {
                dArray11[n6] = -dArray11[n6];
            }
            dArray5 = evaluable.getState();
            System.arraycopy(dArray4, 0, dArray6, 0, n);
            Object[] objectArray = Lnsrch.minimizeEnergyAroundDirection(evaluable, d, dArray4, dArray11, d5);
            d = (Double)objectArray[0];
            dArray4 = (double[])objectArray[1];
            if (objectArray[2] == Boolean.FALSE) {
                ++n4;
                bl = true;
            }
            double d9 = 0.0;
            double d10 = 0.0;
            double[] dArray12 = evaluable.getState();
            for (int j = 0; j < n; ++j) {
                dArray7[n3][j] = dArray12[j] - dArray5[j];
                dArray8[n3][j] = dArray4[j] - dArray6[j];
                d9 += dArray8[n3][j] * dArray7[n3][j];
                d10 += dArray8[n3][j] * dArray8[n3][j];
            }
            d2 = Math.abs(d9 / d10);
            if (d9 == 0.0) {
                bl = true;
                continue;
            }
            dArray3[n3] = 1.0 / d9;
            d5 = d3 - d;
            d3 = d;
            n5 = Math.min(n5 + 1, n2);
        }
        if (d > d4) {
            evaluable.setState(dArray);
            d = d4;
        }
        return evaluable.getState();
    }

    public static final double getRMS(double[] dArray) {
        return Math.sqrt(OptimizerLBFGS.getNormSq(dArray) / (double)dArray.length);
    }

    public static double getNorm(double[] dArray) {
        return Math.sqrt(OptimizerLBFGS.getNormSq(dArray));
    }

    public static final double getNormSq(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }
}

