/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.moreparsers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;

public class CDX2CDXML {
    private Stack<String> objects = new Stack();
    private StringBuffer sb = new StringBuffer();
    private int sbpt;
    private ByteBuffer buf;
    private static final String[] cdxAttributes = new String[]{"HashSpacing", "2.50", "MarginWidth", "1.60", "LineWidth", "0.60", "BoldWidth", "2", "BondLength", "14.40", "BondSpacing", "18"};
    private static final int kCDXProp_ChemicalWarning = 16;
    private static final int kCDXProp_2DPosition = 512;
    private static final int kCDXProp_Node_Type = 1024;
    private static final int kCDXProp_Node_Element = 1026;
    private static final int kCDXProp_Atom_Isotope = 1056;
    private static final int kCDXProp_Atom_Charge = 1057;
    private static final int kCDXProp_Atom_BondOrdering = 1073;
    private static final int kCDXProp_Node_Attachments = 1074;
    private static final int kCDXProp_Atom_GenericNickname = 1075;
    private static final int kCDXProp_Frag_ConnectionOrder = 1285;
    private static final int kCDXProp_Bond_Order = 1536;
    private static final int kCDXProp_Bond_Display = 1537;
    private static final int kCDXProp_Bond_Display2 = 1538;
    private static final int kCDXProp_Bond_Begin = 1540;
    private static final int kCDXProp_Bond_End = 1541;
    private static final int kCDXProp_Bond_BeginAttach = 1544;
    private static final int kCDXProp_Bond_EndAttach = 1545;
    private static final int kCDXProp_Text = 1792;
    private static final int kCDXProp_Bracket_Usage = 2596;
    private static final int kCDXProp_BracketedObjects = 2599;
    private static final int kCDXProp_Bracket_RepeatCount = 2600;
    private static final int kCDXProp_Bracket_BondID = 2604;
    private static final int kCDXProp_Bracket_InnerAtomID = 2605;
    private static final int kCDXObj_Document = 32768;
    private static final int kCDXObj_Page = 32769;
    private static final int kCDXObj_Group = 32770;
    private static final int kCDXObj_Fragment = 32771;
    private static final int kCDXObj_Node = 32772;
    private static final int kCDXObj_Bond = 32773;
    private static final int kCDXObj_Text = 32774;
    private static final int kCDXObj_BracketedGroup = 32791;
    private static final int kCDXObj_BracketAttachment = 32792;
    private static final int kCDXObj_CrossingBond = 32793;
    private static final int kCDXNodeType_Unspecified = 0;
    private static final int kCDXNodeType_Element = 1;
    private static final int kCDXNodeType_ElementList = 2;
    private static final int kCDXNodeType_ElementListNickname = 3;
    private static final int kCDXNodeType_Nickname = 4;
    private static final int kCDXNodeType_Fragment = 5;
    private static final int kCDXNodeType_Formula = 6;
    private static final int kCDXNodeType_GenericNickname = 7;
    private static final int kCDXNodeType_AnonymousAlternativeGroup = 8;
    private static final int kCDXNodeType_NamedAlternativeGroup = 9;
    private static final int kCDXNodeType_MultiAttachment = 10;
    private static final int kCDXNodeType_VariableAttachment = 11;
    private static final int kCDXNodeType_ExternalConnectionPoint = 12;
    private static final int kCDXNodeType_LinkNode = 13;
    private static final int kCDXBondOrder_Single = 1;
    private static final int kCDXBondOrder_Double = 2;
    private static final int kCDXBondOrder_Triple = 4;
    private static final int kCDXBondOrder_Quadruple = 8;
    private static final int kCDXBondOrder_Quintuple = 16;
    private static final int kCDXBondOrder_Sextuple = 32;
    private static final int kCDXBondOrder_Half = 64;
    private static final int kCDXBondOrder_OneHalf = 128;
    private static final int kCDXBondOrder_TwoHalf = 256;
    private static final int kCDXBondOrder_ThreeHalf = 512;
    private static final int kCDXBondOrder_FourHalf = 1024;
    private static final int kCDXBondOrder_FiveHalf = 2048;
    private static final int kCDXBondOrder_Dative = 4096;
    private static final int kCDXBondOrder_Ionic = 8192;
    private static final int kCDXBondOrder_Hydrogen = 16384;
    private static final int kCDXBondOrder_ThreeCenter = 32768;
    private static final int kCDXBondDisplay_Solid = 0;
    private static final int kCDXBondDisplay_Dash = 1;
    private static final int kCDXBondDisplay_Hash = 2;
    private static final int kCDXBondDisplay_WedgedHashBegin = 3;
    private static final int kCDXBondDisplay_WedgedHashEnd = 4;
    private static final int kCDXBondDisplay_Bold = 5;
    private static final int kCDXBondDisplay_WedgeBegin = 6;
    private static final int kCDXBondDisplay_WedgeEnd = 7;
    private static final int kCDXBondDisplay_Wavy = 8;
    private static final int kCDXBondDisplay_HollowWedgeBegin = 9;
    private static final int kCDXBondDisplay_HollowWedgeEnd = 10;
    private static final int kCDXBondDisplay_WavyWedgeBegin = 11;
    private static final int kCDXBondDisplay_WavyWedgeEnd = 12;
    private static final int kCDXBondDisplay_Dot = 13;
    private static final int kCDXBondDisplay_DashDot = 14;
    private static final String escapable = "\\\\\tt\rr\nn\"\"";

    public static String fromCDX(byte[] byArray) throws Exception {
        return new CDX2CDXML().cdxToCdxml(byArray);
    }

    private String cdxToCdxml(byte[] byArray) throws Exception {
        this.buf = ByteBuffer.wrap(byArray);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        try {
            CDX2CDXML.openDocument(this.sb);
            CDX2CDXML.appendHeader(this.sb);
            this.buf.position(22);
            this.processObject(this.buf.getShort());
            this.sb.append("</CDXML>\n");
        }
        catch (Exception exception) {
            System.out.println(this.sb + "\n" + this.objects);
            exception.printStackTrace();
            return null;
        }
        return this.sb.toString();
    }

    private static void appendHeader(StringBuffer stringBuffer) {
        stringBuffer.append("<!DOCTYPE CDXML SYSTEM \"http://www.cambridgesoft.com/xml/cdxml.dtd\" >\n");
        CDX2CDXML.startOpenTag(stringBuffer, "CDXML");
        CDX2CDXML.addAttributes(stringBuffer, cdxAttributes);
        CDX2CDXML.terminateTag(stringBuffer);
    }

    private void processObject(int n) throws Exception {
        short s;
        int n2 = this.buf.getInt();
        boolean bl = false;
        String string = null;
        switch (n &= 0xFFFF) {
            default: {
                n2 = Integer.MIN_VALUE;
                bl = true;
                break;
            }
            case 32769: {
                string = "page";
                n2 = Integer.MIN_VALUE;
                break;
            }
            case 32771: {
                string = "fragment";
                break;
            }
            case 32772: {
                string = "n";
                break;
            }
            case 32773: {
                string = "b";
                break;
            }
            case 32774: {
                string = "t";
                n2 = Integer.MIN_VALUE;
                break;
            }
            case 32791: {
                string = "bracketedgroup";
                break;
            }
            case 32792: {
                string = "bracketattachment";
                break;
            }
            case 32793: {
                string = "crossingbond";
            }
        }
        this.sbpt = this.sb.length();
        this.objects.push(string);
        if (string != null) {
            CDX2CDXML.startOpenTag(this.sb, string);
            if (n2 != Integer.MIN_VALUE) {
                CDX2CDXML.addAttribute(this.sb, "id", "" + n2);
            }
        }
        block17: while ((s = this.buf.getShort()) != 0) {
            if ((s & 0x8000) != 0) {
                if (!bl) {
                    CDX2CDXML.terminateTag(this.sb);
                    bl = true;
                }
                this.processObject(s);
                continue;
            }
            int n3 = this.readLength();
            switch (n) {
                case 32772: {
                    this.writeNodeProperties(s, n3);
                    continue block17;
                }
                case 32774: {
                    if (!bl) {
                        CDX2CDXML.terminateTag(this.sb);
                        bl = true;
                    }
                    this.writeTextProperty(s, n3);
                    continue block17;
                }
                case 32773: {
                    this.writeBondProperties(s, n3);
                    continue block17;
                }
                case 32791: {
                    this.writeBracketedGroupProperties(s, n3);
                    continue block17;
                }
                case 32793: {
                    this.writeCrossingBondProperties(s, n3);
                    continue block17;
                }
            }
            this.skip(n3);
        }
        if (string != null) {
            if (!bl) {
                CDX2CDXML.terminateEmptyTag(this.sb);
            } else {
                CDX2CDXML.closeTag(this.sb, string);
            }
        }
    }

    private void writeBracketedGroupProperties(int n, int n2) throws Exception {
        switch (n) {
            case 2599: {
                CDX2CDXML.addAttribute(this.sb, "BracketedObjectIDs", this.readArray(n2));
                break;
            }
            case 2600: {
                CDX2CDXML.addAttribute(this.sb, "RepeatCount", "" + (int)this.readFloat64());
                break;
            }
            case 2596: {
                int n3 = this.readInt(n2);
                String string = null;
                switch (n3) {
                    case 16: {
                        string = "MultipleGroup";
                        break;
                    }
                    default: {
                        this.removeObject();
                        return;
                    }
                }
                CDX2CDXML.addAttribute(this.sb, "BracketUsage", string);
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private void writeCrossingBondProperties(int n, int n2) throws Exception {
        switch (n) {
            case 2604: {
                CDX2CDXML.addAttribute(this.sb, "BondID", "" + this.readInt(n2));
                break;
            }
            case 2605: {
                CDX2CDXML.addAttribute(this.sb, "InnerAtomID", "" + this.readInt(n2));
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private void writeNodeProperties(int n, int n2) throws Exception {
        switch (n) {
            case 512: {
                double d = CDX2CDXML.toPoint(this.readInt(n2 >> 1));
                double d2 = CDX2CDXML.toPoint(this.readInt(n2 >> 1));
                CDX2CDXML.addAttribute(this.sb, "p", d2 + " " + d);
                break;
            }
            case 1024: {
                String string = CDX2CDXML.getNodeType(this.readInt(n2));
                CDX2CDXML.addAttribute(this.sb, "NodeType", string);
                break;
            }
            case 1026: {
                CDX2CDXML.addAttribute(this.sb, "Element", "" + this.readInt(n2));
                break;
            }
            case 1056: {
                CDX2CDXML.addAttribute(this.sb, "Isotope", "" + this.readInt(n2));
                break;
            }
            case 1057: {
                CDX2CDXML.addAttribute(this.sb, "Charge", "" + this.readInt(n2));
                break;
            }
            case 16: {
                CDX2CDXML.addAttribute(this.sb, "Warning", this.readString(n2));
                break;
            }
            case 1073: {
                CDX2CDXML.addAttribute(this.sb, "BondOrdering", this.readArray(n2));
                break;
            }
            case 1285: {
                CDX2CDXML.addAttribute(this.sb, "ConnectionOrder", this.readArray(n2));
                break;
            }
            case 1074: {
                CDX2CDXML.addAttribute(this.sb, "Attachments", this.readArray(-1));
                break;
            }
            case 1075: {
                CDX2CDXML.addAttribute(this.sb, "GenericNickname", this.readString(n2));
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private void writeBondProperties(int n, int n2) throws Exception {
        switch (n) {
            case 1536: {
                String string = CDX2CDXML.getBondOrder(this.readInt(n2));
                if (string == null) {
                    this.removeObject();
                    return;
                }
                CDX2CDXML.addAttribute(this.sb, "Order", string);
                break;
            }
            case 1537: {
                String string = CDX2CDXML.getBondDisplay(this.readInt(n2));
                if (string == null) {
                    this.removeObject();
                    return;
                }
                CDX2CDXML.addAttribute(this.sb, "Display", string);
                break;
            }
            case 1538: {
                String string = CDX2CDXML.getBondDisplay(this.readInt(n2));
                if (string == null) break;
                CDX2CDXML.addAttribute(this.sb, "Display2", string);
                break;
            }
            case 1540: {
                CDX2CDXML.addAttribute(this.sb, "B", "" + this.readInt(n2));
                break;
            }
            case 1541: {
                CDX2CDXML.addAttribute(this.sb, "E", "" + this.readInt(n2));
                break;
            }
            case 1544: {
                CDX2CDXML.addAttribute(this.sb, "BeginAttach", "" + this.readInt(n2));
                break;
            }
            case 1545: {
                CDX2CDXML.addAttribute(this.sb, "EndAttach", "" + this.readInt(n2));
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    private void writeTextProperty(int n, int n2) throws Exception {
        switch (n) {
            case 1792: {
                String string = this.readString(n2);
                System.out.println("CDXMLW text=" + string);
                CDX2CDXML.openTag(this.sb, "s");
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(CDX2CDXML.wrapCData(string));
                CDX2CDXML.closeTag(this.sb, "s");
                break;
            }
            default: {
                this.skip(n2);
            }
        }
    }

    public static String wrapCData(String string) {
        return string.indexOf("&") < 0 && string.indexOf("<") < 0 ? string : "<![CDATA[" + string.replace("]]>", "]]]]><![CDATA[>") + "]]>";
    }

    private static String getNodeType(int n) {
        String string = null;
        switch (n) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Element";
            }
            case 4: {
                return "Nickname";
            }
            case 5: {
                return "Fragment";
            }
            case 7: {
                return "GenericNickname";
            }
            case 10: {
                return "MultiAttachment";
            }
            case 11: {
                return "VariableAttachment";
            }
            case 12: {
                return "ExternalConnectionPoint";
            }
            case 2: {
                string = "ElementList";
                break;
            }
            case 3: {
                string = "ElementListNickname";
                break;
            }
            case 6: {
                string = "Formula";
                break;
            }
            case 8: {
                string = "AnonymousAlternativeGroup";
                break;
            }
            case 9: {
                string = "NamedAnonymousGroup";
                break;
            }
            case 13: {
                string = "LinkNode";
            }
        }
        System.err.println("CDXMLWriter Node type " + string + " not identified");
        return "_";
    }

    private static String getBondDisplay(int n) {
        switch (n) {
            case 0: {
                return "Solid";
            }
            case 1: {
                return "Dash";
            }
            case 2: {
                return "Hash";
            }
            case 3: {
                return "WedgedHashBegin";
            }
            case 4: {
                return "WedgedHashEnd";
            }
            case 5: {
                return "Bold";
            }
            case 6: {
                return "WedgeBegin";
            }
            case 7: {
                return "WedgeEnd";
            }
            case 8: {
                return "Wavy";
            }
            case 9: {
                return "HollowWedgeBegin";
            }
            case 10: {
                return "HollowWedgeEnd";
            }
            case 11: {
                return "WavyWedgeBegin";
            }
            case 12: {
                return "WavyWedgeEnd";
            }
            case 13: {
                return "Dot";
            }
            case 14: {
                return "DashDot";
            }
        }
        return null;
    }

    private static String getBondOrder(int n) {
        switch (n) {
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 4: {
                return "3";
            }
            case 8: {
                return "4";
            }
            case 16: {
                return "5";
            }
            case 32: {
                return "6";
            }
            case 64: {
                return "0.5";
            }
            case 128: {
                return "1.5";
            }
            case 256: {
                return "2.5";
            }
            case 512: {
                return "3.5";
            }
            case 1024: {
                return "4.5";
            }
            case 2048: {
                return "5.5";
            }
            case 4096: {
                return "dative";
            }
            case 8192: {
                return "ionic";
            }
            case 16384: {
                return "hydrogen";
            }
            case 32768: {
                return "threecenter";
            }
        }
        return null;
    }

    private void removeObject() {
        this.sb.setLength(this.sbpt);
    }

    private void skip(int n) {
        this.buf.position(this.buf.position() + n);
    }

    private double readFloat64() throws Exception {
        return this.buf.getDouble();
    }

    private int readInt(int n) throws Exception {
        switch (n) {
            case 1: {
                return (256 + this.buf.get()) % 256;
            }
            case 2: {
                return this.buf.getShort();
            }
            case 4: {
                return this.buf.getInt();
            }
            case 8: {
                return (int)this.buf.getLong();
            }
        }
        System.err.println("CDXMLWriter.readInt len " + n);
        return 0;
    }

    private String readString(int n) throws Exception {
        short s = this.buf.getShort();
        n -= 2;
        switch (s) {
            case 0: {
                break;
            }
            default: {
                this.skip(s * 10);
                n -= s * 10;
            }
        }
        byte[] byArray = new byte[n];
        this.buf.get(byArray, 0, n);
        return new String(byArray, 0, n, "UTF-8");
    }

    private String readArray(int n) throws Exception {
        int n2 = n < 0 ? this.buf.getShort() : n / 4;
        String string = "";
        int n3 = n2;
        while (--n3 >= 0) {
            string = string + " " + this.buf.getInt();
        }
        return string.trim();
    }

    private int readLength() throws Exception {
        int n = this.buf.getShort();
        if (n == -1) {
            n = this.buf.getInt();
        }
        return n;
    }

    private static double toPoint(int n) {
        return (double)Math.round((double)n / 655.36) / 100.0;
    }

    public static void main(String[] stringArray) {
    }

    public static void openDocument(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
    }

    protected static void openTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<").append(string).append(">\n");
    }

    protected static void startOpenTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<").append(string);
    }

    protected static void terminateTag(StringBuffer stringBuffer) {
        stringBuffer.append(">\n");
    }

    protected static void terminateEmptyTag(StringBuffer stringBuffer) {
        stringBuffer.append("/>\n");
    }

    protected static void appendEmptyTag(StringBuffer stringBuffer, String string, String[] stringArray) {
        CDX2CDXML.startOpenTag(stringBuffer, string);
        CDX2CDXML.addAttributes(stringBuffer, stringArray);
        CDX2CDXML.terminateEmptyTag(stringBuffer);
    }

    protected static void addAttributes(StringBuffer stringBuffer, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            CDX2CDXML.addAttribute(stringBuffer, stringArray[i], stringArray[++i]);
        }
    }

    protected static void addAttribute(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(" ").append(string).append("=").append(CDX2CDXML.esc(string2));
    }

    protected static void closeTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append("</").append(string).append(">\n");
    }

    public static String esc(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        boolean bl = false;
        for (n = 0; n < escapable.length(); n += 2) {
            if (string.indexOf(escapable.charAt(n)) < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n < escapable.length()) {
                int n2 = -1;
                char c = escapable.charAt(n++);
                char c2 = escapable.charAt(n++);
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                while ((n2 = string.indexOf(c, n2 + 1)) >= 0) {
                    stringBuffer.append(string.substring(n3, n2)).append('\\').append(c2);
                    n3 = n2 + 1;
                }
                stringBuffer.append(string.substring(n3, string.length()));
                string = stringBuffer.toString();
            }
        }
        return "\"" + CDX2CDXML.escUnicode(string) + "\"";
    }

    public static String escUnicode(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) <= '\u007f') continue;
            String string2 = "0000" + Integer.toHexString(string.charAt(n));
            string = string.substring(0, n) + "\\u" + string2.substring(string2.length() - 4) + string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        return this.sb.toString();
    }
}

