/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.BondVector2IdCode;
import com.actelion.research.chem.properties.complexity.FragmentDefinedByBondsIdCode;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.util.Pipeline;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RunBondVector2IdCode
implements Runnable {
    private static final long SLEEP = 10L;
    private int id;
    private Pipeline<IBitArray> pipeInputFragIndexListsFromEFG;
    private Pipeline<FragmentDefinedByBondsIdCode> pipeOutputFragmentDefinedByBondsIdCode;
    private AtomicBoolean endOfRunReached;
    private BondVector2IdCode bondVector2IdCode;
    private AtomicInteger processedFragments;

    public RunBondVector2IdCode(int n, Pipeline<IBitArray> pipeline, Pipeline<FragmentDefinedByBondsIdCode> pipeline2) {
        this.id = n;
        this.pipeInputFragIndexListsFromEFG = pipeline;
        this.pipeOutputFragmentDefinedByBondsIdCode = pipeline2;
        this.endOfRunReached = new AtomicBoolean(false);
    }

    public void init(StereoMolecule stereoMolecule) {
        StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule);
        stereoMolecule2.ensureHelperArrays(31);
        this.bondVector2IdCode = new BondVector2IdCode(stereoMolecule2);
        this.processedFragments = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.pipeInputFragIndexListsFromEFG.wereAllDataFetched()) {
                IBitArray iBitArray = this.pipeInputFragIndexListsFromEFG.pollData();
                if (iBitArray == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                try {
                    FragmentDefinedByBondsIdCode fragmentDefinedByBondsIdCode = new FragmentDefinedByBondsIdCode(iBitArray);
                    String string = this.bondVector2IdCode.getFragmentIdCode(iBitArray);
                    fragmentDefinedByBondsIdCode.setIdCode(string);
                    this.pipeOutputFragmentDefinedByBondsIdCode.addData(fragmentDefinedByBondsIdCode);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.processedFragments.incrementAndGet();
                }
            }
        }
        finally {
            this.endOfRunReached.set(true);
        }
    }

    public boolean isEndOfRunReached() {
        return this.endOfRunReached.get();
    }
}

