/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.mcs.BondVector2IdCode;
import com.actelion.research.chem.mcs.ExhaustiveFragmentGeneratorBonds;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.chem.shredder.Fragment;
import com.actelion.research.util.Pipeline;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class ExhaustiveFragmentGeneratorParallizer {
    private static final int CAPACITY = 10000;
    public static final int TOTAL_CAPACITY = (int)(10.0 * Math.pow(10.0, 6.0));
    private static final int OFFSET_FRAG_SIZE = 24;
    private Pipeline<StereoMolecule> queuePipe;
    private List<ConcurrentHashMap<String, Fragment>> liHashMapIdCode_Fragment;
    private AtomicInteger ccProcessedRecords;
    private AtomicInteger ccMoleculeToLarge;
    private int nCores;
    private int bits;

    public ExhaustiveFragmentGeneratorParallizer(int n) {
        this.bits = n;
        this.liHashMapIdCode_Fragment = new ArrayList<ConcurrentHashMap<String, Fragment>>();
        this.ccProcessedRecords = new AtomicInteger();
        this.ccMoleculeToLarge = new AtomicInteger();
        this.nCores = Runtime.getRuntime().availableProcessors();
        if (this.nCores > 1) {
            --this.nCores;
        }
    }

    public void process(Pipeline<StereoMolecule> pipeline, int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        for (ConcurrentHashMap<String, Fragment> concurrentHashMap : this.liHashMapIdCode_Fragment) {
            concurrentHashMap.clear();
        }
        int n4 = n + 24 + 1;
        for (n3 = this.liHashMapIdCode_Fragment.size(); n3 < n4; ++n3) {
            if (n3 < 4) {
                this.liHashMapIdCode_Fragment.add(new ConcurrentHashMap());
                continue;
            }
            this.liHashMapIdCode_Fragment.add(new ConcurrentHashMap(10000));
        }
        this.queuePipe = pipeline;
        this.ccProcessedRecords.set(0);
        n3 = Runtime.getRuntime().availableProcessors();
        int n5 = n3 - 1;
        if (n5 == 0) {
            n5 = 1;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n5);
        ArrayList<RunEFG> arrayList = new ArrayList<RunEFG>();
        for (n2 = 0; n2 < n5; ++n2) {
            Iterator<ConcurrentHashMap<String, Fragment>> iterator = new RunEFG(this.bits, n, bl, bl2);
            executorService.execute((Runnable)((Object)iterator));
            arrayList.add((RunEFG)((Object)iterator));
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.out.println(" Processed records " + this.ccProcessedRecords.get() + ".");
            System.out.println(" Molecules still in pipeline " + pipeline.sizePipe() + ".");
            n2 = 0;
            for (ConcurrentHashMap<String, Fragment> concurrentHashMap : this.liHashMapIdCode_Fragment) {
                n2 += concurrentHashMap.size();
            }
            System.out.println(" Unique fragments " + n2 + ".");
        }
        System.out.println(" Processed records " + this.ccProcessedRecords.get() + ".");
        System.out.println(" Molecules still in pipeline " + pipeline.sizePipe() + ".");
        n2 = 0;
        for (ConcurrentHashMap<String, Fragment> concurrentHashMap : this.liHashMapIdCode_Fragment) {
            n2 += concurrentHashMap.size();
        }
        System.out.println(" Unique fragments " + n2 + ".");
        System.out.println("Finished all " + new Date().toString());
    }

    public List<Fragment> getFragmentList() {
        ArrayList<Fragment> arrayList = new ArrayList<Fragment>();
        for (ConcurrentHashMap<String, Fragment> concurrentHashMap : this.liHashMapIdCode_Fragment) {
            arrayList.addAll(concurrentHashMap.values());
        }
        return arrayList;
    }

    class RunEFG
    implements Runnable {
        private int maxSizeFrag;
        private boolean addWildcards;
        private boolean cleaveRingBonds;
        private HashSet<String> hsIdCode;
        private ExhaustiveFragmentGeneratorBonds efg;

        public RunEFG(int n, int n2, boolean bl, boolean bl2) {
            this.maxSizeFrag = n2;
            this.addWildcards = bl2;
            this.cleaveRingBonds = bl;
            this.hsIdCode = new HashSet();
            this.efg = new ExhaustiveFragmentGeneratorBonds(n, TOTAL_CAPACITY);
        }

        @Override
        public void run() {
            while (!ExhaustiveFragmentGeneratorParallizer.this.queuePipe.wereAllDataFetched()) {
                StereoMolecule stereoMolecule = (StereoMolecule)ExhaustiveFragmentGeneratorParallizer.this.queuePipe.pollData();
                if (stereoMolecule == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                if (stereoMolecule.getBonds() <= ExhaustiveFragmentGeneratorParallizer.this.bits) {
                    try {
                        this.process(stereoMolecule);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    ExhaustiveFragmentGeneratorParallizer.this.ccMoleculeToLarge.incrementAndGet();
                }
                ExhaustiveFragmentGeneratorParallizer.this.ccProcessedRecords.incrementAndGet();
            }
        }

        public void process(StereoMolecule stereoMolecule) {
            this.hsIdCode.clear();
            BondVector2IdCode bondVector2IdCode = new BondVector2IdCode(stereoMolecule);
            this.efg.set(stereoMolecule, this.maxSizeFrag);
            this.efg.generateFragmentsAllBonds();
            int n = stereoMolecule.getBonds();
            int n2 = Math.min(n, this.maxSizeFrag + 1);
            for (int i = 0; i < n2; ++i) {
                List<IBitArray> list = this.efg.getFragments(i);
                for (IBitArray iBitArray : list) {
                    Object object;
                    if (!this.cleaveRingBonds && bondVector2IdCode.containsFragmentOpenRing(iBitArray)) continue;
                    int n3 = iBitArray.getBitsSet();
                    Fragment fragment = bondVector2IdCode.getFragment(iBitArray, this.addWildcards);
                    if (fragment.getMol().getBonds() >= ExhaustiveFragmentGeneratorParallizer.this.liHashMapIdCode_Fragment.size()) {
                        object = new Canonizer(fragment.getMol());
                        System.out.println("ExhaustiveFragmentGeneratorParallizer RunEFG bonds fragment " + n3);
                        System.out.println("ExhaustiveFragmentGeneratorParallizer RunEFG bonds fragment with wildcards " + fragment.getMol().getBonds());
                        System.out.println(((Canonizer)object).getIDCode());
                        continue;
                    }
                    object = (ConcurrentHashMap)ExhaustiveFragmentGeneratorParallizer.this.liHashMapIdCode_Fragment.get(fragment.getMol().getBonds());
                    if (!((ConcurrentHashMap)object).containsKey(fragment.getIdcode())) {
                        fragment.setFrequencySumAll(0);
                        ((ConcurrentHashMap)object).put(fragment.getIdcode(), fragment);
                    }
                    Fragment fragment2 = (Fragment)((ConcurrentHashMap)object).get(fragment.getIdcode());
                    fragment2.incrementFrequencySumAll();
                    if (!this.hsIdCode.add(fragment2.getIdcode())) continue;
                    fragment2.incrementFrequencyOnePerMol();
                }
            }
        }
    }
}

