/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.mcs.ListWithIntVec;
import com.actelion.research.util.datamodel.IntArray;
import java.util.ArrayList;
import java.util.List;

public class ContainerListWithIntVec {
    private static int CAPACITY_ADD = 1024;
    private List<ListWithIntVec> li;
    private int sizeVector;
    private IntArray arrAvailable;

    public ContainerListWithIntVec(int n, int n2) {
        this.sizeVector = n;
        this.arrAvailable = new IntArray(n2);
        this.li = new ArrayList<ListWithIntVec>(n2);
        this.initResources(n2);
    }

    public void reset() {
        this.arrAvailable.reset();
        for (int i = 0; i < this.li.size(); ++i) {
            this.arrAvailable.add(i);
        }
    }

    private void initResources(int n) {
        int n2 = this.li.size();
        for (int i = 0; i < n; ++i) {
            int n3 = n2 + i;
            this.li.add(new ListWithIntVec(this.sizeVector, n3));
            this.arrAvailable.add(n3);
        }
    }

    public ListWithIntVec get() {
        if (this.arrAvailable.length() == 0) {
            this.initResources(CAPACITY_ADD);
        }
        int n = this.arrAvailable.removeLast();
        ListWithIntVec listWithIntVec = this.li.get(n);
        listWithIntVec.reset();
        return listWithIntVec;
    }

    public void back(ListWithIntVec listWithIntVec) {
        this.arrAvailable.add(listWithIntVec.getPositionInContainer());
    }

    public ListWithIntVec getWithCopy(ListWithIntVec listWithIntVec) {
        ListWithIntVec listWithIntVec2 = this.get();
        listWithIntVec2.copyIntoThis(listWithIntVec);
        return listWithIntVec2;
    }
}

