/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.mcs;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.properties.complexity.IBitArray;
import com.actelion.research.chem.shredder.Fragment;
import java.util.ArrayList;
import java.util.List;

public class BondVector2IdCode {
    private StereoMolecule mol;
    private List<int[]> liRingSets;

    public BondVector2IdCode(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
        this.liRingSets = new ArrayList<int[]>();
        RingCollection ringCollection = stereoMolecule.getRingSet();
        int n = ringCollection.getSize();
        for (int i = 0; i < n; ++i) {
            int[] nArray = ringCollection.getRingBonds(i);
            this.liRingSets.add(nArray);
        }
    }

    public boolean containsFragmentOpenRing(IBitArray iBitArray) {
        boolean bl = false;
        for (int[] nArray : this.liRingSets) {
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (!iBitArray.isBitSet(nArray[i])) continue;
                ++n;
            }
            if (n <= 0 || n >= nArray.length) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getFragmentIdCode(IBitArray iBitArray) {
        StereoMolecule stereoMolecule = this.convert(iBitArray, false);
        Canonizer canonizer = new Canonizer(stereoMolecule);
        String string = canonizer.getIDCode();
        return string;
    }

    public Fragment getFragment(IBitArray iBitArray) {
        StereoMolecule stereoMolecule = this.convert(iBitArray, false);
        Canonizer canonizer = new Canonizer(stereoMolecule);
        String string = canonizer.getIDCode();
        Fragment fragment = new Fragment(string);
        fragment.setMol(stereoMolecule);
        fragment.setSize(stereoMolecule.getBonds());
        return fragment;
    }

    public Fragment getFragment(IBitArray iBitArray, boolean bl) {
        StereoMolecule stereoMolecule = this.convert(iBitArray, bl);
        Canonizer canonizer = new Canonizer(stereoMolecule);
        String string = canonizer.getIDCode();
        Fragment fragment = new Fragment(string);
        fragment.setMol(stereoMolecule);
        fragment.setSize(stereoMolecule.getBonds());
        return fragment;
    }

    private StereoMolecule convert(IBitArray iBitArray, boolean bl) {
        int n;
        int n2 = this.mol.getBonds();
        int n3 = this.mol.getAtoms();
        boolean[] blArray = new boolean[n2];
        boolean[] blArray2 = new boolean[n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (!iBitArray.isBitSet(n)) continue;
            blArray[n] = true;
            ++n4;
            blArray2[this.mol.getBondAtom((int)0, (int)n)] = true;
            blArray2[this.mol.getBondAtom((int)1, (int)n)] = true;
        }
        n = 0;
        for (int i = 0; i < blArray2.length; ++i) {
            if (!blArray2[i]) continue;
            ++n;
        }
        StereoMolecule stereoMolecule = new StereoMolecule(n, n4);
        int[] nArray = this.mol.copyMoleculeByBonds(stereoMolecule, blArray, true, null);
        int n5 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= -1) continue;
            if ((this.mol.getAtomQueryFeatures(nArray[i]) & 8L) > 0L) {
                stereoMolecule.setAtomQueryFeature(n5, 8L, true);
            }
            if ((this.mol.getAtomQueryFeatures(nArray[i]) & 2L) > 0L) {
                stereoMolecule.setAtomQueryFeature(n5, 2L, true);
            }
            ++n5;
        }
        if (bl) {
            int n6;
            boolean[] blArray3 = new boolean[this.mol.getAtoms()];
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (nArray[n6] <= -1) continue;
                blArray3[n6] = true;
            }
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (nArray[n6] <= -1) continue;
                int n7 = n6;
                int n8 = this.mol.getConnAtoms(n7);
                for (int i = 0; i < n8; ++i) {
                    int n9 = this.mol.getConnAtom(n7, i);
                    if (blArray3[n9]) continue;
                    int n10 = stereoMolecule.addAtom(0);
                    int n11 = nArray[n6];
                    stereoMolecule.addBond(n11, n10, 1);
                    stereoMolecule.setAtomQueryFeature(n10, 1L, true);
                }
            }
        }
        stereoMolecule.ensureHelperArrays(7);
        return stereoMolecule;
    }

    public String getFragmentIdCodeCarbonSkeleton(IBitArray iBitArray) {
        StereoMolecule stereoMolecule = this.convert(iBitArray, false);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            stereoMolecule.setAtomicNo(i, 6);
        }
        Canonizer canonizer = new Canonizer(stereoMolecule);
        String string = canonizer.getIDCode();
        return string;
    }
}

