/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io.pdb.parser;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.io.pdb.parser.Residue;

public class ProteinSynthesizer {
    private Molecule3D protein;
    private int terminalC = -1;

    public boolean addResidue(Molecule3D molecule3D) {
        Coordinates coordinates;
        Coordinates coordinates2;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < molecule3D.getAtoms(); ++i) {
            if (molecule3D.getAtomicNo(i) == 7 && molecule3D.getAtomCustomLabel(i) == null) {
                n2 = i;
            }
            if (molecule3D.getAtomicNo(i) != 6 || molecule3D.getAtomCustomLabel(i) != null) continue;
            n3 = i;
        }
        if (this.protein == null) {
            this.protein = molecule3D;
            this.terminalC = n3;
            bl = true;
        } else if (n2 > -1 && this.terminalC > -1 && (coordinates2 = this.protein.getCoordinates(this.terminalC)).distanceSquared(coordinates = molecule3D.getCoordinates(n2)) < Residue.BOND_CUTOFF_SQ) {
            boolean bl2 = true;
            for (int i = 0; i < this.protein.getConnAtoms(this.terminalC) && bl2; ++i) {
                int n4 = this.protein.getConnAtom(this.terminalC, i);
                int n5 = this.protein.getBond(this.terminalC, n4);
                if (this.protein.getAtomicNo(n4) != 8 || this.protein.getBondOrder(n5) != 1) continue;
                bl2 = false;
                n = this.protein.getConnAtom(this.terminalC, i);
            }
            if (n >= 0) {
                this.protein.deleteAtom(n);
                int[] nArray = this.protein.addMolecule(molecule3D);
                this.protein.addBond(this.terminalC, nArray[n2], 1);
                this.terminalC = this.protein.getAllAtoms() - (molecule3D.getAllAtoms() - n3);
                bl = true;
            }
        }
        this.protein.ensureHelperArrays(1);
        return bl;
    }

    public Molecule3D retrieveProtein() {
        return this.protein;
    }
}

