/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileV3Creator;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionEncoder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RXNFileV3Creator {
    public static final String RXN_CODE_TAG = "OCL_RXN_V1.0:";
    private static final String NL = System.lineSeparator();
    private StringBuffer rxnbuffer = null;

    public RXNFileV3Creator(Reaction reaction) {
        this(reaction, null);
    }

    public RXNFileV3Creator(Reaction reaction, String string) {
        Reaction reaction2 = new Reaction(reaction);
        try {
            int n;
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("$RXN V3000" + NL);
            stringWriter.write(string != null ? string : "");
            stringWriter.write(NL + NL);
            stringWriter.write(RXN_CODE_TAG + ReactionEncoder.encode(reaction, true, 11));
            stringWriter.write(NL);
            int n2 = reaction2.getReactants();
            int n3 = reaction2.getProducts();
            stringWriter.write(String.format("M  V30 COUNTS %d %d" + NL, n2, n3));
            double d = this.getScalingFactor(reaction2);
            if (n2 > 0) {
                stringWriter.write("M  V30 BEGIN REACTANT" + NL);
                for (n = 0; n < reaction2.getReactants(); ++n) {
                    stringWriter.write(MolfileV3Creator.writeCTAB(reaction2.getReactant(n), d));
                }
                stringWriter.write("M  V30 END REACTANT" + NL);
            }
            if (n3 > 0) {
                stringWriter.write("M  V30 BEGIN PRODUCT" + NL);
                for (n = 0; n < reaction2.getProducts(); ++n) {
                    stringWriter.write(MolfileV3Creator.writeCTAB(reaction2.getProduct(n), d));
                }
                stringWriter.write("M  V30 END PRODUCT" + NL);
            }
            stringWriter.write("M  END" + NL);
            this.rxnbuffer = stringWriter.getBuffer();
            stringWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error in RXNFileCreator: " + exception);
        }
    }

    private double getScalingFactor(Reaction reaction) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < reaction.getMolecules(); ++i) {
            d += reaction.getMolecule(i).getAverageBondLength() * (double)reaction.getMolecule(i).getAllBonds();
            n += reaction.getMolecule(i).getAllBonds();
        }
        if (n != 0) {
            return (double)n / d;
        }
        return 1.0;
    }

    public String getRXNfile() {
        return this.rxnbuffer != null ? this.rxnbuffer.toString() : null;
    }

    public void writeRXNfile(Writer writer) throws IOException {
        if (this.rxnbuffer == null) {
            throw new IOException("NULL RXNFileBuffer!");
        }
        writer.write(this.rxnbuffer.toString());
    }
}

