/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.forcefield.mmff.EnergyTerm;

public class MMFFPositionConstraint
implements EnergyTerm {
    private double[] refPos;
    private boolean[] constrained;
    private double k;
    private double d;

    public MMFFPositionConstraint(StereoMolecule stereoMolecule, double d, double d2) {
        this.refPos = new double[3 * stereoMolecule.getAllAtoms()];
        this.constrained = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            this.constrained[i] = stereoMolecule.getAtomicNo(i) != 1;
            this.refPos[3 * i] = stereoMolecule.getAtomX(i);
            this.refPos[3 * i + 1] = stereoMolecule.getAtomY(i);
            this.refPos[3 * i + 2] = stereoMolecule.getAtomZ(i);
        }
        this.k = d;
        this.d = d2;
    }

    @Override
    public double getEnergy(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; i += 3) {
            int n = i / 3;
            if (!this.constrained[n]) continue;
            double d2 = dArray[i] - this.refPos[i];
            double d3 = dArray[i + 1] - this.refPos[i + 1];
            double d4 = dArray[i + 2] - this.refPos[i + 2];
            double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
            double d6 = 0.0;
            d6 = d5 > this.d ? d5 - this.d : 0.0;
            d += 0.5 * this.k * d6 * d6;
        }
        return d;
    }

    @Override
    public void getGradient(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; i += 3) {
            int n = i / 3;
            if (!this.constrained[n]) continue;
            double d = dArray[i] - this.refPos[i];
            double d2 = dArray[i + 1] - this.refPos[i + 1];
            double d3 = dArray[i + 2] - this.refPos[i + 2];
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            double d5 = 0.0;
            d5 = d4 > this.d ? d4 - this.d : 0.0;
            int n2 = i;
            dArray2[n2] = dArray2[n2] + d5 * d / Math.max(d4, 1.0E-8);
            int n3 = i + 1;
            dArray2[n3] = dArray2[n3] + d5 * d2 / Math.max(d4, 1.0E-8);
            int n4 = i + 2;
            dArray2[n4] = dArray2[n4] + d5 * d3 / Math.max(d4, 1.0E-8);
        }
    }
}

