/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring.plp;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.HashMap;
import java.util.Map;

public class PLPTerm
implements PotentialEnergyTerm {
    public static final Map<String, Double> HBOND_TERM = new HashMap<String, Double>();
    public static final Map<String, Double> METAL_TERM;
    public static final Map<String, Double> BURIED_TERM;
    public static final Map<String, Double> NONPOLAR_TERM;
    private int recAtom;
    private int ligAtom;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    private double F;
    private double D_sq;
    private Conformer ligand;
    private Conformer receptor;

    private PLPTerm(Conformer conformer, Conformer conformer2, int n, int n2, Map<String, Double> map) {
        this.A = map.get("A");
        this.B = map.get("B");
        this.C = map.get("C");
        this.D = map.get("D");
        this.E = map.get("E");
        this.F = map.get("F");
        this.D_sq = this.D * this.D;
        this.recAtom = n;
        this.ligAtom = n2;
        this.ligand = conformer2;
        this.receptor = conformer;
    }

    public static PLPTerm create(Conformer conformer, Conformer conformer2, int n, int n2, Map<String, Double> map) {
        return new PLPTerm(conformer, conformer2, n, n2, map);
    }

    @Override
    public double getFGValue(double[] dArray) {
        Coordinates coordinates = this.receptor.getCoordinates(this.recAtom);
        Coordinates coordinates2 = this.ligand.getCoordinates(this.ligAtom);
        Coordinates coordinates3 = coordinates.subC(coordinates2);
        double d = coordinates3.distSq();
        Coordinates coordinates4 = new Coordinates();
        double d2 = 0.0;
        if (d > this.D_sq) {
            d2 = 0.0;
        } else {
            double d3 = 0.0;
            double d4 = Math.sqrt(d);
            if (d4 < this.A) {
                d3 = -this.F / this.A * (1.0 / d4);
                coordinates4 = coordinates3.scaleC(d3);
                d2 = this.F * (this.A - d4) / this.A;
            } else if (d4 < this.B) {
                d3 = this.E / (this.B - this.A) * (1.0 / d4);
                coordinates4 = coordinates3.scaleC(d3);
                d2 = this.E * (d4 - this.A) / (this.B - this.A);
            } else if (d4 < this.C) {
                d3 = 0.0;
                coordinates4 = coordinates3.scaleC(d3);
                d2 = this.E;
            } else if (d4 <= this.D) {
                d3 = -this.E / (this.D - this.C) * (1.0 / d4);
                coordinates4 = coordinates3.scaleC(d3);
                d2 = this.E * (this.D - d4) / (this.D - this.C);
            }
        }
        int n = 3 * this.ligAtom;
        dArray[n] = dArray[n] - coordinates4.x;
        int n2 = 3 * this.ligAtom + 1;
        dArray[n2] = dArray[n2] - coordinates4.y;
        int n3 = 3 * this.ligAtom + 2;
        dArray[n3] = dArray[n3] - coordinates4.z;
        return d2;
    }

    static {
        HBOND_TERM.put("A", 2.3);
        HBOND_TERM.put("B", 2.6);
        HBOND_TERM.put("C", 3.1);
        HBOND_TERM.put("D", 3.4);
        HBOND_TERM.put("E", -1.0);
        HBOND_TERM.put("F", 20.0);
        METAL_TERM = new HashMap<String, Double>();
        METAL_TERM.put("A", 1.4);
        METAL_TERM.put("B", 2.2);
        METAL_TERM.put("C", 2.6);
        METAL_TERM.put("D", 2.8);
        METAL_TERM.put("E", -1.0);
        METAL_TERM.put("F", 20.0);
        BURIED_TERM = new HashMap<String, Double>();
        BURIED_TERM.put("A", 3.4);
        BURIED_TERM.put("B", 3.6);
        BURIED_TERM.put("C", 4.5);
        BURIED_TERM.put("D", 5.5);
        BURIED_TERM.put("E", -0.1);
        BURIED_TERM.put("F", 20.0);
        NONPOLAR_TERM = new HashMap<String, Double>();
        NONPOLAR_TERM.put("A", 3.4);
        NONPOLAR_TERM.put("B", 3.6);
        NONPOLAR_TERM.put("C", 4.5);
        NONPOLAR_TERM.put("D", 5.5);
        NONPOLAR_TERM.put("E", -0.4);
        NONPOLAR_TERM.put("F", 20.0);
    }
}

