/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.docking.scoring.ChemPLP;
import com.actelion.research.chem.docking.scoring.chemscore.SimpleMetalTerm;
import com.actelion.research.chem.docking.scoring.plp.PLPTerm;
import com.actelion.research.chem.docking.scoring.plp.REPTerm;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.phesa.pharmacophore.pp.IPharmacophorePoint;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;

public class ProbeScanning {
    private IPharmacophorePoint.Functionality probeType;
    private Set<Integer> receptorAcceptors;
    private Set<Integer> receptorDonorHs;
    private Set<Integer> receptorDonorHPos;
    private Set<Integer> receptorAcceptorNeg;
    private Set<Integer> receptorMetals;
    private Set<Integer> receptorDonors;
    private Set<Integer> ligandAcceptors;
    private Set<Integer> ligandDonors;
    private Set<Integer> ligandDonorPos;
    private Set<Integer> ligandAcceptorNeg;
    private StereoMolecule receptor;
    private Conformer receptorConf;
    private Probe probe;
    private List<PotentialEnergyTerm> plp;
    private List<PotentialEnergyTerm> chemscoreMetal;
    private List<HBProbeTerm> chemscoreHbond;
    private Set<Integer> bindingSiteAtoms;

    public ProbeScanning(StereoMolecule stereoMolecule, Set<Integer> set, MoleculeGrid moleculeGrid) {
        this.bindingSiteAtoms = set;
        this.receptorConf = new Conformer(stereoMolecule);
        this.receptorAcceptors = new HashSet<Integer>();
        this.receptorDonorHs = new HashSet<Integer>();
        this.receptorDonorHPos = new HashSet<Integer>();
        this.receptorAcceptorNeg = new HashSet<Integer>();
        this.receptorMetals = new HashSet<Integer>();
        this.receptorDonors = new HashSet<Integer>();
        this.receptor = stereoMolecule;
        ChemPLP.identifyHBondFunctionality(stereoMolecule, this.receptorAcceptors, this.receptorDonorHs, this.receptorDonors, this.receptorMetals, this.receptorAcceptorNeg, this.receptorDonorHPos);
    }

    public void init(Probe probe) {
        this.probe = probe;
        this.plp = new ArrayList<PotentialEnergyTerm>();
        this.chemscoreHbond = new ArrayList<HBProbeTerm>();
        this.chemscoreMetal = new ArrayList<PotentialEnergyTerm>();
        this.ligandAcceptors = new HashSet<Integer>();
        this.ligandDonors = new HashSet<Integer>();
        this.ligandDonorPos = new HashSet<Integer>();
        this.ligandAcceptorNeg = new HashSet<Integer>();
        IPharmacophorePoint.Functionality functionality = probe.type;
        switch (functionality) {
            case ACCEPTOR: {
                this.ligandAcceptors.add(0);
                break;
            }
            case DONOR: {
                this.ligandDonors.add(0);
                break;
            }
            case NEG_CHARGE: {
                this.ligandAcceptorNeg.add(0);
                this.ligandAcceptors.add(0);
                break;
            }
            case POS_CHARGE: {
                this.ligandDonorPos.add(0);
                this.ligandDonors.add(0);
                break;
            }
        }
        for (int n : this.bindingSiteAtoms) {
            int[] nArray;
            boolean bl;
            if (this.receptor.getAtomicNo(n) == 1) {
                if (!this.receptorDonorHs.contains(n)) continue;
                int n3 = this.receptor.getConnAtom(n, 0);
                bl = this.receptorDonorHPos.contains(n);
                for (int n4 : this.ligandAcceptors) {
                    nArray = new int[]{};
                    boolean bl2 = this.ligandAcceptorNeg.contains(n4);
                    double d = 1.0;
                    if (bl && bl2) {
                        d = 2.0;
                    }
                    HBProbeTerm hBProbeTerm = HBProbeTerm.create(this.receptorConf, probe.probeConf, n4, n3, n, true, false, nArray, d);
                    this.chemscoreHbond.add(hBProbeTerm);
                }
                continue;
            }
            if (this.receptorDonors.contains(n)) {
                for (int i = 0; i < probe.probeConf.getMolecule().getAtoms(); ++i) {
                    PotentialEnergyTerm potentialEnergyTerm;
                    if (this.ligandAcceptors.contains(i)) {
                        potentialEnergyTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.HBOND_TERM);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    if (this.ligandDonors.contains(i)) {
                        potentialEnergyTerm = REPTerm.create(this.receptorConf, probe.probeConf, n, i);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    potentialEnergyTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.BURIED_TERM);
                    this.plp.add(potentialEnergyTerm);
                }
                continue;
            }
            if (this.receptorAcceptors.contains(n)) {
                int[] nArray2 = IntStream.range(0, this.receptor.getConnAtoms(n)).map(n2 -> this.receptor.getConnAtom(n, n2)).toArray();
                bl = this.receptorAcceptorNeg.contains(n);
                for (int i = 0; i < probe.probeConf.getMolecule().getAtoms(); ++i) {
                    if (this.ligandDonors.contains(i)) {
                        boolean bl3 = this.ligandDonorPos.contains(i);
                        double d = 1.0;
                        if (bl && bl3) {
                            d = 2.0;
                        }
                        HBProbeTerm hBProbeTerm = HBProbeTerm.create(this.receptorConf, probe.probeConf, n, i, -1, false, true, nArray2, d);
                        this.chemscoreHbond.add(hBProbeTerm);
                        PLPTerm pLPTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.HBOND_TERM);
                        this.plp.add(pLPTerm);
                        continue;
                    }
                    if (this.ligandAcceptors.contains(i)) {
                        REPTerm rEPTerm = REPTerm.create(this.receptorConf, probe.probeConf, n, i);
                        this.plp.add(rEPTerm);
                        continue;
                    }
                    PLPTerm pLPTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                }
                continue;
            }
            if (this.receptorMetals.contains(n)) {
                for (int i = 0; i < probe.probeConf.getMolecule().getAtoms(); ++i) {
                    PotentialEnergyTerm potentialEnergyTerm;
                    if (this.ligandDonors.contains(i)) {
                        potentialEnergyTerm = REPTerm.create(this.receptorConf, probe.probeConf, n, i);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    if (this.ligandAcceptors.contains(i)) {
                        potentialEnergyTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.METAL_TERM);
                        this.plp.add(potentialEnergyTerm);
                        continue;
                    }
                    potentialEnergyTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.BURIED_TERM);
                    this.plp.add(potentialEnergyTerm);
                }
                for (int n5 : this.ligandAcceptors) {
                    double d = 1.0;
                    if (this.ligandAcceptorNeg.contains(n5)) {
                        d = 2.0;
                    }
                    nArray = new int[]{};
                    SimpleMetalTerm simpleMetalTerm = SimpleMetalTerm.create(this.receptorConf, probe.probeConf, n5, n, nArray, d);
                    this.chemscoreMetal.add(simpleMetalTerm);
                }
                continue;
            }
            for (int i = 0; i < probe.probeConf.getMolecule().getAtoms(); ++i) {
                PLPTerm pLPTerm;
                if (this.ligandDonors.contains(i)) {
                    pLPTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                    continue;
                }
                if (this.ligandAcceptors.contains(i)) {
                    pLPTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.BURIED_TERM);
                    this.plp.add(pLPTerm);
                    continue;
                }
                pLPTerm = PLPTerm.create(this.receptorConf, probe.probeConf, n, i, PLPTerm.NONPOLAR_TERM);
                this.plp.add(pLPTerm);
            }
        }
    }

    public double getScore() {
        double d = 0.0;
        double[] dArray = new double[3];
        for (HBProbeTerm object : this.chemscoreHbond) {
            d += object.getEnergy();
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.chemscoreMetal) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        for (PotentialEnergyTerm potentialEnergyTerm : this.plp) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }

    private static class HBProbeTerm {
        private static final double D0 = 1.85;
        private static final double D1 = 0.25;
        private static final double D2 = 0.65;
        private static final double PHI0 = Math.PI;
        private static final double PHI1 = 0.5235987755982988;
        private static final double PHI2 = 1.3962634015954636;
        private static final double PSI0 = Math.PI;
        private static final double PSI1 = 1.3962634015954636;
        private static final double PSI2 = 1.7453292519943295;
        private static final double ENERGY = -3.0;
        private Conformer receptor;
        private Conformer probe;
        private int acceptor;
        private int donor;
        private int hydrogen;
        private double scale;
        private boolean isProbeAcceptor;
        private boolean isProbeDonor;
        private int[] acceptorNeighbours;

        private HBProbeTerm(Conformer conformer, Conformer conformer2, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray, double d) {
            this.receptor = conformer;
            this.probe = conformer2;
            this.acceptor = n;
            this.donor = n2;
            this.hydrogen = n3;
            this.scale = d;
            this.isProbeAcceptor = bl;
            this.isProbeDonor = bl2;
            this.acceptorNeighbours = nArray;
            assert (bl != bl2);
        }

        public static HBProbeTerm create(Conformer conformer, Conformer conformer2, int n, int n2, int n3, boolean bl, boolean bl2, int[] nArray, double d) {
            return new HBProbeTerm(conformer, conformer2, n, n2, n3, bl, bl2, nArray, d);
        }

        private double getDistTerm() {
            double d;
            double d2;
            Coordinates coordinates;
            Coordinates coordinates2;
            double d3 = 0.0;
            Coordinates coordinates3 = this.isProbeAcceptor ? this.probe.getCoordinates(this.acceptor) : this.receptor.getCoordinates(this.acceptor);
            if (this.isProbeDonor) {
                coordinates2 = this.probe.getCoordinates(this.donor);
                Coordinates coordinates4 = coordinates3.subC(coordinates2);
                double d4 = 1.0 / coordinates4.dist();
                coordinates = coordinates2.addC(coordinates4.scaleC(d4));
                assert (coordinates.subC(coordinates2).dist() - 1.0 < 0.001);
            } else {
                coordinates = this.receptor.getCoordinates(this.hydrogen);
            }
            if ((d2 = (d = (coordinates2 = coordinates3.subC(coordinates)).dist()) - 1.85) < 0.0) {
                d2 = -d2;
            }
            d3 = d2 < 0.25 ? 1.0 : (d2 > 0.65 ? 0.0 : (0.65 - d2) / 0.4);
            return d3;
        }

        private double getAngleTerm(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, double d, double d2, double d3) {
            boolean[] blArray = new boolean[]{bl, bl2, bl3};
            int n4 = 0;
            for (boolean bl4 : blArray) {
                if (!bl4) continue;
                ++n4;
            }
            double d4 = 0.0;
            if (n4 == 2) {
                d4 = 1.0;
            } else {
                Coordinates coordinates;
                Coordinates coordinates2 = bl ? this.probe.getCoordinates(n) : this.receptor.getCoordinates(n);
                Coordinates coordinates3 = bl2 ? this.probe.getCoordinates(n2) : this.receptor.getCoordinates(n2);
                Coordinates coordinates4 = bl3 ? this.probe.getCoordinates(n3) : this.receptor.getCoordinates(n3);
                Coordinates coordinates5 = coordinates2.subC(coordinates3).unit();
                double d5 = coordinates5.cosAngle(coordinates = coordinates4.subC(coordinates3).unit());
                double d6 = Math.acos(d5) - d;
                if (d6 < 0.0) {
                    d6 = -d6;
                }
                d4 = d6 < d2 ? 1.0 : (d6 > d3 ? 0.0 : (d3 - d6) / (d3 - d2));
            }
            return d4;
        }

        public double getEnergy() {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            double d = 0.0;
            d = this.getDistTerm();
            if (d != 0.0) {
                arrayList.add(d);
                d = this.getAngleTerm(this.donor, this.hydrogen, this.acceptor, this.isProbeDonor, this.isProbeDonor, this.isProbeAcceptor, Math.PI, 0.5235987755982988, 1.3962634015954636);
                arrayList.add(d);
                if (this.isProbeAcceptor) {
                    d = this.getAngleTerm(-1, this.acceptor, this.hydrogen, this.isProbeAcceptor, this.isProbeAcceptor, this.isProbeDonor, Math.PI, 1.3962634015954636, 1.7453292519943295);
                    arrayList.add(d);
                } else {
                    for (int n : this.acceptorNeighbours) {
                        d = this.getAngleTerm(n, this.acceptor, this.donor, this.isProbeAcceptor, this.isProbeAcceptor, this.isProbeDonor, Math.PI, 1.3962634015954636, 1.7453292519943295);
                        arrayList.add(d);
                    }
                }
            } else {
                arrayList.add(0.0);
            }
            double d2 = this.scale * -3.0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                double d3 = (Double)iterator.next();
                d2 *= d3;
            }
            return d2;
        }
    }

    public static class Probe {
        Conformer probeConf;
        IPharmacophorePoint.Functionality type;

        public Probe(Coordinates coordinates, IPharmacophorePoint.Functionality functionality) {
            StereoMolecule stereoMolecule = new StereoMolecule();
            stereoMolecule.addAtom(6);
            stereoMolecule.ensureHelperArrays(1);
            this.probeConf = new Conformer(stereoMolecule);
            this.probeConf.setCoordinates(0, coordinates);
            this.type = functionality;
        }

        public void updateCoordinates(Coordinates coordinates) {
            this.probeConf.setCoordinates(0, coordinates);
        }
    }
}

