/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.scoring;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondRotationHelper;
import com.actelion.research.chem.docking.LigandPose;
import com.actelion.research.chem.docking.scoring.AbstractScoringEngine;
import com.actelion.research.chem.docking.scoring.idoscore.InteractionTerm;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import com.actelion.research.chem.interactionstatistics.InteractionAtomTypeCalculator;
import com.actelion.research.chem.io.pdb.converter.MoleculeGrid;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class IdoScore
extends AbstractScoringEngine {
    private static final double STRAIN_CUTOFF = 20.0;
    private List<PotentialEnergyTerm> ligStrain;
    private List<PotentialEnergyTerm> constraint;
    private List<PotentialEnergyTerm> interactionEnergy;
    private BondRotationHelper torsionHelper;
    private int[] receptorAtomTypes;
    private int[] ligAtomTypes;
    private ForceFieldMMFF94 ff;
    private double e0;

    public IdoScore(StereoMolecule stereoMolecule, Set<Integer> set, int[] nArray, MoleculeGrid moleculeGrid) {
        super(stereoMolecule, set, moleculeGrid);
        this.receptorAtomTypes = nArray;
    }

    @Override
    public void init(LigandPose ligandPose, double d) {
        this.candidatePose = ligandPose;
        this.e0 = d;
        this.ligStrain = new ArrayList<PotentialEnergyTerm>();
        this.constraint = new ArrayList<PotentialEnergyTerm>();
        this.interactionEnergy = new ArrayList<PotentialEnergyTerm>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StereoMolecule stereoMolecule = ligandPose.getLigConf().getMolecule();
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            arrayList.add(InteractionAtomTypeCalculator.getAtomType(stereoMolecule, i));
        }
        this.ligAtomTypes = new int[arrayList.size()];
        IntStream.range(0, this.ligAtomTypes.length).forEach(n -> {
            this.ligAtomTypes[n] = (Integer)arrayList.get(n);
        });
        this.torsionHelper = new BondRotationHelper(stereoMolecule);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dielectric constant", 80.0);
        ForceFieldMMFF94.initialize("MMFF94s+");
        this.ff = new ForceFieldMMFF94(stereoMolecule, "MMFF94s+", hashMap);
        this.initiateInteractionTerms();
    }

    private void initiateInteractionTerms() {
        Iterator iterator = this.bindingSiteAtoms.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (int i = 0; i < this.candidatePose.getLigConf().getMolecule().getAtoms(); ++i) {
                InteractionTerm interactionTerm = InteractionTerm.create(this.receptorConf, this.candidatePose.getLigConf(), n, i, this.receptorAtomTypes, this.ligAtomTypes);
                if (interactionTerm == null) continue;
                this.interactionEnergy.add(interactionTerm);
            }
        }
    }

    public double getStrain(double[] dArray) {
        double d = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.ligStrain) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }

    @Override
    public double getFGValue(double[] dArray) {
        double d = 0.0;
        for (PotentialEnergyTerm potentialEnergyTerm : this.interactionEnergy) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        d += this.getBumpTerm();
        this.ff.setState(this.candidatePose.getCartState());
        double d2 = this.ff.getTotalEnergy();
        if (d2 - this.e0 > 20.0) {
            this.ff.addGradient(dArray);
            d += d2 - this.e0;
        }
        return d;
    }

    @Override
    public void updateState() {
        this.ff.setState(this.candidatePose.getState());
    }

    @Override
    public double getScore() {
        double[] dArray = new double[this.candidatePose.getLigConf().getMolecule().getAllAtoms() * 3];
        double d = this.getBumpTerm();
        for (PotentialEnergyTerm potentialEnergyTerm : this.interactionEnergy) {
            d += potentialEnergyTerm.getFGValue(dArray);
        }
        return d;
    }

    @Override
    public Map<String, Double> getContributions() {
        return null;
    }
}

